function [line_error] = Back_projection_error_GimLee3(pose_estimated,S2D,E2D,S3D,E3D)



if ~isnan(pose_estimated)
    
    
    lines_2D_start = [S2D] ;
    lines_2D_end= [E2D] ;
    lines_3D_start= [S3D, ones(size(S3D,1),1) ];
    lines_3D_end= [E3D, ones(size(E3D,1),1)];
    
    
    
    lines_3D_start_A =( pose_estimated * lines_3D_start')';
    lines_3D_start_B = lines_3D_start_A(:,1:3)./lines_3D_start_A(:,4);
    
    lines_3D_end_A =( pose_estimated * lines_3D_end')';
    lines_3D_end_B = lines_3D_end_A(:,1:3)./lines_3D_end_A(:,4);
    
    lines_3D_start_C = lines_3D_start_B(:,1:3)./lines_3D_start_B(:,3);
    lines_3D_end_C = lines_3D_end_B(:,1:3)./lines_3D_end_B(:,3);
    
    
    x1 = lines_2D_start(:,1);
    y1 = lines_2D_start(:,2);
    
    x2 = lines_2D_end(:,1);
    y2 = lines_2D_end(:,2);
    
    x3 = lines_3D_start_C(:,1);
    y3 = lines_3D_start_C(:,2);
    
    x4 = lines_3D_end_C(:,1);
    y4 = lines_3D_end_C(:,2);
    
    
    pt = [x1, y1,zeros(size(x1,1),1) ] ;  v1 = [x3, y3,zeros(size(x1,1),1)];  v2=[x4, y4,zeros(size(x1,1),1)];
    distanceAN= point_to_line_distance_vec(pt, v1, v2);
    
    pt = [x2, y2,zeros(size(x1,1),1) ] ;  v1 = [x3, y3,zeros(size(x1,1),1)];  v2=[x4, y4,zeros(size(x1,1),1)];
    distanceBN = point_to_line_distance_vec(pt, v1, v2);    
    
    line_error = (distanceAN + distanceBN) ./ (2.*(vecnorm([x1 y1]'-[x2 y2]')));
    
    %
else
    
    line_error(1:size(p1_sx,1))=1000;
end


end
