function Data = generateDataAbs( input,lineNum)

% Normalised image coordinates
% 3xn  corresponding 2D measurements
p1 = input.Camera(1).Line(:).start(:,:)';
p2 = input.Camera(1).Line(:).end(:,:)';

p1 = p1(:,1:lineNum);
p2 = p2(:,1:lineNum);

% ground truth pose (world to camera)
% R_wc = SyntheticStruct.data(set).Camera(1).R;
% T_wc = SyntheticStruct.data(set).Camera(1).t;


% 3D coordinates of the 3D line endpoints 
% 3xn  corresponding 3D measurements
P1_w = input.line3D(:).start(:,:)';
P2_w = input.line3D(:).end(:,:)';

P1_w = P1_w(:,1:lineNum);
P2_w = P2_w(:,1:lineNum);

% P1_w_original = input.line3D(:).start(:,:)';
% P2_w_original = input.line3D(:).end(:,:)';


% Normalisation of the 3D enpoints into a the unite cube
P3D = [P1_w,P2_w]';
[normalised_3D_points, N3] = preproc_3D( P3D );
P1_w = normalised_3D_points(1:3,1:length(P1_w));
P2_w = normalised_3D_points(1:3,length(P1_w)+1:end);



% calculation of the unite direction vector of the 3D lines
Vww=P2_w-P1_w;
Directions = Vww ./ vecnorm(Vww);

% calculation of the normals of the projection planes
Vww2D=p2-p1;
Directions2D = Vww2D ./ vecnorm(Vww2D);
normals=(cross(Directions2D,p1)) ./vecnorm(cross(Directions2D,p1));


% Note: the order of the corresspandance between the 3D and 2D coordinates are respected


% save data in an intermediate variable for the solver 
Data.p1 = p1;
Data.p2 = p2;
Data.P1_w = P1_w;
Data.P2_w = P2_w;
% Data.P1_w_original = P1_w_original;
% Data.P2_w_original = P2_w_original;
% Data.R_wc = R_wc;
% Data.T_wc = T_wc;
Data.Directions = Directions;
Data.normals = normals;
Data.N3 = N3;
Data.cameraType = 'Persp';


end
