function Data = generateDataRel_RANSAC( input,inlierIdx,cam,Rot,trans)

% Normalised image coordinates
% 3xn  corresponding 2D measurements
p1 = input.Camera(cam).Line(:).start(inlierIdx,:)';
p2 = input.Camera(cam).Line(:).end(inlierIdx,:)';


% R_wc = input..Camera(cam).R;
% T_wc= input..Camera(cam).t;

% 3D coordinates of the 3D line endpoints 
% 3xn  corresponding 3D measurements
P1_w = input.line3D(:).start(inlierIdx,:)';
P2_w = input.line3D(:).end(inlierIdx,:)';



% Normalisation of the 3D enpoints into a the cubic unit around the origin of the world
% coordinates system
P3D = [P1_w,P2_w]';


[normalised_3D_points, N3] = preproc_3D( P3D );
P1_w = normalised_3D_points(1:3,1:length(P1_w));
P2_w = normalised_3D_points(1:3,length(P1_w)+1:end);

Vww_original=P2_w-P1_w;
Directions_original = Vww_original ./ vecnorm(Vww_original);

P1_w_original = P1_w;
P2_w_original = P2_w;

AbsPose = [Rot trans; 0 0 0 1];

P1_w = Rot * P1_w + trans;
P2_w = Rot * P2_w + trans;

% calculation of the unite direction vector of the 3D lines
Vww=P2_w-P1_w;
Directions = Vww ./ vecnorm(Vww);

% calculation of the normals of the projection planes
Vww2D=p2-p1;
Directions2D = Vww2D ./ vecnorm(Vww2D);
normals=(cross(Directions2D,p1)) ./vecnorm(cross(Directions2D,p1));

% save data
Data.p1 = p1;
Data.p2 = p2;
Data.P1_w = P1_w;
Data.P2_w = P2_w;

Data.P1_w_original = P1_w_original;
Data.P2_w_original = P2_w_original;

% Data.R_wc = R_wc;
% Data.T_wc = T_wc;
Data.Directions = Directions;
Data.Directions_original = Directions_original;

Data.normals = normals;
Data.N3 = N3;



end
