function R = rotMfromAngleRad3 (rx, ry, rz)

% Correct one, Jul.2.2019.
% Hichem. Robi, Use this one for all tests

%%%  given in RIGHT handed coordinate system

% http://inside.mines.edu/fs_home/gmurray/ArbitraryAxisRotation/
% https://sites.google.com/site/glennmurray/Home/rotation-matrices-and-formulas/rotation-about-an-arbitrary-axis-in-3-dimensions
% http://answers.unity3d.com/storage/temp/12048-lefthandedtorighthanded.pdf

% The rotation matrix composed here is one that works as: RzRyRx*X
% That is, it first rotates about axis x, then y, then z

% Rparam = [gammai, betai,alphai];
% Rparam = [rx,ry,rz]; degrees


r11 = cos(rz) * cos(ry);
r12 = cos(rz) * sin(ry) * sin(rx) - sin(rz) * cos(rx) ;
r13 = cos(rz) * sin(ry) * cos(rx) + sin(rz) * sin(rx);

r21 = sin(rz) * cos(ry);
r22 = sin(rz) * sin(ry) * sin(rx) + cos(rz) * cos(rx);
r23 = sin(rz) * sin(ry) * cos(rx) - cos(rz) * sin(rx);

r31 = - sin(ry);
r32 = cos(ry) * sin(rx);
r33 = cos(ry) * cos(rx);


R = [ r11 r12 r13;
    r21 r22 r23;
    r31 r32 r33 ];

end