% ------------------------------------------------------------------------
% [1]: Hichem Abdellali, Robert Frohlich, Zoltan Kato ;
% A Direct Least-Squares Solution to Multi-View Absolute and Relative 
% Pose from 2D-3D Perspective Line Pairs; IEEE International
% Conference on Computer Vision (ICCV), 2019.
% All rights reserved.
% ------------------------------------------------------------------------

% published: 2020-04-24,
% Authors: Hichem Abdellali, Robert Frohlich, Zoltan Kato  using Matlab (R2018b)
% All rights reserved.

% Important!
% ------------------------------------------------------------------------
% Please cite our [1] publication whenever you use the implementation.


% Introduction
% ------------------------------------------------------------------------

% This software package contains the full algorithm (MRPnL LM) as described
% in paper [1].


% Installation
% ------------------------------------------------------------------------

% This package does not require any installation. Package contains all
% necessary functions. the solver needs endpoints from 2D-3D line
% coorespandances (an example is provided),

% ------------------------------------------------------------------------
% -------------------------------- NOTE ----------------------------------
% ------------------------------------------------------------------------
% we assume a calibrated perspective camera, and we work with 
% the equivalent normalized image coordinates. 
% If our camera is a calibrated camera and we have a matrix M of size 3xn 
% which contains the 2D coordinates with homogenous 
% coordinate representation in the image plane then we can normalize 
% the coordinates as follows:
% temp = inv(K) * M;
% for i=1:n
%   M_normalized(:,i) = temp(:,i) / temp(3,i)
% end

% ------------------------------------------------------------------------
% ---------------------------- Main input --------------------------------
% ------------------------------------------------------------------------
%- input.Camera(i).Line.start = normalized coordinates of the image line 
%  segment startpoints.
%- input.Camera(i).Line.end = normalized coordinates of the image line
%  segment endpoints.
%- input.line3D.start = start points of the 3D line segments in the 
%  world coordinates.
%- input.line3D.end = end points of the 3D line segments in the 
%   world coordinates.
%- type: referring to the solver generator used in [1] to generate the
%  solver it can be 
%    1 : it is a calling the solver generated with the matlab based
%       solver generator from kukelova 
%    2 : it is a calling the solver generated with the c++ solver generated 
%       from ( we used mex to be able to run it from matlab)
%- camNum: number of camera. 
%- lineNum : number of 2D-3D line pairs to be used.


% ------------------------------------------------------------------------
% ----------------------------- output -----------------------------------
% ------------------------------------------------------------------------
% poses : a cell which contains a list of poses of 4*4 matrix
% poses{1} acts from the world coordinate system to the reference camera ('Absolute pose').
% poses{2:camNum} acts from the reference camera to the other cameras ('Relative Poses').
% Note that the output poses are already denormalized to the original world
% coordinate system.


% ------------------------------------------------------------------------
% ------------------------------ Tests -----------------------------------
% ------------------------------------------------------------------------
% run this script "HOW_TO_RUN.m". an example will be loaded from  Input.mat
% and Input_Ransac.mat it contains a configuration of 5 cameras 
%(first one is the reference), and 60 2D-3D line correspondances, 

restoredefaultpath
load('Input.mat');


addpath Normalizing3D
addpath Functions
addpath Solver
addpath RANSAC


camNum = 5;
lineNum = 60;
type=1;

% MRPnL with one camera and returning the all solutions sorted
% based on the line backprojection error
% ------------------------------------------------------------------------
poses1 = MRPnL_all_solutions(input,lineNum,type);

% full algorithm published in [1] (MRPnL LM) (it includes the
% refienemnt step using levenberg marquardt with fsolve) 
% ------------------------------------------------------------------------
poses2 = MRPnL_LM(input,camNum,lineNum,type);

%  Test for (only the direct least squares solver)
% ------------------------------------------------------------------------
poses3 = MRPnL(input,camNum,lineNum,type);


% RANSAC demo with one camera,using 120 lines, 60 are
% outliers, threshold is the line backprojectoion threshold that separate the
% inliers from the outliers
% ------------------------------------------------------------------------
load('Input_Ransac.mat');
lineNum = 120;
type=1;
threshold = 0.0091;
poses4 = MRPnL_RANSAC(input,camNum,lineNum,type,threshold);

%[~,errRZ,errRY,errRX]= cal_rotation_err_proposed(poses1{1}(1:3,1:3), input.Camera(1).R);
%errT = cal_translation_err_proposed(poses1{1}(1:3,4), input.Camera(1).t)/100000;

% Last version