function [Poses] = MRPnL_LM(input,camNum,lineNum,type)




% NORMALISATION of the 3D data into the cubic unit around the origin of
% the world frame
% Calculation of the normals and the unite direction of the 3D lines
% ------------------------------------------------------------------

D = generateDataAbs(input,lineNum);


% calling the solver (MRPnL) for the reference camera to estimates the
% aboslute pose
% ------------------------------------------------------------------

[R_selectedabs,T_selectedabs,number] = Solver_for_Rotation_MRPnL_cubic(D,type);
numberofSolutions(1) = number;

if isnan(R_selectedabs)
    warning('No solution can be found! please check your data.');
end

% Denormalisation of the pose into the original world coordinate sysetm
% ------------------------------------------------------------------

Denorm_pose = [R_selectedabs T_selectedabs; 0 0 0 1]*  (D.N3);
Denorm_pose1=Denorm_pose/norm(Denorm_pose(1:3,1:3));
R_selectedabs1 = Denorm_pose1(1:3,1:3);
T_selectedabs1 = Denorm_pose1(1:3,4);


% preparation of the initialisation variable x0 for fsolve.
% x0 is the variable to be passed to fsolve which contains the absolute and relative rotation and translation!
% we need also the direction vectors and the normals to be passed to
% fsolve, plus a point on the 3D lines
% ------------------------------------------------------------------

[~, ~, ~,angleX ,angleY ,angleZ] = rotAnglefromMatrix2 (R_selectedabs1);

x0(1,1) = angleX;
x0(1,2) = angleY;
x0(1,3) = angleZ;
x0(1,4) = T_selectedabs(1);
x0(1,5) = T_selectedabs(2);
x0(1,6) = T_selectedabs(3);

Directions{1,:,:} = D.Directions;
normals{1,:,:} = D.normals;
P1_w{1,:,:} = D.P1_w;


% process the other camera if any!
% same steps are done for the other cameras when >= 2
% ------------------------------------------------------------------

for cam=2:camNum
    
    % Transforming the data with the absolute pose: [R_selectedabs T_selectedabs; 0 0 0 1]
    % NORMALISATION of the 3D data into the cubic unit around the origin of
    % the world frame
    % Calculation of the normals and the unite direction of the 3D lines
    % ------------------------------------------------------------------
    
    D = generateDataRel( input,cam,lineNum,R_selectedabs,T_selectedabs);
    
    
    % calling the direct solver (MRPnL) for the reference camera to estimates the
    % relative pose
    % ------------------------------------------------------------------
    
    [R_selected,T_selected,number] = Solver_for_Rotation_MRPnL_cubic(D,type);
    numberofSolutions(cam) = number;
    
    
    % Denormalisation of the pose into the original world coordinate sysetm
    % ------------------------------------------------------------------
    
    poseabs = [R_selectedabs T_selectedabs; 0 0 0 1]*  (D.N3);
    poseabs_norm = poseabs/norm(poseabs(1:3,1:3));
    
    fullpose = [R_selected T_selected; 0 0 0 1] *poseabs ;
    fullpose = fullpose/norm(fullpose(1:3,1:3));
    
    Denorm_pose1 = fullpose * inv(poseabs_norm);
    
    R_selected1 = Denorm_pose1(1:3,1:3);
    T_selected1 = Denorm_pose1(1:3,4)/norm(poseabs(1:3,1:3));
    
    
    
    
    % preparation of the initialisation variable x0 for fsolve.
    % x0 is the variable to be passed to fsolve which contains the absolute and relative rotation and translation!
    % we need also the direction vectors and the normals to be passed to
    % fsolve, plus a point on the 3D lines
    % ------------------------------------------------------------------
    
    [~, ~, ~,angleX ,angleY ,angleZ] = rotAnglefromMatrix2 (R_selected1);
    
    x0(1,(cam-1)*6+1) = angleX;
    x0(1,(cam-1)*6+2) = angleY;
    x0(1,(cam-1)*6+3) = angleZ;
    x0(1,(cam-1)*6+4) = T_selected(1);
    x0(1,(cam-1)*6+5) = T_selected(2);
    x0(1,(cam-1)*6+6) = T_selected(3);
    
    Directions{cam,:,:} = D.Directions_original;
    normals{cam,:,:} = D.normals;
    P1_w{cam,:,:} = D.P1_w_original;
    
end

% Levenberg marquardt using fsolve (LM)
% camNum: number of camera
% P1_w: first endpoint of the 3D lines
% Directions: unite direction of the 3D lines
% normals: normals of the projection plane
% x0: initialisation variable
% i: just index in case you run this in a sequence of sets
% ------------------------------------

[R_selected,T_selected,itirations] = LeastSquaresSolverMv_cayley(camNum,P1_w,Directions,normals,x0,i);
numberofitiration(1) = itirations;

% denormalize the results of fsolve
% ------------------------------------

for y=1:camNum
    if y==1
        poseabs = [R_selected(:,:,y) T_selected(:,y); 0 0 0 1] * (D.N3);
        poseLM(:,:,y) = poseabs/norm(poseabs(1:3,1:3));        
    else
        fullpose = [R_selected(:,:,y) T_selected(:,y); 0 0 0 1] *poseabs ;
        fullpose = fullpose/norm(fullpose(1:3,1:3));
        
        poseLM(:,:,y) = fullpose * inv(poseLM(:,:,1));
        poseLM(:,4,y) = poseLM(:,4,y) / norm(poseabs(1:3,1:3));        
    end        
end

clear T_selected R_selected

%% formating the denormalised rsults into R_selected (for the
% rotation) and T_selected (for the translation)
% ------------------------------------

for y=1:camNum
    R_selected(:,:,y) = poseLM(1:3,1:3,y);
    T_selected(1:3,y) = poseLM(1:3,4,y);
    
    Poses{y} = [R_selected(:,:,y) T_selected(1:3,y) ; 0 0 0 1];
    
end

end

