function [Poses] = MRPnL_all_solutions(input,lineNum,type)

% This version returns all the solutions sorted by the backprojection error
% ------------------------------------------------------------------


% NORMALISATION of the 3D data into the cubic unit around the origin of
% the world frame
% Calculation of the normals and the unite direction of the 3D lines
% ------------------------------------------------------------------

D = generateDataAbs(input,lineNum);

% calling the solver (MRPnL) for the reference camera to estimates the
% aboslute pose
% ------------------------------------------------------------------

[Poses_o] = Solver_for_Rotation_MRPnL_cubic_special(D,type);


% Denormalisation of the pose into the original world coordinate sysetm
% ------------------------------------------------------------------

if isempty(Poses_o)   
    warning('no solution found, please check the input')   
    Poses = nan;
    return
end


for k=1:length(Poses_o)

Denorm_pose = [Poses_o{k}(1:3,1:3) Poses_o{k}(1:3,4); 0 0 0 1]*  (D.N3);
Denorm_pose1=Denorm_pose/norm(Denorm_pose(1:3,1:3));
Poses{k} = [Denorm_pose1(1:3,1:3) Denorm_pose1(1:3,4); 0 0 0 1] ;

end

end

