%% Preprocess scale and shift in the unit 3D cube
% return params:
%               - vec normalized 3D data
%               - N3 the normalization matrix

function [normalised_3D_points, N3] = preproc_3D( g )

h1 = (max(g(:,1)) - min(g(:,1)));
w1 = (max(g(:,2)) - min(g(:,2)));
d1 = (max(g(:,3)) - min(g(:,3)));

t1=max(abs([h1,w1,d1]));
% t1=1;
s1x = 1 / abs( t1 );
s1y = 1 / abs( t1 );
s1z = 1 / abs( t1 );

[u1 v1 z1] = massCenter_3D( g );

n = size(g, 1);
vec.x = zeros( n, 1 );
vec.y = zeros( n, 1 );
vec.z = zeros( n, 1 );

%-------------------------------
%% determine the normalization matrix
N31 = [1 0 0 -u1;
    0 1 0 -v1;
    0 0 1 -z1;
    0 0 0 1    ];

N3 = [ s1x    0    0    0;
     0      s1y  0    0;
     0      0    s1z  0;
     0      0    0    1  ] * N31;
 
%norm3D = s1x*s1y*s1z;

normalised_3D_points = N3 * [ g ones(n,1)]';
end
%% apply normalization to points
