function [R_wc,T_wc,itirations,Residual] = LeastSquaresSolverMv_cayley(camNum,P1_w,Directions,normals,x0,set)




num = length(P1_w);

fun = @(x)EquationConstructAMv_cayley(x,Directions,normals,P1_w,num,camNum);

optOptions=optimset('Algorithm','Levenberg-Marquardt');
optOptions.MaxFunEvals=3000;
optOptions.LineSearchType = 'quadcubic';
optOptions.TolX = 0.000000000000001;
optOptions.TolFun = 0.000000000000001;
optOptions.MaxIter = 1000;
optOptions.Display = 'off';

[solution,fval,~,out]= fsolve(fun,x0,optOptions);

itirations = out.iterations;

Residual = sum(sum(fval.*fval));

for k=1:camNum
    
    R_wc(:,:,k) = rotMfromAngleRad3 (solution((k-1)*6+1), solution((k-1)*6+2), solution((k-1)*6+3));
    T_wc(:,k) = solution((k-1)*6+4:(k-1)*6+6);
end


end

