function [poses] = Solver_for_Rotation_MRPnL_cubic_special(Data,algo)


% endpoints of the 3D lines
W1 = Data.P1_w;
W2 = Data.P2_w;

% Normialised 2D endpoint with inv(K) of the 2D lines
p1 = Data.p1;
p2 = Data.p2;

% calculation of normals of the projection planes
Vww2D=p2-p1;
Directions2D = Vww2D ./ vecnorm(Vww2D);
n_c = (cross(Directions2D,p1)) ./vecnorm(cross(Directions2D,p1));

Data.normals = n_c ;
n_cinit=n_c;

nLine = length(p1);

if size(p1,1)~=3
    xs = [p1; ones(1,nLine)];
else
    xs = [p1];
end

if size(p2,1)~=3
    xe = [p2; ones(1,nLine)];
else
    xe = [p2];
    
end

% calculation of the unit direction vector of the 3D lines
Vww=W2-W1;
Vw = Vww ./ vecnorm(Vww);
Data.Directions = Vw;


%select the line with longest length in the image plane;
lineLenVec = sqrt(sum((xs-xe).^2));
[~, LineID] = max(lineLenVec);

% place the longest line into the first position
temp=n_c(:,1);   n_c(:,1)=n_c(:,LineID);  n_c(:,LineID)=temp;
temp = Vw(:,1);  Vw(:,1) = Vw(:, LineID); Vw(:,LineID) = temp;


% added only for the backprojection function
p1_original = p1;
p2_original = p2;
W1_original = W1;
W2_original = W2;
temp=p1_original(:,1);   p1_original(:,1)=p1_original(:,LineID);  p1_original(:,LineID)=temp;
temp=p2_original(:,1);   p2_original(:,1)=p2_original(:,LineID);  p2_original(:,LineID)=temp;
temp=W1_original(:,1);   W1_original(:,1)=W1_original(:,LineID);  W1_original(:,LineID)=temp;
temp = W2_original(:,1);  W2_original(:,1) = W2_original(:, LineID); W2_original(:,LineID) = temp;
p1_original = p1_original(:,2:end);
p2_original= p2_original(:,2:end);
W1_original = W1_original(:,2:end);
W2_original= W2_original(:,2:end);
Vw_original = Vw(:,2:end);
n_c_original= n_c(:,2:end);


% save the normal and direction vector of the longest line
nc1=n_c(:,1);
Vw1 = Vw(:,1);

% determine the intermediate coordinate system
Xm = cross(nc1,Vw1);
Xm = Xm/norm(Xm); %the X axis of Model frame
Ym = nc1/norm(nc1); %the Y axis of Model frame
Zm = cross(Xm,Ym);
Zm= Zm/norm(Zm);%the Z axis of Model frame;
% the model frame X Y Z axis

Rot = [Xm, Ym, Zm]';

% rotating the normals and the unite direction vectors with the
% intermediate coordinate system
nc_bar = Rot * n_c;
Vw_bar = Rot * Vw;

%mesuring the angle between z axis and Vw_bar(:,1).
cos_alpha= [0,0,1]*Vw_bar(:,1);

% Rx is the new rotation around the X axis calculated between  Z axis
% the rotation matrix Rx(alpha) rotates Vw_bar(:,1) to z axis
sin_alpha= real(sqrt(1 - cos_alpha*cos_alpha));
Rx= [1 0 0; 0 cos_alpha -sin_alpha; 0 sin_alpha cos_alpha];


Zaxis = Rx * Vw_bar(:,1); % should be the Z axis, i.e. [0, 0, 1]';
if 1 - abs(Zaxis(3)) > 1e-5
    Rx = Rx';
end

% applying the pre-defined Rx to the unite direction vectors
v = Rx * Vw_bar(:,2:end);
n1 =nc_bar(1,2:end);n2 = nc_bar(2,2:end);n3 = nc_bar(3,2:end);
v1 = v(1,1:end) ; v2 =v(2,1:end); v3 = v(3,1:end) ;


%%
% preparing the coefficents
[A] = CoefARyRz(n1,n2,n3,v1,v2,v3);
[b1] = CoefB1RyRz(A);
[b2] = CoefB2RyRz(A);

% sum of the coefficent
b1Sum = sum(b1,2);
b2Sum = sum(b2,2);


% calling the solver

if algo==1
    
    [ra_2, sa_2] = solver_PnL_2Unknown_simplifiedRyRz(...
        b1Sum(1), b1Sum(2), b1Sum(3), b1Sum(4), b1Sum(5), b1Sum(6), b1Sum(7), b1Sum(8), b1Sum(9), b1Sum(10), ...
        b1Sum(11), b1Sum(12), b1Sum(13), b1Sum(14), b1Sum(15), b1Sum(16), b1Sum(17), b1Sum(18), b1Sum(19), b1Sum(20), ...
        b2Sum(1), b2Sum(2), b2Sum(3), b2Sum(4), b2Sum(5), b2Sum(6), b2Sum(7), b2Sum(8), b2Sum(9), b2Sum(10), ...
        b2Sum(11), b2Sum(12), b2Sum(13), b2Sum(14), b2Sum(15), b2Sum(16), b2Sum(17), b2Sum(18), b2Sum(19), b2Sum(20));
    solutions = zeros(2,size(ra_2,2));
    solutions(1,:)= ra_2;
    solutions(2,:)= sa_2;
    
    
elseif algo==2
    
    %
    %
    [solutions] =  PnLRyRz_solver((b1Sum),(b2Sum));
    
    
else
    disp('algorithme not defined correctly');
    return;
end

r_angle = 2*atan(solutions(1,:));
s_angle = 2*atan(solutions(2,:));

r_origin = solutions(1,:);
s_origin = solutions(2,:);


numberofSolutions = size(solutions,2);

idx=1;
error=inf;
line_error_all = nan(1,numberofSolutions);

for solInx=1:size(solutions,2)
    if ~isnan(solutions(1,solInx)) && ~isinf(solutions(1,solInx)) && ~isnan(solutions(2,solInx)) && ~isinf(solutions(2,solInx))
        
        % building back the rotation matrix
        Rz = [cos(r_angle(solInx)) -sin(r_angle(solInx)) 0 ; sin(r_angle(solInx)) cos(r_angle(solInx)) 0 ; 0 0 1 ];
        Ry = [cos(s_angle(solInx)) 0 sin(s_angle(solInx)); 0 1 0 ; -sin(s_angle(solInx)) 0 cos(s_angle(solInx))];
        
        Rc = Ry * Rz * Rx;
        R_selected = Rot' *Rc * Rot;
        
        
        % estimating the translation with SVD
        T_selected=Translation_solverLs(W1,n_cinit,R_selected);
        
        %         Denorm_pose1 = inv(Data.N3) * [R_selected T_selected; 0 0 0 1] * (Data.N3);
        % denormalising for evaluation
        Denorm_pose = [R_selected T_selected; 0 0 0 1]*  (Data.N3);
        Denorm_pose1=Denorm_pose/norm(Denorm_pose(1:3,1:3));
        
        
        R_selected1 = Denorm_pose1(1:3,1:3);
        T_selected1 = Denorm_pose1(1:3,4);

        %% selected the best pose based on the backprojection error
        
        pose_estimated = [R_selected T_selected; 0 0 0 1];
        
        ArrayData (:,1) = p1_original(1,:)';
        ArrayData (:,2) = p1_original(2,:)';
        ArrayData (:,3) = p1_original(3,:)';
        
        ArrayData (:,4) = p2_original(1,:)';
        ArrayData (:,5) = p2_original(2,:)';
        ArrayData (:,6) = p2_original(3,:)';
        
        ArrayData (:,7) = W1_original(1,:)';
        ArrayData (:,8) = W1_original(2,:)';
        ArrayData (:,9) = W1_original(3,:)';
        
        ArrayData (:,10) = W2_original(1,:)';
        ArrayData (:,11) = W2_original(2,:)';
        ArrayData (:,12) = W2_original(3,:)';
        
        
        [line_error] = Back_projection_error_GimLee3(pose_estimated,p1_original',p2_original',W1_original',W2_original');

        line_error_all(idx) = sum(line_error);        
        pose_estimated_all{idx} = pose_estimated;
                
        idx = idx + 1;

    end
end
% Sorting the solutions
% ------------------------------------------------------------------

[~,Idx] = sort(line_error_all);
poses =pose_estimated_all(Idx);

end



