function Data = DataPreparation( input,ncam,nline)


Data(1).beta = input.vertical_direction(1);
Data(1).gamma = input.vertical_direction(2);

for n=1:ncam

Pw_s = input.Camera(n).Line3D(:).start(1:nline,:)';
Pw_e = input.Camera(n).Line3D(:).end(1:nline,:)';

Vww=Pw_e-Pw_s;
Data(n).V = Vww ./ vecnorm(Vww);
Data(n).Pw_s = Pw_s;
Data(n).Pw_e = Pw_e;    
    
Data(n).xs = input.Camera(n).Line2D(:).start(1:nline,:)';
Data(n).xe = input.Camera(n).Line2D(:).end(1:nline,:)';

Data(n).R_wc  = input.Camera(n).R;
Data(n).T_wc  = input.Camera(n).t;

end




% Data(1).cameraType = 'Persp';
% Data(2).cameraType = 'Persp';
% Data(3).cameraType = 'Persp';



end
