
% ------------------------------------------------------------------------
% [1]: Nora Horanyi, Zoltan Kato, Multiview Absolute Pose Using 3D - 2D 
% Perspective Line Correspondences and Vertical Direction, In Proceedings 
% of ICCV Workshop on Multiview Relationships in 3D Data, Venice, 
% Italy, 2017, IEEE.
% All rights reserved.
% ------------------------------------------------------------------------

% Created: 2017-12-05,    using Matlab 9.2.0.556344 (R2017a)
% All rights reserved.

% updated: 2020-04-24,    using Matlab (R2018b) by Hichem Abdellali
% added the wrapping function 
% All rights reserved.

% Important!
% ------------------------------------------------------------------------
% Please cite our [1] publication whenever you use the implementation.


% Introduction
% ------------------------------------------------------------------------
% This software package contains the NPnLupL and NPnLupC solvers as described
% in paper [1].


% Installation
% ------------------------------------------------------------------------

% This package does not require any installation. Package contains all
% necessary functions. the solver needs endpoints from 2D-3D line
% coorespandances (an example is provided),

% ------------------------------------------------------------------------
% -------------------------------- NOTE ----------------------------------
% ------------------------------------------------------------------------
% we assume a calibrated perspective camera, and we work with 
% the equivalent normalized image coordinates. 
% If our camera is a calibrated camera and we have a matrix M of size 3xn 
% which contains the 2D coordinates with homogenous 
% coordinate representation in the image plane then we can normalize 
% the coordinates as follows:
% temp = inv(K) * M;
% for i=1:n
%   M_normalized(:,i) = temp(:,i) / temp(3,i)
% end


% ------------------------------------------------------------------------
% ---------------------------- Main input --------------------------------
% ------------------------------------------------------------------------
%- input.Camera(i).Line.start = normalized coordinates of the image line 
%  segment startpoints.
%- input.Camera(i).Line.end = normalized coordinates of the image line 
%  segment endpoints.
%- input.line3D.start = start points of the 3D line segments in world 
%  the coordinates.
%- input.line3D.end = end points of the 3D line segments in the
%  world coordinates.


% ------------------------------------------------------------------------
% -------------------------additional input ------------------------------
% ------------------------------------------------------------------------
% camNum: number of camera. 
% lineNum : number of 2D-3D line pairs to be used.

% ------------------------------------------------------------------------
% ----------------------------- output -----------------------------------
% ------------------------------------------------------------------------
% for NPnLUpL pose : ('Absolute pose') 4*4 matrix acts from the world coordinate 
% system to the reference camera.

% for NPnLUpC poses : ('Absolute pose') a list of 4*4 matrix acts from the world coordinate 
% system to the reference camera, the optimal pose is ranked first in the
% list sorted based on the backprojection error


% ------------------------------------------------------------------------
% ------------------------------ Tests -----------------------------------
% ------------------------------------------------------------------------
% run this script "HOW_TO_RUN.m". an example will be loaded from  Input.mat
% it contains a configuration of 5 perspective cameras (first one is the reference),
% and 60 2D-3D line correspondances, and it will return the full absolute
% pose (which acts from the world coordinate system to the camera)

restoredefaultpath
load('Input.mat');

addpath Functions
addpath Solver

 % num for each camera

% Test for NPnLUpL published in [1] 
% ------------------------------------------------------------------------
camNum = 1;
lineNum = 30;
Pose1 = NPnLUpL(input,camNum,lineNum);



% Test for NPnLUpC published in [1] 
% ------------------------------------------------------------------------
camNum = 1;
lineNum = 30;
Poses2 = NPnLUpC(input,camNum,lineNum);

