
function [pose] = NPnLupC_solver(D,ncam)
% Nora Horanyi, Zoltan Kato, Multiview Absolute Pose Using 3D - 2D Perspective Line Correspondences and Vertical Direction,
% In Proceedings of ICCV Workshop on Multiview Relationships in 3D Data, Venice, Italy, 2017, IEEE.

% Created: 2017-12-05,    using Matlab 9.2.0.556344 (R2017a)
% All rights reserved.

% updated: 2020-04-24,    using Matlab (R2018b) by Hichem Abdellali
% - added the wrapping function
% All rights reserved.

% input: a structure D which contains:
%       xs(:, i) = the start point of the ith image line [startpointx, startpointy, 1];
%       xe(:, i) = the end point of the ith image line   [endpointx,   endpointy, 1];
%       beta     = rotation angle around Y axis in radian
%       gamma    = rotation angle around Z axis in radian
%       Vw(:, i) = the direction of ith line in the world frame
%       Pw(:, i) = a point of ith line in the world frame
%       Rr       = relative rotation between the camera and the camera coordinate frame
%       tr       = relative translation between the camera and the camera coordinate frame

% output: the Absolute pose or the camera system which acts from the world
% coordinate system to the camera

% NOTE:
% 2D points should be normalized



beta = D(1).beta;
gamma = D(1).gamma;

Ry=[cos(beta) 0 sin(beta); 0 1 0; -sin(beta) 0 cos(beta)];
Rz=[cos(gamma), -sin(gamma), 0; sin(gamma), cos(gamma), 0; 0, 0, 1];

a1=0;
b1=0;
c1=0;
d1=0;

for n=1:ncam
    nc = zeros(3,size(D(n).xs,2));
    
    for i=1:size(D(n).xs,2)
        nc(:,i) = cross(D(n).xs(:,i),D(n).xe(:,i));
        nc(:,i) = nc(:,i)/norm(nc(:,i));
    end
    D(n).nc = nc;
    
    if n==1
        Rr = eye(3);
        tr = [0 0 0]';
        Rv=Rr*Rz*Ry;
    else
        Rv=D(n).R_wc*Rz*Ry;
    end
    
    for i=1:size(nc,2)
        [ai1,bi1,ci1]=abc_solver(nc(:,i), Rv, D(n).V(:,i));
        a(i) = 4*ai1^2;
        b(i) = 6*ai1*bi1;
        c(i) = 4*ai1*ci1 + 2*bi1^2;
        d(i) = 2*bi1*ci1;
    end
    
    a1=sum(a)+a1;
    b1=sum(b)+b1;
    c1=sum(c)+c1;
    d1=sum(d)+d1;
    
    
    
    
end



q=roots([a1 b1 c1 d1]);
q = q(imag(q)==0); % just real roots

line_error_all = Inf(1,size(q,1));
% NumberOfSolution(set) = size(q,1);
% if size(q,1)>1
%    disp('Warnning!')
% end

for i=1:size(q,1)
    Mats = [];
    Rx = [q(i)^2+1, 0, 0; 0, -q(i)^2+1, -2*q(i); 0, 2*q(i), -q(i)^2+1]/(1 + q(i)^2);
    
    for n=1:ncam
        
        if n==1
            Rr = eye(3);
            tr = [0 0 0]';
            R = Rr * Rz * Ry * Rx;
        else
            Rr = D(n).R_wc;
            tr = D(n).T_wc;
            R = Rr * Rz * Ry * Rx;
        end
        
        
        [Mat]=matcalculation(size(D(n).Pw_s,2), D(n).nc , R, D(n).Pw_s, Rr, tr);
        Mats=[Mats;Mat;];
    end
    
    [~, ~, VMat] = svd(Mats);
    vec = VMat(:,4);% the last column of Vmat;
    vec = vec/vec(4);
    
    %now, we get the rotation matrix rot_wc and translation pos_wc
    rot_wc = Rz*Ry*Rx;
    pos_wc = vec(1:3);
    pos_cw = rot_wc'*(-pos_wc);
    
    
    % this part has been added by Hichem Abdellali
    % back-projection function implemented by hichem Abdellali
    % line back-projection function from GimLee,
    
    pose1 = [rot_wc' pos_cw; 0 0 0 1];
    pose_estimated = inv(pose1);
    
        
    [line_error] = Back_projection_error_GimLee3(pose_estimated,D(1).xs',D(1).xe',D(1).Pw_s',D(1).Pw_e');
    
    line_error_all(i) = sum(line_error);
    pose_estimated_all{i} = pose_estimated;
    
    Zchecking1 = pose_estimated * [D(1).Pw_s ;ones(1,size(D(1).Pw_s,2))];
    Zchecking2 = pose_estimated * [D(1).Pw_e ;ones(1,size(D(1).Pw_e,2))];
    
    if(min(Zchecking1(3,:))<0 || min(Zchecking2(3,:))<0)
        Znegative(i) = 1;
    else
        Znegative(i) = 0;
        
    end
    
end


line_error_all = line_error_all + 100000 * Znegative;

%[~,Idx] = min(line_error_all);
[~,Idx] = sort(line_error_all);
pose =pose_estimated_all(Idx);

return

function [Mat]=matcalculation(n, nc, R, Pw, Rr, tr)
Mat = zeros(n, 4);
% tr= Rv * tr;
for i = 1:n
    nxi = nc(1,i);  nyi = nc(2,i);  nzi = nc(3,i);
    Pxi = Pw(1,i);        Pyi = Pw(2,i);        Pzi = Pw(3,i);
    
    % apply the constraint scalarproduct(Pi^c, ni^c) = 0
    Mat(2*i-1, 1) = nxi * Rr(1,1) + nyi * Rr(2,1) + nzi * Rr(3,1);
    Mat(2*i-1, 2) = nxi * Rr(1,2) + nyi * Rr(2,2) + nzi * Rr(3,2);
    Mat(2*i-1, 3) = nxi * Rr(1,3) + nyi * Rr(2,3) + nzi * Rr(3,3);
    Mat(2*i-1, 4) = nxi * (Pxi * R(1,1) + Pyi * R(1,2) + Pzi * R(1,3) )+ nyi * (Pxi * R(2,1) + Pyi * R(2,2) + Pzi * R(2,3) )+ nzi * (Pxi * R(3,1) + Pyi * R(3,2) + Pzi * R(3,3) ) + nxi*tr(1) + nyi*tr(2) + nzi * tr(3) ; %=(nc(:,i)'*tr)
end
return

function [a,b,c]=abc_solver(nc, Rv, Vw)
nxi = nc(1);        nyi = nc(2);        nzi = nc(3);
Vxi = Vw(1);        Vyi = Vw(2);        Vzi = Vw(3);

a = nxi * (Vxi * Rv(1,1) - Vyi * Rv(1,2) - Vzi * Rv(1,3)) + nyi * (Vxi * Rv(2,1) - Vyi * Rv(2,2) - Vzi * Rv(2,3)) + nzi * (Vxi * Rv(3,1) - Vyi * Rv(3,2) - Vzi * Rv(3,3));
b = 2 * (nxi * (Vyi * Rv(1,3)- Vzi * Rv(1,2)) + nyi * (Vyi * Rv(2,3)- Vzi * Rv(2,2)) + nzi * (Vyi * Rv(3,3)- Vzi * Rv(3,2)));
c = nxi * (Vxi * Rv(1,1) + Vyi * Rv(1,2) + Vzi * Rv(1,3)) + nyi * (Vxi * Rv(2,1) + Vyi * Rv(2,2) + Vzi * Rv(2,3)) + nzi * (Vxi * Rv(3,1) + Vyi * Rv(3,2) + Vzi * Rv(3,3));

return
