% [pose_l] = NPnLupL(xs1,xe1,xs2,xe2,xs3,xe3,V1',V2',V3',P1',P2',P3',alpha, beta, Rr1,Rr2,Rr3, tr1,tr2,tr3)
% compare with T_CW

function [Pose] = NPnLupL_solver(D,ncam)
% Nora Horanyi, Zoltan Kato, Multiview Absolute Pose Using 3D - 2D Perspective Line Correspondences and Vertical Direction,
% In Proceedings of ICCV Workshop on Multiview Relationships in 3D Data, Venice, Italy, 2017, IEEE.

% Created: 2017-12-05,    using Matlab 9.2.0.556344 (R2017a)
% All rights reserved.

% updated: 2020-04-24,    using Matlab (R2018b) by Hichem Abdellali
% - added the wrapping function 
% All rights reserved.

% input: a structure D which contains: 
%       xs(:, i) = the start point of the ith image line [startpointx, startpointy, 1];
%       xe(:, i) = the end point of the ith image line   [endpointx,   endpointy, 1];
%       beta     = rotation angle around Y axis in radian
%       gamma    = rotation angle around Z axis in radian
%       Vw(:, i) = the direction of ith line in the world frame
%       Pw(:, i) = a point of ith line in the world frame
%       Rr       = relative rotation between the camera and the camera coordinate frame
%       tr       = relative translation between the camera and the camera coordinate frame

% output: the Absolute pose or the camera system which acts from the world
% coordinate system to the camera

% NOTE:
% 2D points should be normalized

beta = D(1).beta;
gamma = D(1).gamma;

Ry=[cos(beta) 0 sin(beta); 0 1 0; -sin(beta) 0 cos(beta)];
Rz=[cos(gamma), -sin(gamma), 0; sin(gamma), cos(gamma), 0; 0, 0, 1];

Mat=[];

for n=1:ncam
    nc = zeros(3,size(D(n).xs,2));
for i=1:size(D(n).xs,2)
    nc(:,i) = cross(D(n).xs(:,i),D(n).xe(:,i));  
    nc(:,i) = nc(:,i)/norm(nc(:,i));
end  

    D(n).nc = nc;
    
    if n==1
     Rr = eye(3);
     tr = [0 0 0]';
    Rv=Rr*Rz*Ry;        
    else
     Rr = D(n).R_wc;
     tr = D(n).T_wc;        
    Rv=D(n).R_wc*Rz*Ry;        
    end
    
[Mat1]=matcalculation(size(D(n).Pw_s,2), D(n).nc, Rv, D(n).V, D(n).Pw_s, Rr, tr);        
Mat=[Mat;Mat1;];

end

[~, ~, VMat] = svd(Mat);

vec = VMat(:,6);
vec = vec/vec(6); %the condition that the last element of vec should be 1.
normalizeTheta = 1/sqrt(vec(1)*vec(1)+vec(2)*vec(2)); %the condition costheta^2+sintheta^2 = 1;
costheta = vec(1)*normalizeTheta;
sintheta = vec(2)*normalizeTheta;
Rx = [1 0 0; 0 costheta, -sintheta; 0, sintheta, costheta];

%now, we get the rotation matrix rot_wc and translation pos_wc
rot_wc = Rz* Ry * Rx;
pos_wc = vec(3:5);

rot_cw = rot_wc';
pos_cw = rot_cw*(-pos_wc);

rot_cw = rot_wc';
Pose=[rot_cw pos_cw; 0 0 0 1];

    %pose_estimated = pose;
Pose= inv(Pose);

return

function [Mat]=matcalculation(n, nc, Rv, Vw, Pw, Rr, tr)
Mat = zeros(2*n-1, 6);

for i = 1:n
    nxi = nc(1,i);  nyi = nc(2,i);  nzi = nc(3,i);
    
    %Vm = Rv * Vw(:,i);
    Vxi = Vw(1,i);        Vyi = Vw(2,i);        Vzi = Vw(3,i);
    
    %Pm = Rv * Pw(:,i);
    Pxi = Pw(1,i);        Pyi = Pw(2,i);        Pzi = Pw(3,i);
    
    % apply the constraint scalarproduct(Vi^c, ni^c) = 0
    %if i=1, then scalarproduct(Vi^c, ni^c) always be 0
    Mat(2*i, 1) = nxi * (Vyi * Rv(1,2)+ Vzi * Rv(1,3)) + nyi *(Vyi*Rv(2,2) + Vzi*Rv(2,3)) + nzi * (Vyi*Rv(3,2) + Vzi*Rv(3,3));
    Mat(2*i, 2) = nxi * (Vyi * Rv(1,3) - Vzi * Rv(1,2)) + nyi *(Vyi*Rv(2,3) - Vzi*Rv(2,2)) + nzi * (Vyi*Rv(3,3) - Vzi*Rv(3,2));
    Mat(2*i, 6) = nxi * (Vxi * Rv(1,1)) + nyi * (Vxi*Rv(2,1)) + nzi* (Vxi * Rv(3,1));
    
    % apply the constraint scalarproduct(Pi^c, ni^c) = 0
    Mat(2*i-1, 1) = nxi * (Pyi * Rv(1,2) + Pzi * Rv(1,3)) + nyi * (Pyi * Rv(2,2) + Pzi * Rv(2,3)) + nzi * (Pyi * Rv(3,2) + Pzi * Rv(3,3));
    Mat(2*i-1, 2) = nxi * (Pyi * Rv(1,3) - Pzi * Rv(1,2)) + nyi * (Pyi * Rv(2,3) - Pzi * Rv(2,2)) + nzi * (Pyi * Rv(3,3) - Pzi * Rv(3,2));
    Mat(2*i-1, 3) = nxi * Rr(1,1) + nyi * Rr(2,1) + nzi * Rr(3,1);
    Mat(2*i-1, 4) = nxi * Rr(1,2) + nyi * Rr(2,2) + nzi * Rr(3,2);
    Mat(2*i-1, 5) = nxi * Rr(1,3) + nyi * Rr(2,3) + nzi * Rr(3,3);
    Mat(2*i-1, 6) = nxi * Pxi * Rv(1,1) + nyi * Pxi * Rv(2,1) + nzi * Pxi * Rv(3,1) + nxi*tr(1) + nyi*tr(2) + nzi * tr(3) ; %=(nc(:,i)'*tr)
end
return
