//************************************************************************* //
// Kill Game
// Author: Szirmay-Kalos Laszlo, 2001. November.
//************************************************************************* //
#include <stdio.h>
#include <string.h>
#include "glutwindow.h"

GLUTWindow * GLUTWindow :: pwindow = NULL;

//-----------------------------------------------------------------
GLUTWindow :: GLUTWindow( ) {
//-----------------------------------------------------------------
	pwindow = this;

	glutDisplayFunc( DisplayFunc );
	glutIdleFunc( IdleFunc );
	glutKeyboardFunc( KeyboardFunc );
	glutSpecialFunc( SpecialKeyboardFunc );
	glutPassiveMotionFunc( MouseMotionFunc );
   	
	mouseMove = FALSE;
	for(int i = 0; i < 256; i++) key_status[i] = FALSE;
}


//-----------------------------------------------------------------
void GLUTWindow :: SaveImage( ) {
//-----------------------------------------------------------------
	static int cycle = 100;
	char filename[80];
	sprintf(filename, "image%d.tga",cycle++);
//
// Open file and write TARGA header
//
    FILE * file = fopen(filename, "wb");

	static unsigned char image[WIDTH * HEIGHT * 3];
//
// Copy screen to memory
//
 	glReadPixels(0, 0, WIDTH, HEIGHT, GL_RGB, GL_UNSIGNED_BYTE, &image[0]);

    fputc(0,file);
    fputc(0,file);
    fputc(2,file);
    for(int i = 3; i < 12; i++) fputc(0,file);
    fputc(WIDTH & 0xff,file);
    fputc(WIDTH / 256,file);
    fputc(HEIGHT & 0xff,file);
    fputc(HEIGHT / 256,file);
    fputc(24,file);
    fputc(32,file);
//
// Write RGB information
//
	for(int y = HEIGHT-1; y >= 0; y--) {
		for( int x = 0; x < WIDTH; x++) {
			int blue = image[(y * WIDTH + x)*3 + 2]; 
			int green = image[(y * WIDTH + x)*3 + 1]; 
			int red = image[(y * WIDTH + x)*3]; 

			fputc(blue,file);
			fputc(green,file);
			fputc(red,file);
		}
    }
    fclose(file);
}

Application app;

//-----------------------------------------------------------------
void main( int argc, char * argv[] ) {	
//-----------------------------------------------------------------
	glutInit(&argc, argv);
	glutInitWindowSize(HEIGHT, WIDTH);
	glutInitDisplayMode(GLUT_RGBA | GLUT_DOUBLE | GLUT_DEPTH);
	glutCreateWindow( "Space Game" );

	app.Start();

	glutMainLoop();
}