/********************************************************************
*                      TARGA FORMATUMU FAJLOK 
*
* - TARGA fajlok elolvasasa 
* - mentes TARGA formatumban
*
*
* Szirmay-Kalos Laszlo (szirmay@iit.bme.hu)
* BME, Iranyitastechnika s Informatika Tanszek
* 1999. februar
*********************************************************************/
#include <stdio.h>

//=============================================================
class TGAOutputFile {
//=============================================================
    FILE * file;        // fajl leiro
public :
    TGAOutputFile( char * outputfilename, int width, int height ) {
        file = fopen(outputfilename, "wb");
        if ( !file ) return;
                                // meretet tartalmazo fej kiirasa
        fputc(0,file); fputc(0,file); fputc(2,file);
        for(int i = 3;i < 12; i++) fputc(0,file);
        fputc(width & 0xff, file);
        fputc(width / 256, file);
        fputc(height & 0xff, file);
        fputc(height / 256, file);
        fputc(24,file); fputc(32,file);
    }
    void Pixel( double r, double g, double b ) {  // double szinek kiirasa
        if (b > 1.0) b = 1.0;
        int blue = (int)(b * 255); 
        if (g > 1.0) g = 1.0;
        int green = (int)(g * 255); 
        if (r > 1.0) r = 1.0;
        int red = (int)(r * 255); 
        PPixel( red, green, blue);
    }
    void PPixel( int red, int green, int blue ) {  // bajtos szinek kiirasa
        if ( !file ) return;
        fputc(blue,file);
        fputc(green,file);
        fputc(red,file);
    }
    ~TGAOutputFile( ) { fclose(file); }
};

//=============================================================
class TGAInputFile {
//=============================================================
    FILE * file;        // fajl leiro
public :
    TGAInputFile( char * inputfilename, int& width, int& height ) {
        file = fopen(inputfilename, "rb");
        if ( !file ) {
            char newfilename[100];
            sprintf(newfilename, ".\\peldak\\%s", inputfilename);
            file = fopen( newfilename, "rb" ); 
            if ( !file ) {
                width = XRES;
                height = YRES;
                return;
            }
        }
                        // fej beolvasasa es a meretek beallitasa
        for(int i = 0;i < 12; i++) fgetc(file);
        width = fgetc(file) + fgetc(file) * 256L;
        height = fgetc(file) + fgetc(file) * 256L;
        fgetc(file); fgetc(file);
    }
    void Pixel( int& r, int& g, int& b ) {      // kovetkezo pixel beolvasasa
        if ( !file ) {
            r = g = b = 0;
            return;
        }
        b = fgetc(file);
        g = fgetc(file);
        r = fgetc(file);
    }
    ~TGAInputFile( ) { if (file) fclose(file); }
};
