/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.GLPanel;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class Edge {
    public static Color DEFAULT_COLOR = GLPanel.defaultBackColor;
    public static Color MOUSE_OVER_COLOR = Color.decode("#ccddff");
    public static int DEFAULT_LENGTH = 40;
    public Node from;
    public Node to;
    public Color col;
    protected int length;
    protected boolean visible;
    protected String id = null;

    public Edge(Node f, Node t, int len) {
        this.from = f;
        this.to = t;
        this.length = len;
        this.col = DEFAULT_COLOR;
        this.visible = false;
    }

    public Edge(Node f, Node t) {
        this(f, t, DEFAULT_LENGTH);
    }

    public static void setEdgeDefaultColor(Color color) {
        DEFAULT_COLOR = color;
    }

    public static void setEdgeMouseOverColor(Color color) {
        MOUSE_OVER_COLOR = color;
    }

    public static void setEdgeDefaultLength(int length) {
        DEFAULT_LENGTH = length;
    }

    public Node getFrom() {
        return this.from;
    }

    public Node getTo() {
        return this.to;
    }

    public Color getColor() {
        return this.col;
    }

    public void setColor(Color color) {
        this.col = color;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int len) {
        this.length = len;
    }

    public void setVisible(boolean v) {
        this.visible = v;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Node getOtherEndpt(Node n) {
        if (this.to != n) {
            return this.to;
        }
        return this.from;
    }

    public void reverse() {
        Node temp = this.to;
        this.to = this.from;
        this.from = temp;
    }

    public boolean intersects(Dimension d) {
        int x1 = (int)this.from.drawx;
        int y1 = (int)this.from.drawy;
        int x2 = (int)this.to.drawx;
        int y2 = (int)this.to.drawy;
        return !(x1 <= 0 && x2 <= 0 || x1 >= d.width && x2 >= d.width || y1 <= 0 && y2 <= 0 || y1 >= d.height && y2 >= d.height);
    }

    public double distFromPoint(double px, double py) {
        double x1 = this.from.drawx;
        double y1 = this.from.drawy;
        double x2 = this.to.drawx;
        double y2 = this.to.drawy;
        if (px < Math.min(x1, x2) - 8.0 || px > Math.max(x1, x2) + 8.0 || py < Math.min(y1, y2) - 8.0 || py > Math.max(y1, y2) + 8.0) {
            return 1000.0;
        }
        double dist = 1000.0;
        if (x1 - x2 != 0.0) {
            dist = Math.abs((y2 - y1) / (x2 - x1) * (px - x1) + (y1 - py));
        }
        if (y1 - y2 != 0.0) {
            dist = Math.min(dist, Math.abs((x2 - x1) / (y2 - y1) * (py - y1) + (x1 - px)));
        }
        return dist;
    }

    public boolean containsPoint(double px, double py) {
        return this.distFromPoint(px, py) < 10.0;
    }

    public static void paintArrow(Graphics g, int x1, int y1, int x2, int y2, Color c) {
        g.setColor(c);
        int x3 = x1;
        int y3 = y1;
        double dist = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        if (dist > 10.0) {
            double adjustDistRatio = (dist - 10.0) / dist;
            x3 = (int)((double)x1 + (double)(x2 - x1) * adjustDistRatio);
            y3 = (int)((double)y1 + (double)(y2 - y1) * adjustDistRatio);
        }
        x3 = (int)((double)(x3 * 4 + x1) / 5.0);
        y3 = (int)((double)(y3 * 4 + y1) / 5.0);
        g.drawLine(x3, y3, x2, y2);
        g.drawLine(x1, y1, x3, y3);
        g.drawLine(x1 + 1, y1, x3, y3);
        g.drawLine(x1 + 2, y1, x3, y3);
        g.drawLine(x1 + 3, y1, x3, y3);
        g.drawLine(x1 + 4, y1, x3, y3);
        g.drawLine(x1 - 1, y1, x3, y3);
        g.drawLine(x1 - 2, y1, x3, y3);
        g.drawLine(x1 - 3, y1, x3, y3);
        g.drawLine(x1 - 4, y1, x3, y3);
        g.drawLine(x1, y1 + 1, x3, y3);
        g.drawLine(x1, y1 + 2, x3, y3);
        g.drawLine(x1, y1 + 3, x3, y3);
        g.drawLine(x1, y1 + 4, x3, y3);
        g.drawLine(x1, y1 - 1, x3, y3);
        g.drawLine(x1, y1 - 2, x3, y3);
        g.drawLine(x1, y1 - 3, x3, y3);
        g.drawLine(x1, y1 - 4, x3, y3);
        g.setPaintMode();
    }

    public void paint(Graphics g, TGPanel tgPanel) {
        Color c = tgPanel.getMouseOverE() == this ? MOUSE_OVER_COLOR : this.col;
        int x1 = (int)this.from.drawx;
        int y1 = (int)this.from.drawy;
        int x2 = (int)this.to.drawx;
        int y2 = (int)this.to.drawy;
        if (this.intersects(tgPanel.getSize())) {
            Edge.paintArrow(g, x1, y1, x2, y2, c);
        }
    }
}

