/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGLensSet;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.DScrollbar;
import com.touchgraph.graphlayout.interaction.GLEditUI;
import com.touchgraph.graphlayout.interaction.GLNavigateUI;
import com.touchgraph.graphlayout.interaction.HVScroll;
import com.touchgraph.graphlayout.interaction.LocalityScroll;
import com.touchgraph.graphlayout.interaction.MouseDragSelect;
import com.touchgraph.graphlayout.interaction.MouseDraw;
import com.touchgraph.graphlayout.interaction.MousePressListener;
import com.touchgraph.graphlayout.interaction.TGUIManager;
import com.touchgraph.graphlayout.interaction.UsingKeyListener;
import com.touchgraph.graphlayout.interaction.ZoomScroll;
import dummy.name.nlputils.Index;
import dummy.name.nlputils.NLPUtils;
import dummy.name.nlputils.SparseDocument;
import dummy.name.utils.ReducedMemVTM;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicArrowButton;

public class GLPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -336957766329537869L;
    public static final int BIG_INPUT_SIZE = 500;
    private static final int TOTAL_EDGE_WEIGHT = 1000;
    public String zoomLabel = "Zoom";
    public String ctrlLabel = "Select";
    public HVScroll hvScroll;
    public ZoomScroll zoomScroll;
    public MousePressListener mousePressListener;
    public MouseDraw mouseDraw;
    public UsingKeyListener usingKeyListener;
    protected boolean expanded = false;
    public LocalityScroll localityScroll;
    public JCheckBoxMenuItem selectionItem = new JCheckBoxMenuItem("Hide all edge");
    public static JCheckBoxMenuItem edgesColorItem = new JCheckBoxMenuItem("Add edge Color");
    public JMenuItem initItem = new JMenuItem("Initialize");
    public static boolean menuEdge = true;
    public MouseDragSelect mouseDragSelect;
    public JPopupMenu glPopup;
    public Hashtable<String, JScrollBar> scrollBarHash;
    public Hashtable<String, Scrollbar> scrollBarHashB;
    private JTextField fromDate;
    private JTextField toDate;
    private JTextField search;
    private JButton okButton;
    private DateFormat df;
    private ReducedMemVTM vtm;
    private List<SparseDocument> sparseCommunityDocs;
    private JPanel communitiesPanel;
    private int[] communities;
    private Color[] colors;
    public static Node rightClickNode;
    public JMenuItem aboutItem = new JMenuItem("about");
    public Calendar calendar = Calendar.getInstance();
    public int actualYear = this.calendar.get(1) + 1;
    private boolean[] communityHiddenness;
    public boolean[] communityCompressedness;
    protected BasicArrowButton fromArrowUp = new BasicArrowButton(1);
    protected BasicArrowButton fromArrowDown = new BasicArrowButton(5);
    protected BasicArrowButton toArrowUp = new BasicArrowButton(1);
    protected BasicArrowButton toArrowDown = new BasicArrowButton(5);
    private double[] relativeImportances;
    private int[] containingDocIds = null;
    public int maxNeighbors;
    public static boolean rightClickCenter;
    protected TGPanel tgPanel;
    protected JToggleButton tb;
    protected TGLensSet tgLensSet;
    protected TGUIManager tgUIManager;
    public static String searchResult;
    private InputStream in = null;
    private JFrame frame = new JFrame("KeyphraseViz Applet");
    protected ReducedMemVTM.Calculation c = ReducedMemVTM.Calculation.COSINE;
    protected ReducedMemVTM.Metric m = ReducedMemVTM.Metric.PROBABILITY;
    private JScrollBar currentSB = null;
    public static boolean edgeColoring;
    public int fromArrowDate = 0;
    public int toArrowDate = 0;
    Button hideButton = new Button("Hide expanded nodes");
    public static final Color defaultBackColor;
    private Color defaultBorderBackColor = new Color(2, 53, 129);
    private Color defaultForeColor = new Color(0.95f, 0.85f, 0.55f);
    private Thread visualizationThread;
    private JScrollPane scroll;

    static {
        rightClickCenter = false;
        searchResult = "search box";
        edgeColoring = false;
        defaultBackColor = new Color(248, 248, 248);
    }

    public GLPanel(InputStream dir, String dataId, boolean etalonColoring, int neighbors, int threshold, ReducedMemVTM.Calculation c, ReducedMemVTM.Metric m, int windowWidth, int windowHeight) {
        this.setBackground(this.defaultBorderBackColor);
        this.setForeground(this.defaultForeColor);
        this.scrollBarHash = new Hashtable();
        this.tgLensSet = new TGLensSet();
        this.tgPanel = new TGPanel();
        this.tgPanel.setBackColor(defaultBackColor);
        this.hvScroll = new HVScroll(this.tgPanel, this.tgLensSet);
        this.zoomScroll = new ZoomScroll(this.tgPanel);
        this.mousePressListener = new MousePressListener(this.tgPanel);
        this.localityScroll = new LocalityScroll(this.tgPanel);
        this.mouseDragSelect = new MouseDragSelect(this.tgPanel);
        this.tgPanel.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int notches = e.getWheelRotation();
                GLPanel.this.currentSB.setValue(GLPanel.this.currentSB.getValue() + notches);
            }
        });
        this.df = new SimpleDateFormat("yyyy.MM.dd.", Locale.ENGLISH);
        this.initialize(dir, dataId, etalonColoring, neighbors, c, m, threshold, windowWidth, windowHeight);
        this.mouseDraw = new MouseDraw(this.tgPanel, this.vtm);
    }

    public JMenuBar createMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Menu");
        menu.setMnemonic(65);
        menuBar.add(menu);
        JMenuItem menuItem = new JMenuItem("File Chooser", 70);
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                boolean etalonColoring = false;
                int numOfNeighbors = 3;
                int keyphraseThreshold = 10;
                GLPanel.this.in = GLPanel.this.inputReader();
                try {
                    GLPanel.this.tgPanel.updateLocalityFromVisibility();
                    GLPanel.this.tgPanel.repaint();
                    Window w = SwingUtilities.getWindowAncestor(GLPanel.this.tgPanel);
                    w.setVisible(false);
                }
                catch (TGException tge) {
                    tge.printStackTrace();
                }
                if (GLPanel.this.in != null) {
                    final GLPanel glPanel = new GLPanel(GLPanel.this.in, "aac", etalonColoring, numOfNeighbors, keyphraseThreshold, GLPanel.this.c, GLPanel.this.m, 1200, 900);
                    GLPanel.this.frame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            GLPanel.this.frame.remove(glPanel);
                            GLPanel.this.frame.dispose();
                        }
                    });
                    GLPanel.this.frame.setJMenuBar(glPanel.createMenu());
                    GLPanel.this.frame.add("Center", glPanel);
                    GLPanel.this.frame.pack();
                    GLPanel.this.frame.setVisible(true);
                }
            }
        });
        this.selectionItem.setMnemonic(83);
        this.selectionItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (GLPanel.this.selectionItem.isSelected()) {
                    menuEdge = false;
                    System.err.println("Hide all Edges");
                } else {
                    menuEdge = true;
                    if (MouseDraw.path != null) {
                        MouseDraw.path = null;
                        MouseDraw.drawing = false;
                    }
                    System.err.println("Show Edges");
                }
            }
        });
        this.initItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                GLPanel.this.initMenu();
            }
        });
        this.aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFrame aboutDialog = new JFrame("about...");
                aboutDialog.setSize(290, 150);
                aboutDialog.setLayout(new GridLayout(3, 0));
                JLabel title = new JLabel("<html><center>Visualization tool for document collections <br>created at the <b>University of Szeged.<b></center></html>");
                title.setFont(title.getFont().deriveFont(13.0f));
                JLabel lastUpdate = new JLabel("<html><center>Last update: 06/11/2013</center>");
                lastUpdate.setFont(lastUpdate.getFont().deriveFont(10.0f));
                JLabel link = new JLabel("<html><center>For further information <font color='blue'><u>click here</u></font></center>");
                link.setCursor(Cursor.getPredefinedCursor(12));
                String url = "http://www.inf.u-szeged.hu/~berendg/keyphraseViz/";
                link.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (e.getClickCount() > 0) {
                            if (Desktop.isDesktopSupported()) {
                                Desktop desktop = Desktop.getDesktop();
                                try {
                                    URI uri = new URI("http://www.inf.u-szeged.hu/~berendg/keyphraseViz/");
                                    desktop.browse(uri);
                                }
                                catch (IOException uri) {
                                }
                                catch (URISyntaxException uri) {}
                            } else {
                                String osName = System.getProperty("os.name");
                                try {
                                    if (osName.startsWith("Windows")) {
                                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler http://www.inf.u-szeged.hu/~berendg/keyphraseViz/");
                                    } else {
                                        String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                                        String browser = null;
                                        int count = 0;
                                        while (count < browsers.length && browser == null) {
                                            if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                                                browser = browsers[count];
                                            }
                                            ++count;
                                        }
                                        Runtime.getRuntime().exec(new String[]{browser, "http://www.inf.u-szeged.hu/~berendg/keyphraseViz/"});
                                    }
                                }
                                catch (Exception e2) {
                                    JTextArea textarea = new JTextArea("http://www.inf.u-szeged.hu/~berendg/keyphraseViz/");
                                    textarea.setEditable(false);
                                    JOptionPane.showMessageDialog(null, textarea, "Please, highlight the url", 0);
                                }
                            }
                        }
                    }
                });
                aboutDialog.add(title);
                aboutDialog.add(link);
                aboutDialog.setBackground(defaultBackColor);
                aboutDialog.add(lastUpdate);
                aboutDialog.setLocationRelativeTo(GLPanel.this.getRootPane());
                aboutDialog.setVisible(true);
                aboutDialog.setDefaultCloseOperation(2);
            }
        });
        menu.add(menuItem);
        menu.addSeparator();
        menu.add(this.selectionItem);
        menu.addSeparator();
        menu.add(this.initItem);
        menu.addSeparator();
        menu.add(this.aboutItem);
        return menuBar;
    }

    public void initialize(InputStream dir, String dataId, boolean etalonColoring, int neighbors, ReducedMemVTM.Calculation c, ReducedMemVTM.Metric m, int t, int windowWidth, int windowHeight) {
        long time = System.currentTimeMillis();
        this.maxNeighbors = neighbors;
        this.vtm = new ReducedMemVTM(dir);
        this.vtm.setCalculation(c);
        this.vtm.setMetric(m);
        System.err.println("Calculation : " + (Object)((Object)c));
        System.err.println("Metric: " + (Object)((Object)m));
        this.vtm.setKeyphraseStrategy(ReducedMemVTM.KeyphraseStrategy.CHI_SQUARE);
        this.vtm.setThreshold(t);
        this.buildPanel();
        this.buildLens();
        this.tgPanel.setLensSet(this.tgLensSet);
        this.addUIs();
        this.knnGraph(this.maxNeighbors, dataId, etalonColoring);
        this.setVisible(true);
        System.err.println(String.valueOf((double)(System.currentTimeMillis() - time) / 1000.0) + " secs passed.");
    }

    public TGPanel getTGPanel() {
        return this.tgPanel;
    }

    public HVScroll getHVScroll() {
        return this.hvScroll;
    }

    public void setOffset(Point p) {
        this.hvScroll.setOffset(p);
    }

    public Point getOffset() {
        return this.hvScroll.getOffset();
    }

    public LocalityScroll getLocalityScroll() {
        return this.localityScroll;
    }

    public void setLocalityRadius(int radius) {
        this.localityScroll.setLocalityRadius(radius);
    }

    public int getLocalityRadius() {
        return this.localityScroll.getLocalityRadius();
    }

    public ZoomScroll getZoomScroll() {
        return this.zoomScroll;
    }

    public void setZoomValue(int zoomValue) {
        this.zoomScroll.setZoomValue(zoomValue);
    }

    public int getZoomValue() {
        return this.zoomScroll.getZoomValue();
    }

    public JPopupMenu getGLPopup() {
        return this.glPopup;
    }

    public void buildLens() {
        this.tgLensSet.addLens(this.hvScroll.getLens());
        this.tgLensSet.addLens(this.zoomScroll.getLens());
        this.tgLensSet.addLens(this.tgPanel.getAdjustOriginLens());
    }

    public void buildPanel() {
        final DScrollbar horizontalSB = this.hvScroll.getHorizontalSB();
        final DScrollbar verticalSB = this.hvScroll.getVerticalSB();
        JScrollBar zoomSB = this.zoomScroll.getZoomSB();
        this.setLayout(new BorderLayout());
        JPanel filterPanel = new JPanel();
        filterPanel.setBackground(defaultBackColor);
        filterPanel.setForeground(this.defaultForeColor);
        this.fromDate = new JTextField(this.df.format(this.vtm.getFirstDate()));
        this.fromDate.addActionListener(this);
        this.toDate = new JTextField(this.df.format(this.vtm.getLastDate()));
        this.toDate.addActionListener(this);
        this.toArrowDate = this.vtm.sortedDate.size() - 1;
        String fromDateString = this.df.format(this.vtm.getFirstDate()).replaceAll("\\.[0-9][0-9]\\.[0-9][0-9]", "");
        fromDateString = fromDateString.replaceAll("\\.", "");
        int fromDateInt = Integer.parseInt(fromDateString);
        String toDateString = this.df.format(this.vtm.getLastDate()).replaceAll("\\.[0-9][0-9]\\.[0-9][0-9]", "");
        toDateString = toDateString.replaceAll("\\.", "");
        int toDateInt = Integer.parseInt(toDateString);
        this.search = new JTextField("search box", 25);
        this.search.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (GLPanel.this.search.getText().equals("search box")) {
                    GLPanel.this.search.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.search.addActionListener(this);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        Button initButton = new Button("Initialize");
        initButton.setBackground(Color.lightGray);
        initButton.setForeground(Color.darkGray);
        initButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLPanel.this.initMenu();
            }
        });
        Button aboutButton = new Button("About");
        aboutButton.setBackground(Color.lightGray);
        aboutButton.setForeground(Color.darkGray);
        aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GLPanel.this.aboutMenu();
            }
        });
        this.hideButton.setBackground(defaultBackColor);
        this.hideButton.setForeground(this.defaultForeColor);
        this.hideButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int numOfSimpleNodes = GLPanel.this.vtm.getTotalDocumentSize();
                int i = 0;
                while (i < GLPanel.this.communitiesPanel.getComponentCount()) {
                    if (numOfSimpleNodes < 500) {
                        boolean bl = ((GLPanel)GLPanel.this).communityHiddenness[i] = !GLPanel.this.communityHiddenness[i];
                    }
                    if (numOfSimpleNodes > 500) {
                        Component component = GLPanel.this.communitiesPanel.getComponent(i);
                        ((JToggleButton)component).setText(((JToggleButton)component).getActionCommand().replace("EXPANDED: ", ""));
                        component.setFont(new Font("Arial", 0, 11));
                        component.setForeground(Color.DARK_GRAY);
                        GLPanel.this.communityCompressedness[i] = true;
                        GLPanel.this.searchFilter();
                        GLPanel.this.hideButton.setEnabled(false);
                    }
                    ++i;
                }
            }
        });
        filterPanel.add(this.hideButton);
        this.hideButton.setEnabled(false);
        filterPanel.add(aboutButton);
        filterPanel.add(this.fromArrowUp);
        filterPanel.add(this.fromArrowDown);
        filterPanel.add(this.fromDate);
        filterPanel.add(this.toArrowUp);
        filterPanel.add(this.toArrowDown);
        filterPanel.add(this.toDate);
        filterPanel.add(this.search);
        filterPanel.add(this.okButton);
        this.add((Component)filterPanel, "North");
        JPanel sidePanel = new JPanel();
        sidePanel.setBackground(defaultBackColor);
        sidePanel.setForeground(this.defaultForeColor);
        this.add((Component)sidePanel, "East");
        JPanel scrollPanel = new JPanel();
        scrollPanel.setBackground(defaultBackColor);
        scrollPanel.setForeground(this.defaultForeColor);
        scrollPanel.setLayout(new GridBagLayout());
        GridBagConstraints cg = new GridBagConstraints();
        final JPanel topPanel = new JPanel();
        topPanel.setBackground(this.defaultBorderBackColor);
        topPanel.setForeground(this.defaultForeColor);
        topPanel.setLayout(new GridBagLayout());
        cg.gridy = 0;
        cg.fill = 2;
        cg.gridx = 0;
        cg.weightx = 0.0;
        cg.insets = new Insets(0, 0, 0, 0);
        cg.gridy = 0;
        cg.weightx = 1.0;
        this.scrollBarHash.put(this.zoomLabel, zoomSB);
        Panel scrollselect = this.scrollSelectPanel(new String[]{this.zoomLabel});
        scrollselect.setBackground(this.defaultBorderBackColor);
        scrollselect.setForeground(this.defaultForeColor);
        topPanel.add((Component)scrollselect, cg);
        this.add((Component)topPanel, "South");
        cg.fill = 1;
        cg.gridwidth = 1;
        cg.gridx = 0;
        cg.gridy = 1;
        cg.weightx = 1.0;
        cg.weighty = 1.0;
        scrollPanel.add((Component)this.tgPanel, cg);
        cg.gridx = 1;
        cg.gridy = 1;
        cg.weightx = 0.0;
        cg.weighty = 0.0;
        cg.gridx = 0;
        cg.gridy = 2;
        this.add((Component)scrollPanel, "Center");
        horizontalSB.setVisible(false);
        verticalSB.setVisible(false);
        topPanel.setVisible(false);
        this.validate();
        this.glPopup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem("Toggle Controls");
        ActionListener toggleControlsAction = new ActionListener(){
            boolean controlsVisible = false;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.controlsVisible = !this.controlsVisible;
                horizontalSB.setVisible(this.controlsVisible);
                verticalSB.setVisible(this.controlsVisible);
                topPanel.setVisible(this.controlsVisible);
                GLPanel.this.validate();
            }
        };
        menuItem.addActionListener(toggleControlsAction);
        this.glPopup.add(menuItem);
        aboutButton.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyChar() == '\u001b' && MouseDraw.path != null) {
                    MouseDraw.path.closePath();
                    MouseDraw.path = null;
                    MouseDraw.drawing = false;
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        initButton.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyChar() == '\u001b' && MouseDraw.path != null) {
                    MouseDraw.path.closePath();
                    MouseDraw.path = null;
                    MouseDraw.drawing = false;
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.fromDate.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyChar() == '\u001b' && MouseDraw.path != null) {
                    MouseDraw.path.closePath();
                    MouseDraw.path = null;
                    MouseDraw.drawing = false;
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.glPopup.add(edgesColorItem);
        this.toDate.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyChar() == '\u001b' && MouseDraw.path != null) {
                    MouseDraw.path.closePath();
                    MouseDraw.path = null;
                    MouseDraw.drawing = false;
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.search.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyChar() == '\u001b' && MouseDraw.path != null) {
                    MouseDraw.path.closePath();
                    MouseDraw.path = null;
                    MouseDraw.drawing = false;
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.fromArrowUp.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ++GLPanel.this.fromArrowDate;
                if (GLPanel.this.fromArrowDate <= ((GLPanel)GLPanel.this).vtm.sortedDate.size() - 1) {
                    GLPanel.this.fromDate.setText(((GLPanel)GLPanel.this).vtm.sortedDate.get(GLPanel.this.fromArrowDate));
                    GLPanel.this.searchFilter();
                } else {
                    --GLPanel.this.fromArrowDate;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.fromArrowDown.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                --GLPanel.this.fromArrowDate;
                if (GLPanel.this.fromArrowDate >= 0) {
                    GLPanel.this.fromDate.setText(((GLPanel)GLPanel.this).vtm.sortedDate.get(GLPanel.this.fromArrowDate));
                    GLPanel.this.searchFilter();
                } else {
                    ++GLPanel.this.fromArrowDate;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.toArrowUp.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                ++GLPanel.this.toArrowDate;
                if (GLPanel.this.toArrowDate < ((GLPanel)GLPanel.this).vtm.sortedDate.size()) {
                    GLPanel.this.toDate.setText(((GLPanel)GLPanel.this).vtm.sortedDate.get(GLPanel.this.toArrowDate));
                    GLPanel.this.searchFilter();
                } else {
                    --GLPanel.this.toArrowDate;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.toArrowDown.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                --GLPanel.this.toArrowDate;
                if (GLPanel.this.toArrowDate >= 0) {
                    GLPanel.this.toDate.setText(((GLPanel)GLPanel.this).vtm.sortedDate.get(GLPanel.this.toArrowDate));
                    GLPanel.this.searchFilter();
                } else {
                    ++GLPanel.this.toArrowDate;
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    protected Panel scrollSelectPanel(String[] scrollBarNames) {
        Panel sbp = new Panel(new GridBagLayout());
        sbp.setBackground(this.defaultBorderBackColor);
        sbp.setForeground(this.defaultForeColor);
        JPanel firstRow = new JPanel(new GridBagLayout());
        JPanel secondRow = new JPanel(new GridBagLayout());
        ButtonGroup bg = new ButtonGroup();
        int cbNumber = scrollBarNames.length;
        JRadioButton[] radioButtons = new JRadioButton[cbNumber];
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 17;
        c.gridy = 0;
        c.weightx = 0.0;
        c.fill = 2;
        int i = 0;
        while (i < cbNumber) {
            radioButtons[i] = new JRadioButton(scrollBarNames[i], i == 0);
            radioButtons[i].setActionCommand(scrollBarNames[i]);
            c.gridx = i;
            bg.add(radioButtons[i]);
            firstRow.add((Component)radioButtons[i], c);
            radioButtons[i].addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent arg0) {
                    if (arg0.getKeyChar() == '\u001b' && MouseDraw.path != null) {
                        MouseDraw.path.closePath();
                        MouseDraw.path = null;
                        MouseDraw.drawing = false;
                    }
                }

                @Override
                public void keyReleased(KeyEvent arg0) {
                }

                @Override
                public void keyTyped(KeyEvent arg0) {
                }
            });
            ++i;
        }
        c.gridx = cbNumber;
        c.weightx = 1.0;
        JLabel lbl = new JLabel("    \t               Right-click nodes and background for more options");
        firstRow.add((Component)lbl, c);
        int i2 = 0;
        while (i2 < cbNumber) {
            class RadioItemListener
            implements ItemListener {
                private String scrollBarName;
                private final /* synthetic */ ButtonGroup val$bg;
                private final /* synthetic */ String[] val$scrollBarNames;
                private final /* synthetic */ Panel val$sbp;

                public RadioItemListener(String str2Act, ButtonGroup buttonGroup, String[] stringArray, Panel panel) {
                    this.val$bg = buttonGroup;
                    this.val$scrollBarNames = stringArray;
                    this.val$sbp = panel;
                    this.scrollBarName = str2Act;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    String selectionStr = this.val$bg.getSelection().getActionCommand();
                    JScrollBar selectedSB = GLPanel.this.scrollBarHash.get(selectionStr);
                    if (e.getStateChange() == 1) {
                        int i = 0;
                        while (i < this.val$scrollBarNames.length) {
                            JScrollBar sb = GLPanel.this.scrollBarHash.get(this.val$scrollBarNames[i]);
                            sb.setVisible(false);
                            ++i;
                        }
                        selectedSB.setBounds(GLPanel.this.currentSB.getBounds());
                        if (selectedSB != null) {
                            selectedSB.setVisible(true);
                        }
                        GLPanel.this.currentSB = selectedSB;
                        this.val$sbp.invalidate();
                    }
                }
            }
            radioButtons[i2].addItemListener(new RadioItemListener(scrollBarNames[0], bg, scrollBarNames, sbp));
            ++i2;
        }
        c.anchor = 18;
        c.insets = new Insets(1, 5, 1, 5);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 10.0;
        c.gridwidth = 30;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 17;
        sbp.add((Component)firstRow, c);
        sbp.add((Component)secondRow, c);
        c.gridy = 1;
        c.fill = 2;
        i2 = 0;
        while (i2 < scrollBarNames.length) {
            JScrollBar sb = this.scrollBarHash.get(scrollBarNames[i2]);
            if (sb != null) {
                if (this.currentSB == null) {
                    this.currentSB = sb;
                }
                sbp.add((Component)sb, c);
            }
            ++i2;
        }
        return sbp;
    }

    public void addUIs() {
        this.tgUIManager = new TGUIManager();
        GLEditUI editUI = new GLEditUI(this);
        GLNavigateUI navigateUI = new GLNavigateUI(this);
        this.tgUIManager.addUI(editUI, "Edit");
        this.tgUIManager.addUI(navigateUI, "Navigate");
        this.tgUIManager.activate("Navigate");
    }

    private Map<String, Integer> mapTopicsToIds() {
        HashMap<String, Integer> topics2Ids = new HashMap<String, Integer>();
        for (SparseDocument sd : this.vtm.getKeyphrasesToDocs()) {
            String topic = sd.getId().replaceAll("([^,]+),.*", "$1");
            String string = topic = topic.matches("W\\d{2}-\\d{4}") ? topic.substring(0, 6) : topic;
            if (topics2Ids.containsKey(topic)) continue;
            topics2Ids.put(topic, topics2Ids.size());
        }
        return topics2Ids;
    }

    private int[] determineEtalonCommunities(List<SparseDocument> sparseDocs) {
        Map<String, Integer> topics2Ids = this.mapTopicsToIds();
        int[] etalonCommunities = new int[sparseDocs.size()];
        int i = 0;
        while (i < etalonCommunities.length) {
            SparseDocument sd = sparseDocs.get(i);
            String reducedTopic = sd.getId().replaceAll("([^,]+),.*", "$1");
            reducedTopic = reducedTopic.matches("W\\d{2}-\\d{4}") ? reducedTopic.substring(0, 6) : reducedTopic;
            Integer topicId = topics2Ids.get(reducedTopic);
            assert (topicId != null) : "TopicId should be included in the topics2Ids mapping.";
            etalonCommunities[i] = topicId;
            ++i;
        }
        return etalonCommunities;
    }

    private Map<Integer, List<Integer>> getDocsToEtalonCommunities() {
        HashMap<Integer, List<Integer>> toReturn = new HashMap<Integer, List<Integer>>();
        int i = 0;
        while (i < this.communities.length) {
            int etalonComm = this.communities[i];
            List docIdsOfEtalonComm = (List)toReturn.get(etalonComm);
            docIdsOfEtalonComm = docIdsOfEtalonComm == null ? new LinkedList() : docIdsOfEtalonComm;
            docIdsOfEtalonComm.add(i);
            toReturn.put(etalonComm, docIdsOfEtalonComm);
            ++i;
        }
        return toReturn;
    }

    private SparseDocument getKeyphrasesOfCommunity(List<Integer> docIds, String[] keyphrases) {
        return this.getKeyphrasesOfCommunity("", docIds, keyphrases);
    }

    private SparseDocument getKeyphrasesOfCommunity(String docSetId, List<Integer> docIds, String[] keyphrases) {
        int[] docIdArray = new int[docIds.size()];
        int index = 0;
        for (Integer id : docIds) {
            docIdArray[index++] = id;
        }
        return this.vtm.getTopKeyphrases(docSetId, keyphrases, docIdArray);
    }

    public void knnGraph(int maxNeighbors, String dirName, final boolean etalonColoring) {
        long time = System.currentTimeMillis();
        final Index[] closestNodes = this.vtm.calculateOverlaps(maxNeighbors, true, new int[0]);
        final List<SparseDocument> sparseDocs = this.vtm.getKeyphrasesToDocs();
        System.err.println("Knn creation and pagerank calculation finished in " + (double)(System.currentTimeMillis() - time) / 1000.0 + " secs.");
        GridLayout communityPanelLayout = new GridLayout(0, 1);
        this.communitiesPanel = new JPanel(communityPanelLayout);
        this.scroll = new JScrollPane(this.communitiesPanel);
        this.scroll.setPreferredSize(new Dimension(350, 700));
        this.add((Component)this.scroll, "West");
        this.vtm.determineCommunities(closestNodes, maxNeighbors, new int[0]);
        this.communities = etalonColoring ? this.determineEtalonCommunities(sparseDocs) : this.vtm.getCommunities();
        final Map<Integer, List<Integer>> docsToCommunityIds = etalonColoring ? this.getDocsToEtalonCommunities() : this.vtm.getDocsToCommunities();
        this.communityHiddenness = new boolean[docsToCommunityIds.size()];
        this.communityCompressedness = new boolean[docsToCommunityIds.size()];
        double[] pageRanks = this.vtm.getPageRanks();
        int[] communityMapping = this.vtm.getCommunities();
        this.relativeImportances = new double[pageRanks.length - 1];
        final double[] aggregatedCommunityImportance = new double[docsToCommunityIds.size()];
        int i = 0;
        while (i < this.relativeImportances.length) {
            this.relativeImportances[i] = 1.0 + Math.log10(pageRanks[i] / pageRanks[pageRanks.length - 1]);
            if (communityMapping[i] != -1) {
                int n = communityMapping[i];
                aggregatedCommunityImportance[n] = aggregatedCommunityImportance[n] + this.relativeImportances[i];
            }
            ++i;
        }
        double minCi = Double.MAX_VALUE;
        double[] dArray = aggregatedCommunityImportance;
        int n = aggregatedCommunityImportance.length;
        int n2 = 0;
        while (n2 < n) {
            double ci = dArray[n2];
            if (minCi > ci) {
                minCi = ci;
            }
            ++n2;
        }
        final double minimumCommunityImportance = minCi;
        System.err.println("Community detection finished in " + (double)(System.currentTimeMillis() - time) / 1000.0 + " secs.");
        Runnable toRun = new Runnable(){

            @Override
            public void run() {
                long l = System.currentTimeMillis();
                GLPanel.this.sparseCommunityDocs = new ArrayList();
                ReducedMemVTM rvtm = GLPanel.this.addBirdViewPoints(aggregatedCommunityImportance, minimumCommunityImportance, etalonColoring, sparseDocs.size() > 500);
                List<SparseDocument> communityDocs = rvtm.getKeyphrasesToDocs();
                GLPanel.this.colors = rvtm.determineColors();
                int textWidth = Integer.MAX_VALUE;
                int communityId = 0;
                while (communityId < communityDocs.size()) {
                    Node n = GLPanel.this.tgPanel.findNode(Integer.toString(GLPanel.this.vtm.getTotalDocumentSize() + communityId));
                    n.setBackColor(GLPanel.this.colors[communityId]);
                    GLPanel.this.sparseCommunityDocs.add(communityDocs.get(communityId));
                    GLPanel.this.communityCompressedness[communityId] = sparseDocs.size() > 500;
                    List docIdsOfCommunity = (List)docsToCommunityIds.get(communityId);
                    String[] keyphrases = new String[3];
                    GLPanel.this.getKeyphrasesOfCommunity(docIdsOfCommunity, keyphrases);
                    StringBuffer sb = new StringBuffer();
                    int j = 0;
                    while (j < keyphrases.length) {
                        if (keyphrases[j] != null) {
                            sb.append(", " + keyphrases[j].substring(0, keyphrases[j].indexOf(9)));
                        } else {
                            System.err.println("not enough keyphrases(5)!");
                        }
                        ++j;
                    }
                    String reducedTopic = ((SparseDocument)sparseDocs.get((Integer)docIdsOfCommunity.get(0))).getId().replaceAll("([^,]+),.*", "$1");
                    String description = String.valueOf(etalonColoring ? String.valueOf(reducedTopic) + " " : "") + sb.substring(2) + " (" + docIdsOfCommunity.size() + " docs)";
                    GLPanel.this.addToggleButton(communityId, description);
                    textWidth = Math.min(textWidth, GLPanel.this.getFontMetrics(Node.TEXT_FONT).stringWidth(description) + GLPanel.this.getInsets().left + GLPanel.this.getInsets().right + 30);
                    ++communityId;
                }
                GLPanel.this.validate();
                GLPanel.this.repaint();
                int i = 0;
                while (i < sparseDocs.size()) {
                    SparseDocument sd = (SparseDocument)sparseDocs.get(i);
                    if (i % 500 == 0) {
                        System.err.println(String.valueOf(i) + "\t" + (double)(System.currentTimeMillis() - l) / 1000.0 + " sec has passed since the thread is started.");
                    }
                    Color nodeColor = GLPanel.this.communities[i] == -1 ? new Color(10, 10, 10) : GLPanel.this.colors[GLPanel.this.communities[i]];
                    StringBuffer label = new StringBuffer(String.valueOf(sd.getTitle().toUpperCase().trim()) + "\n-----------------------------------------------------");
                    String[] keyphrases = new String[5];
                    GLPanel.this.vtm.getTopKeyphrases(keyphrases, i);
                    String[] stringArray = keyphrases;
                    int n = keyphrases.length;
                    int description = 0;
                    while (description < n) {
                        String keyphrase = stringArray[description];
                        label.append("\r\n" + keyphrase);
                        ++description;
                    }
                    Node n2 = new Node(Integer.toString(i), 3, nodeColor, String.valueOf(label.toString()) + "\n-----------------------------------------------------\n                 published:  " + GLPanel.this.df.format(GLPanel.this.vtm.getDocDate(i)), GLPanel.this.relativeImportances[i]);
                    try {
                        GLPanel.this.tgPanel.addNode(n2);
                        n2.setVisible(sparseDocs.size() <= 500);
                        GLPanel.this.tgPanel.updateLocalityFromVisibility();
                    }
                    catch (TGException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                if (sparseDocs.size() > 500) {
                    GLPanel.this.addListenerForExpandingCommunities(closestNodes, etalonColoring);
                } else {
                    GLPanel.this.addEdges(closestNodes);
                }
            }
        };
        this.visualizationThread = new Thread(toRun);
        this.visualizationThread.setPriority(10);
        this.visualizationThread.start();
        System.err.println("Initialization almost finished in " + (double)(System.currentTimeMillis() - time) / 1000.0 + " secs.");
    }

    public void addEdgesToCommunities() {
        int regularNodes = this.vtm.getTotalDocumentSize();
        List<SparseDocument> regularDocs = this.vtm.getKeyphrasesToDocs();
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int[] neighborIds = new int[regularNodes];
        double[] similarities = new double[regularNodes];
        int n = 0;
        while (n < regularDocs.size()) {
            SparseDocument doc = regularDocs.get(n);
            int closestCommunityId = -1;
            double closestSimilarity = Double.MIN_VALUE;
            int c = 0;
            while (c < this.sparseCommunityDocs.size()) {
                double s = this.vtm.calculateSimilarity(doc, this.sparseCommunityDocs.get(c));
                if (closestSimilarity < s) {
                    closestSimilarity = s;
                    closestCommunityId = c;
                }
                ++c;
            }
            neighborIds[n] = closestCommunityId == -1 ? -1 : regularNodes + closestCommunityId;
            similarities[n] = closestSimilarity;
            if (max < closestSimilarity) {
                max = closestSimilarity;
            }
            if (closestCommunityId != -1 && min > closestSimilarity) {
                min = closestSimilarity;
            }
            ++n;
        }
        double similaritySpan = max - min;
        int n2 = 0;
        while (n2 < regularDocs.size()) {
            if (neighborIds[n2] > -1) {
                Node to = this.tgPanel.findNode(Integer.toString(n2));
                Node from = this.tgPanel.findNode(Integer.toString(neighborIds[n2]));
                if (to.isVisible() && from.isVisible()) {
                    this.tgPanel.addEdge(from, to, 1 + (int)(1000.0 * (1.0 - (similarities[n2] - min) / similaritySpan)));
                }
            }
            ++n2;
        }
    }

    private ReducedMemVTM addBirdViewPoints(double[] aggregatedCommunityImportance, double minimumCommunityImportance, boolean etalonColoring, boolean bigInput) {
        List<SparseDocument> sparseDocs = this.vtm.getKeyphrasesToDocs();
        ReducedMemVTM communityVTM = new ReducedMemVTM(this.vtm);
        communityVTM.setCalculation(ReducedMemVTM.Calculation.JACCARD);
        Map<Integer, List<Integer>> docsToCommunityIds = etalonColoring ? this.getDocsToEtalonCommunities() : this.vtm.getDocsToCommunities();
        int communityId = 0;
        while (communityId < this.communityHiddenness.length) {
            List<Integer> docIdsOfCommunity = docsToCommunityIds.get(communityId);
            HashMap<Integer, double[]> wordsInCommunity = new HashMap<Integer, double[]>();
            int i = 0;
            while (i < docIdsOfCommunity.size()) {
                SparseDocument communityDoc = sparseDocs.get(docIdsOfCommunity.get(i));
                int[] wordIndices = communityDoc.getIndices();
                int wordIndex = 0;
                while (wordIndex < communityDoc.getNonzeroElements()) {
                    double[] prevVal = (double[])wordsInCommunity.get(wordIndices[wordIndex]);
                    prevVal = prevVal == null ? new double[6] : prevVal;
                    double[] newVals = communityDoc.getFeaturesAt(wordIndices[wordIndex]);
                    int v = 0;
                    while (v < newVals.length) {
                        int n = v;
                        prevVal[n] = prevVal[n] + newVals[v] / (double)(v == newVals.length - 1 ? 1 : docIdsOfCommunity.size());
                        ++v;
                    }
                    wordsInCommunity.put(wordIndices[wordIndex], prevVal);
                    ++wordIndex;
                }
                ++i;
            }
            String[] keyphrases = new String[15];
            SparseDocument communityMetaDoc = this.getKeyphrasesOfCommunity(Integer.toString(communityId), docIdsOfCommunity, keyphrases);
            communityMetaDoc = new SparseDocument(wordsInCommunity);
            communityVTM.addDoc(communityMetaDoc);
            if (bigInput) {
                StringBuffer sb = new StringBuffer();
                int j = 0;
                while (j < Math.min(5, keyphrases.length)) {
                    if (keyphrases[j] != null) {
                        sb.append(String.valueOf(keyphrases[j].substring(0, keyphrases[j].indexOf(9))) + "\n");
                    }
                    ++j;
                }
                double nodeWeight = etalonColoring ? 1.0 : 1.0 + Math.log(aggregatedCommunityImportance[communityId] / minimumCommunityImportance);
                Node n = this.tgPanel.findNode(Integer.toString(this.vtm.getTotalDocumentSize() + communityId));
                n = new Node(Integer.toString(this.vtm.getTotalDocumentSize() + communityId), 1, Color.WHITE, String.valueOf(sb.toString()) + "\n  Expand this community?", nodeWeight);
                n.setIDs(sb.toString().split("\n"));
                try {
                    this.tgPanel.addNode(n);
                }
                catch (TGException e) {
                    e.printStackTrace();
                }
            }
            ++communityId;
        }
        if (bigInput) {
            Index[] closestNodes = communityVTM.calculateOverlaps(this.maxNeighbors, false, new int[0]);
            this.addEdges(closestNodes, this.vtm.getTotalDocumentSize());
        }
        return communityVTM;
    }

    private void addListenerForExpandingCommunities(final Index[] closestNodes, boolean etalonColoring) {
        final List<SparseDocument> sparseDocs = this.vtm.getKeyphrasesToDocs();
        final Map<Integer, List<Integer>> docsToCommunityIds = etalonColoring ? this.getDocsToEtalonCommunities() : this.vtm.getDocsToCommunities();
        final Map<Integer, String> vtmVocab = this.vtm.getIdsToVocab();
        this.tgPanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(final MouseEvent e) {
                Runnable expandRun = new Runnable(){

                    @Override
                    public void run() {
                        if ((this).GLPanel.this.tgPanel.mouseOverN != null && (this).GLPanel.this.tgPanel.mouseOverN.getType() == 1 && SwingUtilities.isLeftMouseButton(e) && GLNavigateUI.okOption) {
                            int communityId = Integer.parseInt((this).GLPanel.this.tgPanel.mouseOverN.getID()) - GLPanel.this.vtm.getTotalDocumentSize();
                            (this).GLPanel.this.tgPanel.mouseOverN.setVisible(false);
                            Iterator iterator = ((List)docsToCommunityIds.get(communityId)).iterator();
                            while (iterator.hasNext()) {
                                int i = (Integer)iterator.next();
                                Node n = (this).GLPanel.this.tgPanel.findNode(Integer.toString(i));
                                if (n == null) {
                                    int[] topKeyphraseIds;
                                    SparseDocument sd = (SparseDocument)sparseDocs.get(i);
                                    StringBuffer label = new StringBuffer(sd.getTitle());
                                    int[] nArray = topKeyphraseIds = sd.getTopKeyphraseIds(3);
                                    int n2 = topKeyphraseIds.length;
                                    int n3 = 0;
                                    while (n3 < n2) {
                                        int kpId = nArray[n3];
                                        label.append("\r\n" + (String)vtmVocab.get(kpId));
                                        ++n3;
                                    }
                                    try {
                                        (this).GLPanel.this.tgPanel.addNode(new Node(Integer.toString(i), 3, GLPanel.this.colors[communityId], label.toString(), GLPanel.this.relativeImportances[i]));
                                    }
                                    catch (TGException tge) {
                                        tge.printStackTrace();
                                    }
                                    continue;
                                }
                                n.setVisible(true);
                            }
                            GLPanel.this.addEdgesToCommunities();
                            GLPanel.this.addEdges(closestNodes);
                            (this).GLPanel.this.communityCompressedness[communityId] = false;
                            System.err.println("Expand community[" + communityId + "] : nodes created" + docsToCommunityIds.get(communityId));
                            GLPanel.this.refreshToggleButton(communityId, GLPanel.this.colors[communityId]);
                            String fromDateString = GLPanel.this.df.format(GLPanel.this.vtm.getFirstDate()).replaceAll("\\.01\\.01", "");
                            fromDateString = fromDateString.replaceAll("\\.", "");
                            int fromDateInt = Integer.parseInt(fromDateString);
                            String toDateString = GLPanel.this.df.format(GLPanel.this.vtm.getLastDate()).replaceAll("\\.01\\.01", "");
                            toDateString = toDateString.replaceAll("\\.", "");
                            int toDateInt = Integer.parseInt(toDateString);
                            int fromDateActual = Integer.parseInt(GLPanel.this.fromDate.getText().replaceAll("\\.01\\.01", "").replaceAll("\\.", ""));
                            int toDateActual = Integer.parseInt(GLPanel.this.toDate.getText().replaceAll("\\.01\\.01", "").replaceAll("\\.", ""));
                            if (!searchResult.equals("search box") && searchResult.trim().length() > 0 || fromDateInt != fromDateActual || toDateInt != toDateActual) {
                                GLPanel.this.searchFilter();
                            }
                        }
                        try {
                            (this).GLPanel.this.tgPanel.updateLocalityFromVisibility();
                            (this).GLPanel.this.tgPanel.resetDamper();
                        }
                        catch (TGException tge) {
                            tge.printStackTrace();
                        }
                    }
                };
                Thread expandVisualizationThread = new Thread(expandRun);
                expandVisualizationThread.setDaemon(true);
                expandVisualizationThread.setPriority(10);
                try {
                    GLPanel.this.visualizationThread.join();
                    expandVisualizationThread.start();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Runnable expandMultiRun = new Runnable(){

                    @Override
                    public void run() {
                        if ((this).GLPanel.this.mouseDraw.expanding && (this).GLPanel.this.mouseDraw.yesOption && (this).GLPanel.this.mouseDraw.selectedCommIds != null) {
                            int[] communityId;
                            int[] nArray = communityId = (this).GLPanel.this.mouseDraw.selectedCommIds;
                            int n = communityId.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Node n3;
                                int commInt = nArray[n2];
                                int tempComm = commInt + GLPanel.this.vtm.getTotalDocumentSize();
                                Node hideComm = (this).GLPanel.this.tgPanel.findNode(Integer.toString(tempComm));
                                hideComm.setVisible(false);
                                Iterator iterator = ((List)docsToCommunityIds.get(commInt)).iterator();
                                while (iterator.hasNext()) {
                                    int i = (Integer)iterator.next();
                                    n3 = (this).GLPanel.this.tgPanel.findNode(Integer.toString(i));
                                    if (n3 == null) {
                                        int[] topKeyphraseIds;
                                        SparseDocument sd = (SparseDocument)sparseDocs.get(i);
                                        StringBuffer label = new StringBuffer(sd.getTitle());
                                        int[] nArray2 = topKeyphraseIds = sd.getTopKeyphraseIds(3);
                                        int n4 = topKeyphraseIds.length;
                                        int n5 = 0;
                                        while (n5 < n4) {
                                            int kpId = nArray2[n5];
                                            label.append("\r\n" + (String)vtmVocab.get(kpId));
                                            ++n5;
                                        }
                                        try {
                                            (this).GLPanel.this.tgPanel.addNode(new Node(Integer.toString(i), 3, GLPanel.this.colors[commInt], label.toString(), GLPanel.this.relativeImportances[i]));
                                        }
                                        catch (TGException tge) {
                                            tge.printStackTrace();
                                        }
                                        continue;
                                    }
                                    n3.setVisible(true);
                                }
                                GLPanel.this.addEdgesToCommunities();
                                GLPanel.this.addEdges(closestNodes);
                                (this).GLPanel.this.communityCompressedness[commInt] = false;
                                System.err.println("Expand community[" + commInt + "] : nodes created" + docsToCommunityIds.get(commInt));
                                GLPanel.this.refreshToggleButton(commInt, GLPanel.this.colors[commInt]);
                                GLPanel.this.searchFilter();
                                int j = 0;
                                int i = 0;
                                while (i < (this).GLPanel.this.tgPanel.getNodeCount()) {
                                    n3 = (this).GLPanel.this.tgPanel.findNode(Integer.toString(i));
                                    if (n3 != null && n3.isVisible() && n3.getType() == 3) {
                                        ++j;
                                    }
                                    ++i;
                                }
                                try {
                                    if (j > 80) {
                                        Thread.sleep(j * 10);
                                        System.err.println("delay: " + j * 10 + "ms");
                                    } else {
                                        Thread.sleep(10L);
                                    }
                                    (this).GLPanel.this.tgPanel.updateLocalityFromVisibility();
                                    (this).GLPanel.this.tgPanel.resetDamper();
                                }
                                catch (TGException | InterruptedException tge) {
                                    tge.printStackTrace();
                                }
                                ++n2;
                            }
                            (this).GLPanel.this.mouseDraw.selectedCommIds = null;
                            String fromDateString = GLPanel.this.df.format(GLPanel.this.vtm.getFirstDate()).replaceAll("\\.01\\.01", "");
                            fromDateString = fromDateString.replaceAll("\\.", "");
                            int fromDateInt = Integer.parseInt(fromDateString);
                            String toDateString = GLPanel.this.df.format(GLPanel.this.vtm.getLastDate()).replaceAll("\\.01\\.01", "");
                            toDateString = toDateString.replaceAll("\\.", "");
                            int toDateInt = Integer.parseInt(toDateString);
                            int fromDateActual = Integer.parseInt(GLPanel.this.fromDate.getText().replaceAll("\\.01\\.01", "").replaceAll("\\.", ""));
                            int toDateActual = Integer.parseInt(GLPanel.this.toDate.getText().replaceAll("\\.01\\.01", "").replaceAll("\\.", ""));
                            if (!searchResult.equals("search box") && searchResult.trim().length() > 0 || fromDateInt != fromDateActual || toDateInt != toDateActual) {
                                GLPanel.this.searchFilter();
                            }
                        }
                        try {
                            (this).GLPanel.this.tgPanel.updateLocalityFromVisibility();
                            (this).GLPanel.this.tgPanel.resetDamper();
                        }
                        catch (TGException tge) {
                            tge.printStackTrace();
                        }
                    }
                };
                Thread expandMultiVisualizationThread = new Thread(expandMultiRun);
                expandMultiVisualizationThread.setPriority(10);
                expandMultiVisualizationThread.start();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
    }

    private void addEdges(Index[] closestNodes) {
        this.addEdges(closestNodes, 0);
    }

    private void addEdges(Index[] closestNodes, int offset) {
        double maxWeight = Double.MIN_VALUE;
        double minWeight = Double.MAX_VALUE;
        Index[] indexArray = closestNodes;
        int n = closestNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Index i = indexArray[n2];
            if (i != null && maxWeight < i.getDistance()) {
                maxWeight = i.getDistance();
            }
            if (i != null && minWeight > i.getDistance() && i.getDistance() > 0.0) {
                minWeight = i.getDistance();
            }
            ++n2;
        }
        double weightSpan = maxWeight - minWeight;
        int i = 0;
        while (i < closestNodes.length) {
            double weight;
            Index closestindex = closestNodes[i];
            double d = weight = closestindex == null ? 0.0 : closestNodes[i].getDistance();
            if (weight > 0.0) {
                int from = offset + i / this.maxNeighbors;
                int to = offset + closestNodes[i].getIndex();
                Node fromNode = this.tgPanel.findNode(Integer.toString(from));
                Node toNode = this.tgPanel.findNode(Integer.toString(to));
                double distanceRatio = 1.0 - (weight - minWeight) / weightSpan;
                if (offset > 0 || offset == 0 && fromNode.isVisible() && toNode.isVisible()) {
                    this.tgPanel.addEdge(fromNode, toNode, 1 + (int)(1000.0 * distanceRatio));
                }
            }
            ++i;
        }
    }

    private void addToggleButton(int id, String str) {
        this.tb = new JToggleButton(str, true);
        this.tb.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                if (arg0.getKeyChar() == '\u001b' && MouseDraw.path != null) {
                    MouseDraw.path.closePath();
                    MouseDraw.path = null;
                    MouseDraw.drawing = false;
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        this.tb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    rightClickCenter = true;
                    int commIdToFlip = ((MyCheckBoxIcon)((JToggleButton)e.getSource()).getIcon()).getCommId();
                    rightClickNode = GLPanel.this.tgPanel.findNode(Integer.toString(commIdToFlip + GLPanel.this.vtm.getTotalDocumentSize()));
                    GLPanel.this.getHVScroll().slowScrollToCenter(rightClickNode);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        this.tb.setFont(new Font("Arial", 0, 11));
        this.tb.addActionListener(this);
        this.tb.setIcon(new MyCheckBoxIcon(id, this.colors[id], false));
        this.tb.setSelectedIcon(new MyCheckBoxIcon(id, this.colors[id], true));
        this.tb.setHorizontalAlignment(2);
        this.communitiesPanel.add(this.tb);
        this.tb.setForeground(Color.DARK_GRAY);
    }

    private void refreshToggleButton(int id, Color rgb) {
        this.hideButton.setEnabled(true);
        this.hideButton.setBackground(Color.lightGray);
        this.hideButton.setForeground(Color.darkGray);
        Component component = this.communitiesPanel.getComponent(id);
        if (!((AbstractButton)component).getText().contains("EXPANDED: ")) {
            this.tb = new JToggleButton("", true);
            this.tb.setFont(new Font("Arial", 0, 11));
            this.tb.addActionListener(this);
            this.tb.setText("EXPANDED: " + ((JToggleButton)component).getActionCommand());
            this.tb.setIcon(new MyCheckBoxIcon(id, rgb, false));
            this.tb.setSelectedIcon(new MyCheckBoxIcon(id, rgb, true));
            this.tb.setHorizontalAlignment(2);
            this.tb.setForeground(Color.red);
            this.communitiesPanel.remove(id);
            this.communitiesPanel.add((Component)this.tb, id);
            this.revalidate();
        }
    }

    public FileInputStream inputReader() {
        FileInputStream fis = null;
        JFileChooser locationChooser = new JFileChooser();
        locationChooser.setFileSelectionMode(0);
        if (locationChooser.showOpenDialog(this.frame) == 0) {
            try {
                fis = new FileInputStream(locationChooser.getSelectedFile());
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        return fis;
    }

    public static void main(String[] args) {
        InputStream in;
        JFrame frame;
        block4: {
            frame = new JFrame("KeyphraseViz Applet");
            in = null;
            try {
                in = NLPUtils.getInputStreamFromURLOrClasspathOrFileSystem("aac_keyphrases_extended_full.out");
            }
            catch (IOException e) {
                JFileChooser locationChooser = new JFileChooser();
                locationChooser.setFileSelectionMode(0);
                if (locationChooser.showOpenDialog(frame) != 0) break block4;
                try {
                    in = new FileInputStream(locationChooser.getSelectedFile());
                }
                catch (FileNotFoundException ei) {
                    ei.printStackTrace();
                }
            }
        }
        GLPanel glPanel = new GLPanel(in, "aac", false, 3, 10, ReducedMemVTM.Calculation.PRODUCT, ReducedMemVTM.Metric.PROBABILITY, 1200, 1000);
        glPanel.setPreferredSize(new Dimension(1250, 800));
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(2);
            }
        });
        frame.setJMenuBar(glPanel.createMenu());
        frame.add("Center", glPanel);
        frame.pack();
        frame.setVisible(true);
    }

    public void searchFilter() {
        int n;
        Object selection;
        int numOfSimpleNodes = this.vtm.getTotalDocumentSize();
        int numOfTotalNodes = numOfSimpleNodes + this.vtm.getDocsToCommunities().size();
        searchResult = this.search.getText();
        Object[] searchResultParts = searchResult.toLowerCase().split("\\s|\\p{Punct}");
        boolean searchOr = false;
        boolean searchAnd = false;
        String okayNode = null;
        int index = 0;
        String previous = "";
        String previousKey = "";
        TreeMap<Object, String> sm = new TreeMap<Object, String>();
        String strFromDate = this.fromDate.getText();
        String strToDate = this.toDate.getText();
        int[] dateFilteredDocIds = null;
        try {
            dateFilteredDocIds = this.vtm.filterForDates(this.df.parse(strFromDate).getTime(), this.df.parse(strToDate).getTime());
            if (dateFilteredDocIds.length == numOfSimpleNodes) {
                dateFilteredDocIds = null;
            } else if (dateFilteredDocIds.length == 0) {
                dateFilteredDocIds = new int[]{-1};
            }
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        if (searchResult.matches("(?i).* (OR|\\|\\|) .*")) {
            searchOr = true;
            searchResultParts = searchResult.split("(?i) (or|\\|\\|) ");
            selection = new HashSet<Integer>();
            int indexOR = 0;
            Object[] objectArray = searchResultParts;
            n = searchResultParts.length;
            int n2 = 0;
            while (n2 < n) {
                Object i = objectArray[n2];
                searchResultParts[indexOR++] = ((String)i).trim();
                int[] nArray = this.vtm.getDocIdsWithKeyphrase((String)i);
                int n3 = nArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    int j = nArray[n4];
                    selection.add(j);
                    ++n4;
                }
                ++n2;
            }
            this.containingDocIds = new int[selection.size()];
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                int s = (Integer)iterator.next();
                this.containingDocIds[index++] = s;
            }
        }
        if (searchResult.matches("(?i).* (and|&&) .*")) {
            Object actualSelection;
            searchAnd = true;
            searchResultParts = searchResult.split("(?i) (and|&&) ");
            selection = new HashSet();
            int p = 0;
            while (p < searchResultParts.length) {
                searchResultParts[p] = ((String)searchResultParts[p]).trim();
                actualSelection = new HashSet();
                int[] j = this.vtm.getDocIdsWithKeyphrase((String)searchResultParts[p]);
                int n5 = j.length;
                n = 0;
                while (n < n5) {
                    int j2 = j[n];
                    actualSelection.add(j2);
                    ++n;
                }
                if (p == 0) {
                    selection = actualSelection;
                } else {
                    selection.retainAll((Collection<?>)actualSelection);
                }
                ++p;
            }
            this.containingDocIds = new int[selection.size()];
            actualSelection = selection.iterator();
            while (actualSelection.hasNext()) {
                int s = (Integer)actualSelection.next();
                this.containingDocIds[index++] = s;
            }
        }
        if (!searchResult.equals("search box") && searchResult.trim().length() > 0 && !searchResult.matches("(?i).* (and|&&|OR|\\|\\|) .*")) {
            searchResultParts = searchResult.trim().toLowerCase().split("\\s|\\p{Punct}");
            this.containingDocIds = this.vtm.getDocIdsWithKeyphrase(searchResult);
        }
        if (searchResult.length() > 0 && !searchOr && !searchAnd) {
            System.err.println("search: " + Arrays.toString(searchResultParts));
        }
        if (searchResult.length() > 0 && searchOr) {
            System.err.println("searchOr: " + Arrays.toString(searchResultParts));
        }
        if (searchResult.length() > 0 && searchAnd) {
            System.err.println("searchAnd: " + Arrays.toString(searchResultParts));
        }
        boolean[] communityPassing = new boolean[this.communityHiddenness.length];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < numOfTotalNodes) {
            Node n6 = this.tgPanel.findNode(Integer.toString(i));
            if (n6 != null) {
                int communityOfNode = i < numOfSimpleNodes ? this.communities[i] : i - numOfSimpleNodes;
                int nextOkDateId = dateFilteredDocIds == null ? i : dateFilteredDocIds[j];
                int nextOkPhraseId = i;
                if (this.containingDocIds != null && this.containingDocIds.length == 0) {
                    nextOkPhraseId = -1;
                } else if (this.containingDocIds != null) {
                    nextOkPhraseId = this.containingDocIds[k];
                }
                boolean needToDraw = false;
                if (communityOfNode != -1) {
                    boolean bl = communityPassing[communityOfNode] = communityPassing[communityOfNode] || nextOkPhraseId == i && nextOkDateId == i;
                    needToDraw = i < numOfSimpleNodes ? !this.communityCompressedness[communityOfNode] && !this.communityHiddenness[communityOfNode] : this.communityCompressedness[communityOfNode] && !this.communityHiddenness[communityOfNode];
                }
                n6.setVisible(nextOkPhraseId == i && nextOkDateId == i && needToDraw);
                if (nextOkPhraseId != i && nextOkDateId == i && communityOfNode != -1 && !this.communityHiddenness[communityOfNode]) {
                    int n7;
                    int n8;
                    Object[] objectArray;
                    int t;
                    String[] metaDataParts = n6.getLabel().toLowerCase().split("\\s|\\p{Punct}");
                    if (!searchOr && !searchAnd) {
                        t = 0;
                        while (t < metaDataParts.length) {
                            int matches = 0;
                            int l = 0;
                            while (matches == l && l < searchResultParts.length && t + matches < metaDataParts.length) {
                                if (((String)searchResultParts[l]).equals(metaDataParts[t + matches])) {
                                    ++matches;
                                }
                                ++l;
                            }
                            if (matches == searchResultParts.length) {
                                if (!this.communityCompressedness[communityOfNode]) {
                                    n6.setVisible(true);
                                }
                                communityPassing[communityOfNode] = true;
                                break;
                            }
                            ++t;
                        }
                    }
                    if (searchOr) {
                        t = 0;
                        while (t < metaDataParts.length) {
                            objectArray = searchResultParts;
                            n8 = searchResultParts.length;
                            n7 = 0;
                            while (n7 < n8) {
                                Object string = objectArray[n7];
                                if (((String)string).equals(metaDataParts[t])) {
                                    if (!this.communityCompressedness[communityOfNode]) {
                                        n6.setVisible(true);
                                    }
                                    communityPassing[communityOfNode] = true;
                                    break;
                                }
                                ++n7;
                            }
                            ++t;
                        }
                    }
                    if (searchAnd) {
                        t = 0;
                        while (t < metaDataParts.length) {
                            objectArray = searchResultParts;
                            n8 = searchResultParts.length;
                            n7 = 0;
                            while (n7 < n8) {
                                Object string = objectArray[n7];
                                if (((String)string).equals(metaDataParts[t])) {
                                    sm.put(string, n6.getID());
                                    for (Map.Entry entry : sm.entrySet()) {
                                        if (entry.getValue() == previous && entry.getKey() != previousKey) {
                                            okayNode = (String)entry.getValue();
                                        }
                                        previous = (String)entry.getValue();
                                        previousKey = (String)entry.getKey();
                                    }
                                    if (n6.getID() != okayNode) break;
                                    if (!this.communityCompressedness[communityOfNode]) {
                                        n6.setVisible(true);
                                    }
                                    communityPassing[communityOfNode] = true;
                                    break;
                                }
                                ++n7;
                            }
                            ++t;
                        }
                    }
                }
                j += nextOkDateId <= i && (dateFilteredDocIds == null || j < dateFilteredDocIds.length - 1) ? 1 : 0;
                k += nextOkPhraseId <= i && (this.containingDocIds == null || k < this.containingDocIds.length - 1) ? 1 : 0;
                if (i >= numOfSimpleNodes) {
                    n6.setVisible(needToDraw && communityPassing[communityOfNode]);
                }
            }
            ++i;
        }
        try {
            this.tgPanel.stopDamper();
            this.tgPanel.updateLocalityFromVisibility();
            this.tgPanel.repaint();
            this.tgPanel.resetDamper();
        }
        catch (TGException tge) {
            tge.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int numOfSimpleNodes = this.vtm.getTotalDocumentSize();
        if (e.getSource() instanceof JToggleButton) {
            int commIdToFlip = ((MyCheckBoxIcon)((JToggleButton)e.getSource()).getIcon()).getCommId();
            boolean bl = this.communityHiddenness[commIdToFlip] = !this.communityHiddenness[commIdToFlip];
            if (!this.communityHiddenness[commIdToFlip] && numOfSimpleNodes > 500) {
                this.communityCompressedness[commIdToFlip] = true;
            }
        }
        this.searchFilter();
    }

    public void aboutMenu() {
        JFrame aboutDialog = new JFrame("about...");
        aboutDialog.setSize(290, 150);
        aboutDialog.setLayout(new GridLayout(3, 0));
        JLabel title = new JLabel("<html><center>Visualization tool for document collections <br>created at the <b>University of Szeged.<b></center></html>");
        title.setFont(title.getFont().deriveFont(13.0f));
        JLabel lastUpdate = new JLabel("<html><center>Last update: 2013.12.09</center>");
        lastUpdate.setFont(lastUpdate.getFont().deriveFont(10.0f));
        JLabel link = new JLabel("<html><center>For further information <font color='blue'><u>click here</u></font></center>");
        link.setCursor(Cursor.getPredefinedCursor(12));
        String url = "http://www.inf.u-szeged.hu/~berendg/keyphraseViz/";
        link.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    if (Desktop.isDesktopSupported()) {
                        Desktop desktop = Desktop.getDesktop();
                        try {
                            URI uri = new URI("http://www.inf.u-szeged.hu/~berendg/keyphraseViz/");
                            desktop.browse(uri);
                        }
                        catch (IOException uri) {
                        }
                        catch (URISyntaxException uri) {}
                    } else {
                        String osName = System.getProperty("os.name");
                        try {
                            if (osName.startsWith("Windows")) {
                                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler http://www.inf.u-szeged.hu/~berendg/keyphraseViz/");
                            } else {
                                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                                String browser = null;
                                int count = 0;
                                while (count < browsers.length && browser == null) {
                                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() == 0) {
                                        browser = browsers[count];
                                    }
                                    ++count;
                                }
                                Runtime.getRuntime().exec(new String[]{browser, "http://www.inf.u-szeged.hu/~berendg/keyphraseViz/"});
                            }
                        }
                        catch (Exception e2) {
                            JTextArea textarea = new JTextArea("http://www.inf.u-szeged.hu/~berendg/keyphraseViz/");
                            textarea.setEditable(false);
                            JOptionPane.showMessageDialog(null, textarea, "Please, highlight the url", 0);
                        }
                    }
                }
            }
        });
        aboutDialog.add(title);
        aboutDialog.add(link);
        aboutDialog.setBackground(defaultBackColor);
        aboutDialog.add(lastUpdate);
        aboutDialog.setLocationRelativeTo(this.getRootPane());
        aboutDialog.setVisible(true);
        aboutDialog.setDefaultCloseOperation(2);
    }

    public void initMenu() {
        boolean etalonColoring = false;
        int numOfNeighbors = 3;
        int keyphraseThreshold = 10;
        final JComboBox<ReducedMemVTM.Calculation> combo = new JComboBox<ReducedMemVTM.Calculation>();
        ReducedMemVTM.Calculation[] calculationArray = ReducedMemVTM.Calculation.values();
        int n = calculationArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReducedMemVTM.Calculation dir = calculationArray[n2];
            combo.addItem(dir);
            ++n2;
        }
        combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.err.println("Selected Calculation: " + combo.getSelectedItem());
                GLPanel.this.c = (ReducedMemVTM.Calculation)((Object)combo.getSelectedItem());
            }
        });
        final JComboBox<ReducedMemVTM.Metric> combo2 = new JComboBox<ReducedMemVTM.Metric>();
        ReducedMemVTM.Metric[] metricArray = ReducedMemVTM.Metric.values();
        int n3 = metricArray.length;
        n = 0;
        while (n < n3) {
            ReducedMemVTM.Metric dir = metricArray[n];
            combo2.addItem(dir);
            ++n;
        }
        combo2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.err.println("Selected Metric: " + combo2.getSelectedItem());
                GLPanel.this.m = (ReducedMemVTM.Metric)((Object)combo2.getSelectedItem());
            }
        });
        JTextField xField = new JTextField(3);
        JTextField yField = new JTextField(3);
        JCheckBox demoInput = new JCheckBox("Demo Input init", true);
        JCheckBox etalonColoringInput = new JCheckBox("etalonColoring", false);
        boolean parseIsOk = false;
        JPanel myPanel = new JPanel();
        myPanel.setLayout(new BoxLayout(myPanel, 1));
        myPanel.setAlignmentX(0.5f);
        myPanel.add(new JLabel("Calculation"));
        myPanel.add(combo);
        myPanel.add(new JLabel("Metric"));
        myPanel.add(combo2);
        myPanel.add(new JLabel("numOfNeighbors(1-10): "));
        myPanel.add(xField);
        myPanel.add(Box.createVerticalBox());
        myPanel.add(new JLabel("keyphraseThreshold(1-50): "));
        myPanel.add(yField);
        myPanel.add(demoInput);
        myPanel.add(etalonColoringInput);
        boolean kilep = false;
        while (!parseIsOk || kilep) {
            int result = JOptionPane.showConfirmDialog(null, myPanel, "ReInitialize", 2);
            if (result == 0) {
                try {
                    numOfNeighbors = Integer.parseInt(xField.getText());
                    keyphraseThreshold = Integer.parseInt(yField.getText());
                    parseIsOk = true;
                }
                catch (Exception e2) {
                    parseIsOk = false;
                    JOptionPane.showMessageDialog(null, "Incorrect values");
                }
                if ((numOfNeighbors < 1 || numOfNeighbors > 10 || keyphraseThreshold < 1 || keyphraseThreshold > 50) && result == 0 && parseIsOk) {
                    JOptionPane.showMessageDialog(null, "Out of limit!");
                    parseIsOk = false;
                }
                if (numOfNeighbors < 1 || numOfNeighbors > 10 || keyphraseThreshold < 1 || keyphraseThreshold > 50 || result != 0 || !parseIsOk) continue;
                parseIsOk = true;
                System.err.println("numOfNeighbors: " + numOfNeighbors);
                System.err.println("keyphraseThreshold: " + keyphraseThreshold);
                etalonColoring = etalonColoringInput.isSelected();
                if (demoInput.isSelected()) {
                    try {
                        this.in = NLPUtils.getInputStreamFromURLOrClasspathOrFileSystem("aac_keyphrases_extended_short.out");
                    }
                    catch (IOException e2) {
                        JOptionPane.showMessageDialog(null, "Demo input not found!");
                        this.in = this.inputReader();
                    }
                } else {
                    this.in = this.inputReader();
                }
                if (this.in == null) continue;
                try {
                    this.tgPanel.updateLocalityFromVisibility();
                    this.tgPanel.repaint();
                    Window w = SwingUtilities.getWindowAncestor(this.tgPanel);
                    w.setVisible(false);
                }
                catch (TGException tge) {
                    tge.printStackTrace();
                }
                GLPanel glPanel = new GLPanel(this.in, "aac", etalonColoring, numOfNeighbors, keyphraseThreshold, this.c, this.m, 1200, 1000);
                glPanel.setPreferredSize(new Dimension(1250, 800));
                this.frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(2);
                    }
                });
                this.frame.setJMenuBar(glPanel.createMenu());
                this.frame.add("Center", glPanel);
                this.frame.pack();
                this.frame.setVisible(true);
                continue;
            }
            parseIsOk = true;
        }
    }

    public class MyCheckBoxIcon
    implements Icon {
        private Color color;
        private int width;
        private int height;
        private int commId;
        private boolean checked;

        MyCheckBoxIcon(int community, Color iconColor, boolean set) {
            this.commId = community;
            this.checked = set;
            this.color = iconColor;
            Icon icon = UIManager.getIcon("CheckBox.icon");
            this.width = icon.getIconWidth();
            this.height = icon.getIconHeight();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Component component = GLPanel.this.communitiesPanel.getComponent(this.commId);
            if (!this.checked && component.getForeground() == Color.red) {
                component.setFont(new Font("Arial", 0, 11));
                component.setForeground(Color.DARK_GRAY);
                ((JToggleButton)component).setText(((JToggleButton)component).getActionCommand().replace("EXPANDED: ", ""));
                g.drawRect(x + 1, y, this.width - 2, this.height - 2);
            }
            g.setColor(this.color);
            if (this.checked) {
                g.fillRect(x, y, this.width, this.height);
                c.setBackground(Color.white);
            } else {
                g.drawRect(x + 1, y, this.width - 2, this.height - 2);
                if (y > 7) {
                    g.drawString("h", x - 8, y);
                    g.drawString("i", x - 8, y + 6);
                    g.drawString("d", x - 8, y + 12);
                    g.drawString("d", x - 8, y + 20);
                    g.drawString("e", x - 0, y + 20);
                    g.drawString("n", x + 8, y + 20);
                    g.fillRect(0, 0, this.width - 6, this.height + 800);
                } else {
                    g.fillRect(0, 0, this.width - 4, this.height + 800);
                }
            }
        }

        public int getCommId() {
            return this.commId;
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }
    }
}

