/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.graphelements.GESUtils;
import com.touchgraph.graphlayout.graphelements.Locality;
import com.touchgraph.graphlayout.graphelements.TGForEachNode;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LocalityUtils {
    TGPanel tgPanel;
    Locality locality;
    public static final int INFINITE_LOCALITY_RADIUS = Integer.MAX_VALUE;
    ShiftLocaleThread shiftLocaleThread;
    boolean fastFinishShift = false;

    public LocalityUtils(Locality loc, TGPanel tgp) {
        this.locality = loc;
        this.tgPanel = tgp;
    }

    public void fastFinishAnimation() {
        this.fastFinishShift = true;
    }

    private synchronized boolean markDistantNodes(final Hashtable subgraph) {
        final boolean[] someNodeWasMarked = new boolean[]{false};
        TGForEachNode fen = new TGForEachNode(){

            @Override
            public void forEachNode(Node n) {
                if (!subgraph.containsKey(n)) {
                    n.markedForRemoval = true;
                    someNodeWasMarked[0] = true;
                }
            }
        };
        this.locality.forAllNodes(fen);
        return someNodeWasMarked[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void removeMarkedNodes() {
        final Vector<Node> nodesToRemove = new Vector<Node>();
        TGForEachNode fen = new TGForEachNode(){

            @Override
            public void forEachNode(Node n) {
                if (n.markedForRemoval) {
                    nodesToRemove.addElement(n);
                    n.markedForRemoval = false;
                    n.massfade = 1.0;
                }
            }
        };
        Locality locality = this.locality;
        synchronized (locality) {
            this.locality.forAllNodes(fen);
            this.locality.removeNodes(nodesToRemove);
        }
    }

    private synchronized void addNearNodes(Hashtable distHash, int radius) throws TGException {
        int r = 0;
        while (r < radius + 1) {
            Enumeration localNodes = distHash.keys();
            while (localNodes.hasMoreElements()) {
                Node n = (Node)localNodes.nextElement();
                if (this.locality.contains(n) || (Integer)distHash.get(n) > r) continue;
                n.massfade = 1.0;
                n.justMadeLocal = true;
                this.locality.addNodeWithEdges(n);
                if (this.fastFinishShift) continue;
                try {
                    if (radius == 1) {
                        Thread.sleep(50L);
                        continue;
                    }
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++r;
        }
    }

    private synchronized void unmarkNewAdditions() {
        TGForEachNode fen = new TGForEachNode(){

            @Override
            public void forEachNode(Node n) {
                n.justMadeLocal = false;
            }
        };
        this.locality.forAllNodes(fen);
    }

    public void setLocale(Node n, int radius, int maxAddEdgeCount, int maxExpandEdgeCount, boolean unidirectional) throws TGException {
        if (n == null || radius < 0) {
            return;
        }
        if (this.shiftLocaleThread != null && this.shiftLocaleThread.isAlive()) {
            this.fastFinishShift = true;
            while (this.shiftLocaleThread.isAlive()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (radius == Integer.MAX_VALUE || n == null) {
            this.addAllGraphElts();
            this.tgPanel.resetDamper();
            return;
        }
        this.fastFinishShift = false;
        this.shiftLocaleThread = new ShiftLocaleThread(n, radius, maxAddEdgeCount, maxExpandEdgeCount, unidirectional);
    }

    public void setLocale(Node n, int radius) throws TGException {
        this.setLocale(n, radius, 1000, 1000, false);
    }

    public synchronized void addAllGraphElts() throws TGException {
        this.locality.addAll();
    }

    public void expandNode(final Node n) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LocalityUtils localityUtils = LocalityUtils.this;
                synchronized (localityUtils) {
                    if (!LocalityUtils.this.locality.getCompleteEltSet().contains(n)) {
                        return;
                    }
                    LocalityUtils.this.tgPanel.stopDamper();
                    int i = 0;
                    while (i < n.edgeCount()) {
                        Node newNode = n.edgeAt(i).getOtherEndpt(n);
                        if (!LocalityUtils.this.locality.contains(newNode)) {
                            newNode.justMadeLocal = true;
                            try {
                                LocalityUtils.this.locality.addNodeWithEdges(newNode);
                                Thread.sleep(50L);
                            }
                            catch (TGException tge) {
                                System.err.println("TGException: " + tge.getMessage());
                            }
                            catch (InterruptedException interruptedException) {}
                        } else if (!LocalityUtils.this.locality.contains(n.edgeAt(i))) {
                            LocalityUtils.this.locality.addEdge(n.edgeAt(i));
                        }
                        ++i;
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LocalityUtils.this.unmarkNewAdditions();
                    LocalityUtils.this.tgPanel.resetDamper();
                }
            }
        }.start();
    }

    public synchronized void hideNode(final Node hideNode) {
        if (hideNode == null) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LocalityUtils localityUtils = LocalityUtils.this;
                synchronized (localityUtils) {
                    if (!LocalityUtils.this.locality.getCompleteEltSet().contains(hideNode)) {
                        return;
                    }
                    LocalityUtils.this.locality.removeNode(hideNode);
                    if (hideNode == LocalityUtils.this.tgPanel.getSelect()) {
                        LocalityUtils.this.tgPanel.clearSelect();
                    }
                    Hashtable subgraph = GESUtils.getLargestConnectedSubgraph(LocalityUtils.this.locality);
                    LocalityUtils.this.markDistantNodes(subgraph);
                    LocalityUtils.this.tgPanel.repaint();
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LocalityUtils.this.removeMarkedNodes();
                    LocalityUtils.this.tgPanel.resetDamper();
                }
            }
        }.start();
    }

    public synchronized void collapseNode(final Node collapseNode) {
        if (collapseNode == null) {
            return;
        }
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LocalityUtils localityUtils = LocalityUtils.this;
                synchronized (localityUtils) {
                    if (!LocalityUtils.this.locality.getCompleteEltSet().contains(collapseNode)) {
                        return;
                    }
                    LocalityUtils.this.locality.removeNode(collapseNode);
                    Hashtable subgraph = GESUtils.getLargestConnectedSubgraph(LocalityUtils.this.locality);
                    LocalityUtils.this.markDistantNodes(subgraph);
                    try {
                        LocalityUtils.this.locality.addNodeWithEdges(collapseNode);
                    }
                    catch (TGException tge) {
                        tge.printStackTrace();
                    }
                    LocalityUtils.this.tgPanel.repaint();
                    LocalityUtils.this.tgPanel.resetDamper();
                    try {
                        Thread.sleep(600L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LocalityUtils.this.removeMarkedNodes();
                    LocalityUtils.this.tgPanel.resetDamper();
                }
            }
        }.start();
    }

    class ShiftLocaleThread
    extends Thread {
        Hashtable distHash;
        Node focusNode;
        int radius;
        int maxAddEdgeCount;
        int maxExpandEdgeCount;
        boolean unidirectional;

        ShiftLocaleThread(Node n, int r, int maec, int meec, boolean unid) {
            this.focusNode = n;
            this.radius = r;
            this.maxAddEdgeCount = maec;
            this.maxExpandEdgeCount = meec;
            this.unidirectional = unid;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LocalityUtils localityUtils = LocalityUtils.this;
            synchronized (localityUtils) {
                if (!LocalityUtils.this.locality.getCompleteEltSet().contains(this.focusNode)) {
                    return;
                }
                LocalityUtils.this.tgPanel.stopDamper();
                this.distHash = GESUtils.calculateDistances(LocalityUtils.this.locality.getCompleteEltSet(), this.focusNode, this.radius, this.maxAddEdgeCount, this.maxExpandEdgeCount, this.unidirectional);
                try {
                    int i;
                    if (this.radius == 1) {
                        LocalityUtils.this.addNearNodes(this.distHash, this.radius);
                        i = 0;
                        while (i < 4 && !LocalityUtils.this.fastFinishShift) {
                            Thread.sleep(100L);
                            ++i;
                        }
                        LocalityUtils.this.unmarkNewAdditions();
                        i = 0;
                        while (i < 4 && !LocalityUtils.this.fastFinishShift) {
                            Thread.sleep(100L);
                            ++i;
                        }
                    }
                    if (LocalityUtils.this.markDistantNodes(this.distHash)) {
                        i = 0;
                        while (i < 8 && !LocalityUtils.this.fastFinishShift) {
                            Thread.sleep(100L);
                            ++i;
                        }
                    }
                    LocalityUtils.this.removeMarkedNodes();
                    i = 0;
                    while (i < 1 && !LocalityUtils.this.fastFinishShift) {
                        if (this.radius > 1) {
                            Thread.sleep(100L);
                        }
                        ++i;
                    }
                    if (this.radius != 1) {
                        LocalityUtils.this.addNearNodes(this.distHash, this.radius);
                        i = 0;
                        while (i < 4 && !LocalityUtils.this.fastFinishShift) {
                            Thread.sleep(100L);
                            ++i;
                        }
                        LocalityUtils.this.unmarkNewAdditions();
                    }
                }
                catch (TGException tge) {
                    System.err.println("TGException: " + tge.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                LocalityUtils.this.tgPanel.resetDamper();
            }
        }
    }
}

