/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.graphelements.TGForEachEdge;
import com.touchgraph.graphlayout.graphelements.TGForEachNode;
import com.touchgraph.graphlayout.graphelements.TGForEachNodePair;

public class TGLayout
implements Runnable {
    private TGPanel tgPanel;
    private Thread relaxer;
    private double damper = 0.0;
    private double maxMotion = 0.0;
    private double lastMaxMotion = 0.0;
    private double motionRatio = 0.0;
    private boolean damping = true;
    private double rigidity = 1.0;
    private double newRigidity = 1.0;
    Node dragNode = null;

    public TGLayout(TGPanel tgp) {
        this.tgPanel = tgp;
        this.relaxer = null;
    }

    void setRigidity(double r) {
        this.newRigidity = r;
    }

    void setDragNode(Node n) {
        this.dragNode = n;
    }

    private synchronized void relaxEdges() {
        TGForEachEdge fee = new TGForEachEdge(){

            @Override
            public void forEachEdge(Edge e) {
                double massfade;
                double vx = e.to.x - e.from.x;
                double vy = e.to.y - e.from.y;
                double len = Math.sqrt(vx * vx + vy * vy);
                double dx = vx * TGLayout.this.rigidity;
                double dy = vy * TGLayout.this.rigidity;
                dx /= (double)(e.getLength() * 100);
                dy /= (double)(e.getLength() * 100);
                if (e.to.justMadeLocal || e.to.markedForRemoval || !e.from.justMadeLocal && !e.from.markedForRemoval) {
                    e.to.dx -= dx * len;
                    e.to.dy -= dy * len;
                } else {
                    massfade = e.from.markedForRemoval ? e.from.massfade : 1.0 - e.from.massfade;
                    massfade *= massfade;
                    e.to.dx -= dx * len * massfade;
                    e.to.dy -= dy * len * massfade;
                }
                if (e.from.justMadeLocal || e.from.markedForRemoval || !e.to.justMadeLocal && !e.to.markedForRemoval) {
                    e.from.dx += dx * len;
                    e.from.dy += dy * len;
                } else {
                    massfade = e.to.markedForRemoval ? e.to.massfade : 1.0 - e.to.massfade;
                    massfade *= massfade;
                    e.from.dx += dx * len * massfade;
                    e.from.dy += dy * len * massfade;
                }
            }
        };
        this.tgPanel.getGES().forAllEdges(fee);
    }

    private synchronized void avoidLabels() {
        TGForEachNodePair fenp = new TGForEachNodePair(){

            @Override
            public void forEachNodePair(Node n1, Node n2) {
                double massfade;
                double dx = 0.0;
                double dy = 0.0;
                double vx = n1.x - n2.x;
                double vy = n1.y - n2.y;
                double len = vx * vx + vy * vy;
                if (len == 0.0) {
                    dx = Math.random();
                    dy = Math.random();
                } else if (len < 360000.0) {
                    dx = vx / len;
                    dy = vy / len;
                }
                int repSum = n1.repulsion * n2.repulsion / 100;
                if (n1.justMadeLocal || n1.markedForRemoval || !n2.justMadeLocal && !n2.markedForRemoval) {
                    n1.dx += dx * (double)repSum * TGLayout.this.rigidity;
                    n1.dy += dy * (double)repSum * TGLayout.this.rigidity;
                } else {
                    massfade = n2.markedForRemoval ? n2.massfade : 1.0 - n2.massfade;
                    massfade *= massfade;
                    n1.dx += dx * (double)repSum * TGLayout.this.rigidity * massfade;
                    n1.dy += dy * (double)repSum * TGLayout.this.rigidity * massfade;
                }
                if (n2.justMadeLocal || n2.markedForRemoval || !n1.justMadeLocal && !n1.markedForRemoval) {
                    n2.dx -= dx * (double)repSum * TGLayout.this.rigidity;
                    n2.dy -= dy * (double)repSum * TGLayout.this.rigidity;
                } else {
                    massfade = n1.markedForRemoval ? n1.massfade : 1.0 - n1.massfade;
                    massfade *= massfade;
                    n2.dx -= dx * (double)repSum * TGLayout.this.rigidity * massfade;
                    n2.dy -= dy * (double)repSum * TGLayout.this.rigidity * massfade;
                }
            }
        };
        this.tgPanel.getGES().forAllNodePairs(fenp);
    }

    public void startDamper() {
        this.damping = true;
    }

    public void stopDamper() {
        this.damping = false;
        this.damper = 1.0;
    }

    public void resetDamper() {
        this.damping = true;
        this.damper = 1.0;
    }

    public void stopMotion() {
        this.damping = true;
        this.damper = this.damper > 0.3 ? 0.3 : 0.0;
    }

    public void damp() {
        if (this.damping && this.motionRatio <= 0.001) {
            if ((this.maxMotion < 0.2 || this.maxMotion > 1.0 && this.damper < 0.9) && this.damper > 0.01) {
                this.damper -= 0.01;
            } else if (this.maxMotion < 0.4 && this.damper > 0.003) {
                this.damper -= 0.003;
            } else if (this.damper > 1.0E-4) {
                this.damper -= 1.0E-4;
            }
        }
        if (this.maxMotion < 0.001 && this.damping) {
            this.damper = 0.0;
        }
    }

    private synchronized void moveNodes() {
        this.lastMaxMotion = this.maxMotion;
        final double[] maxMotionA = new double[]{0.0};
        TGForEachNode fen = new TGForEachNode(){

            @Override
            public void forEachNode(Node n) {
                double dx = n.dx;
                double dy = n.dy;
                n.dx = (dx *= TGLayout.this.damper) / 2.0;
                n.dy = (dy *= TGLayout.this.damper) / 2.0;
                double distMoved = Math.sqrt(dx * dx + dy * dy);
                if (!n.fixed && n != TGLayout.this.dragNode) {
                    n.x += Math.max(-30.0, Math.min(30.0, dx));
                    n.y += Math.max(-30.0, Math.min(30.0, dy));
                }
                maxMotionA[0] = Math.max(distMoved, maxMotionA[0]);
                if (!n.justMadeLocal && !n.markedForRemoval) {
                    n.massfade = 1.0;
                } else if (n.massfade >= 0.004) {
                    n.massfade -= 0.004;
                }
            }
        };
        this.tgPanel.getGES().forAllNodes(fen);
        this.maxMotion = maxMotionA[0];
        this.motionRatio = this.maxMotion > 0.0 ? this.lastMaxMotion / this.maxMotion - 1.0 : 0.0;
        this.damp();
    }

    private synchronized void relax() {
        int i = 0;
        while (i < 10) {
            this.relaxEdges();
            this.avoidLabels();
            this.moveNodes();
            ++i;
        }
        if (this.rigidity != this.newRigidity) {
            this.rigidity = this.newRigidity;
        }
        this.tgPanel.repaintAfterMove();
    }

    private void myWait() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        Thread me = Thread.currentThread();
        while (this.relaxer == me) {
            this.relax();
            try {
                Thread.sleep(20L);
                while (this.damper < 0.1 && this.damping && this.maxMotion < 0.001) {
                    this.myWait();
                }
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void start() {
        this.relaxer = new Thread(this);
        this.relaxer.start();
    }

    public void stop() {
        this.relaxer = null;
    }
}

