/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout;

import com.touchgraph.graphlayout.TGAbstractLens;
import com.touchgraph.graphlayout.TGPoint2D;
import java.util.Vector;

public class TGLensSet {
    Vector<TGAbstractLens> lenses = new Vector();

    public void addLens(TGAbstractLens l) {
        this.lenses.addElement(l);
    }

    public void applyLens(TGPoint2D p) {
        if (this.lenses.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.lenses.size()) {
            this.lenses.elementAt(i).applyLens(p);
            ++i;
        }
    }

    public void undoLens(TGPoint2D p) {
        if (this.lenses.isEmpty()) {
            return;
        }
        int i = this.lenses.size() - 1;
        while (i >= 0) {
            this.lenses.elementAt(i).undoLens(p);
            --i;
        }
    }

    public TGPoint2D convRealToDraw(TGPoint2D p) {
        TGPoint2D newp = new TGPoint2D(p);
        this.applyLens(newp);
        return newp;
    }

    public TGPoint2D convRealToDraw(double x, double y) {
        TGPoint2D newp = new TGPoint2D(x, y);
        this.applyLens(newp);
        return newp;
    }

    public TGPoint2D convDrawToReal(TGPoint2D p) {
        TGPoint2D newp = new TGPoint2D(p);
        this.undoLens(newp);
        return newp;
    }

    public TGPoint2D convDrawToReal(double x, double y) {
        TGPoint2D newp = new TGPoint2D(x, y);
        this.undoLens(newp);
        return newp;
    }
}

