/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.graphelements;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.graphelements.GraphEltSet;
import com.touchgraph.graphlayout.graphelements.TGNodeQueue;
import java.util.Hashtable;
import java.util.Vector;

public class GESUtils {
    public static Hashtable calculateDistances(GraphEltSet ges, Node focusNode, int radius, int maxAddEdgeCount, int maxExpandEdgeCount, boolean unidirectional) {
        Hashtable<Node, Integer> distHash = new Hashtable<Node, Integer>();
        distHash.put(focusNode, new Integer(0));
        TGNodeQueue nodeQ = new TGNodeQueue();
        nodeQ.push(focusNode);
        while (!nodeQ.isEmpty()) {
            Node n = nodeQ.pop();
            int currDist = (Integer)distHash.get(n);
            if (currDist >= radius) break;
            int i = 0;
            while (i < n.edgeCount()) {
                Edge e = n.edgeAt(i);
                if (n == n.edgeAt(i).getFrom() || !unidirectional) {
                    Node adjNode = e.getOtherEndpt(n);
                    if (ges.contains(e) && !distHash.containsKey(adjNode) && adjNode.edgeCount() <= maxAddEdgeCount) {
                        if (adjNode.edgeCount() <= maxExpandEdgeCount) {
                            nodeQ.push(adjNode);
                        }
                        distHash.put(adjNode, new Integer(currDist + 1));
                    }
                }
                ++i;
            }
        }
        return distHash;
    }

    public static Hashtable calculateDistances(GraphEltSet ges, Node focusNode, int radius) {
        return GESUtils.calculateDistances(ges, focusNode, radius, 1000, 1000, false);
    }

    public static Hashtable getLargestConnectedSubgraph(GraphEltSet ges) {
        int nodeCount = ges.nodeCount();
        if (nodeCount == 0) {
            return null;
        }
        Vector<Hashtable> subgraphVector = new Vector<Hashtable>();
        int i = 0;
        while (i < nodeCount) {
            Node n = ges.nodeAt(i);
            boolean skipNode = false;
            int j = 0;
            while (j < subgraphVector.size()) {
                if (((Hashtable)subgraphVector.elementAt(j)).contains(n)) {
                    skipNode = true;
                }
                ++j;
            }
            Hashtable subgraph = GESUtils.calculateDistances(ges, n, 1000);
            if (subgraph.size() > nodeCount / 2) {
                return subgraph;
            }
            if (!skipNode) {
                subgraphVector.addElement(subgraph);
            }
            ++i;
        }
        int maxSize = 0;
        int maxIndex = 0;
        int j = 0;
        while (j < subgraphVector.size()) {
            if (((Hashtable)subgraphVector.elementAt(j)).size() > maxSize) {
                maxSize = ((Hashtable)subgraphVector.elementAt(j)).size();
                maxIndex = j;
            }
            ++j;
        }
        return (Hashtable)subgraphVector.elementAt(maxIndex);
    }
}

