/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.graphelements;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGException;
import com.touchgraph.graphlayout.graphelements.ImmutableGraphEltSet;
import com.touchgraph.graphlayout.graphelements.TGForEachEdge;
import com.touchgraph.graphlayout.graphelements.TGForEachNode;
import com.touchgraph.graphlayout.graphelements.TGForEachNodePair;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class GraphEltSet
implements ImmutableGraphEltSet {
    protected Vector<Node> nodes = new Vector();
    protected Vector<Edge> edges = new Vector();
    protected Hashtable<String, Node> nodeIDRegistry = new Hashtable();

    protected Node nodeAt(int i) {
        if (this.nodes.size() == 0) {
            return null;
        }
        return this.nodes.elementAt(i);
    }

    @Override
    @Deprecated
    public int nodeNum() {
        return this.nodes.size();
    }

    @Override
    public int nodeCount() {
        return this.nodes.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void addNode(Node node) throws TGException {
        String id = node.getID();
        if (id != null) {
            if (this.findNode(id) != null) throw new TGException(1, "node ID '" + id + "' already exists.");
            this.nodeIDRegistry.put(id, node);
            this.nodes.addElement(node);
            return;
        } else {
            String label = node.getLabel().trim();
            if (label == null) {
                label = "";
            }
            if (!label.equals("") && this.findNode(node.getLabel()) == null) {
                id = label;
            } else {
                int i = 1;
                while (this.findNode(String.valueOf(label) + "-" + i) != null) {
                    ++i;
                }
                id = String.valueOf(label) + "-" + i;
            }
            node.setID(id);
            this.nodeIDRegistry.put(id, node);
            this.nodes.addElement(node);
        }
    }

    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    protected Edge edgeAt(int index) {
        if (this.edges.size() == 0) {
            return null;
        }
        return this.edges.elementAt(index);
    }

    @Override
    @Deprecated
    public int edgeNum() {
        return this.edges.size();
    }

    @Override
    public int edgeCount() {
        return this.edges.size();
    }

    public void addEdge(Edge edge) {
        if (edge == null) {
            return;
        }
        if (!this.contains(edge)) {
            this.edges.addElement(edge);
            edge.from.addEdge(edge);
            edge.to.addEdge(edge);
        }
    }

    public Edge addEdge(Node from, Node to, int tension) {
        Edge edge = null;
        if (from != null && to != null) {
            edge = new Edge(from, to, tension);
            this.addEdge(edge);
        }
        return edge;
    }

    public boolean contains(Edge edge) {
        return this.edges.contains(edge);
    }

    @Override
    public Node findNode(String id) {
        if (id == null) {
            return null;
        }
        return this.nodeIDRegistry.get(id);
    }

    public Node findNodeByURL(String strURL) {
        Node retVal = null;
        if (strURL == null) {
            return null;
        }
        Enumeration<Node> myEnum = this.nodeIDRegistry.elements();
        while (myEnum.hasMoreElements()) {
            Node node = myEnum.nextElement();
            if (!node.getURL().equalsIgnoreCase(strURL)) continue;
            retVal = node;
            break;
        }
        return retVal;
    }

    @Override
    public Node findNodeLabelContaining(String substring) {
        int i = 0;
        while (i < this.nodeCount()) {
            if (this.nodeAt(i) != null && this.nodeAt(i).getLabel().toLowerCase().equals(substring.toLowerCase())) {
                return this.nodeAt(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.nodeCount()) {
            if (this.nodeAt(i) != null && this.nodeAt(i).getLabel().toLowerCase().indexOf(substring.toLowerCase()) > -1) {
                return this.nodeAt(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public Edge findEdge(Node from, Node to) {
        int i = 0;
        while (i < from.edgeCount()) {
            Edge e = from.edgeAt(i);
            if (e.to == to) {
                return e;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEdge(Edge edge) {
        Vector<Edge> vector = this.edges;
        synchronized (vector) {
            block6: {
                block5: {
                    if (edge != null) break block5;
                    return false;
                }
                if (this.edges.removeElement(edge)) break block6;
                return false;
            }
            edge.from.removeEdge(edge);
            edge.to.removeEdge(edge);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteEdges(Vector<Edge> edgesToDelete) {
        Vector<Edge> vector = this.edges;
        synchronized (vector) {
            int i = 0;
            while (i < edgesToDelete.size()) {
                this.deleteEdge(edgesToDelete.elementAt(i));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteEdge(Node from, Node to) {
        Vector<Edge> vector = this.edges;
        synchronized (vector) {
            Edge e = this.findEdge(from, to);
            if (e != null) {
                return this.deleteEdge(e);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteNode(Node node) {
        Vector<Node> vector = this.nodes;
        synchronized (vector) {
            block11: {
                block10: {
                    if (node != null) break block10;
                    return false;
                }
                if (this.nodes.removeElement(node)) break block11;
                return false;
            }
            String id = node.getID();
            if (id != null) {
                this.nodeIDRegistry.remove(id);
            }
            int i = 0;
            while (i < node.edgeCount()) {
                Edge e = node.edgeAt(i);
                if (e.from == node) {
                    this.edges.removeElement(e);
                    e.to.removeEdge(e);
                } else if (e.to == node) {
                    this.edges.removeElement(e);
                    e.from.removeEdge(e);
                }
                ++i;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNodes(Vector<Node> nodesToDelete) {
        Vector<Node> vector = this.nodes;
        synchronized (vector) {
            int i = 0;
            while (i < nodesToDelete.size()) {
                this.deleteNode(nodesToDelete.elementAt(i));
                ++i;
            }
        }
    }

    @Override
    public Node getRandomNode() {
        if (this.nodes.size() == 0) {
            return null;
        }
        int r = (int)(Math.random() * (double)this.nodeCount());
        return this.nodeAt(r);
    }

    @Override
    public Node getFirstNode() {
        if (this.nodes.size() == 0) {
            return null;
        }
        return this.nodeAt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Vector<Node> vector = this.nodes;
        synchronized (vector) {
            Vector<Edge> vector2 = this.edges;
            synchronized (vector2) {
                this.nodes.removeAllElements();
                this.edges.removeAllElements();
                this.nodeIDRegistry.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forAllNodes(TGForEachNode fen) {
        Vector<Node> vector = this.nodes;
        synchronized (vector) {
            int i = 0;
            while (i < this.nodeCount()) {
                Node n = this.nodeAt(i);
                fen.forEachNode(n);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forAllNodePairs(TGForEachNodePair fenp) {
        Vector<Node> vector = this.nodes;
        synchronized (vector) {
            int i = 0;
            while (i < this.nodeCount()) {
                Node n1 = this.nodeAt(i);
                fenp.beforeInnerLoop(n1);
                int j = i + 1;
                while (j < this.nodeCount()) {
                    fenp.forEachNodePair(n1, this.nodeAt(j));
                    ++j;
                }
                fenp.afterInnerLoop(n1);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forAllEdges(TGForEachEdge fee) {
        Vector<Edge> vector = this.edges;
        synchronized (vector) {
            int i = 0;
            while (i < this.edgeCount()) {
                Edge e = this.edgeAt(i);
                fee.forEachEdge(e);
                ++i;
            }
        }
    }
}

