/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.TGPaintListener;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.TGPoint2D;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class DragMultiselectUI
extends TGAbstractDragUI
implements TGPaintListener {
    TGPoint2D mousePos = null;
    TGPoint2D startPos = null;

    DragMultiselectUI(TGPanel tgp) {
        super(tgp);
    }

    @Override
    public void preActivate() {
        this.startPos = null;
        this.mousePos = null;
        this.tgPanel.addPaintListener(this);
    }

    @Override
    public void preDeactivate() {
        this.tgPanel.removePaintListener(this);
        this.tgPanel.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.startPos = new TGPoint2D(e.getX(), e.getY());
        this.mousePos = new TGPoint2D(this.startPos);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mousePos.setLocation(e.getX(), e.getY());
        this.tgPanel.multiSelect(this.startPos, this.mousePos);
        this.tgPanel.repaint();
    }

    @Override
    public void paintFirst(Graphics g) {
    }

    @Override
    public void paintAfterEdges(Graphics g) {
    }

    @Override
    public void paintLast(Graphics g) {
        int h;
        int y;
        int w;
        int x;
        if (this.mousePos == null) {
            return;
        }
        g.setColor(Color.black);
        if (this.startPos.x < this.mousePos.x) {
            x = (int)this.startPos.x;
            w = (int)(this.mousePos.x - this.startPos.x);
        } else {
            x = (int)this.mousePos.x;
            w = (int)(this.startPos.x - this.mousePos.x);
        }
        if (this.startPos.y < this.mousePos.y) {
            y = (int)this.startPos.y;
            h = (int)(this.mousePos.y - this.startPos.y);
        } else {
            y = (int)this.mousePos.y;
            h = (int)(this.startPos.y - this.mousePos.y);
        }
        int horiz = x;
        while (horiz < x + w) {
            g.drawLine(horiz, y, horiz, y);
            g.drawLine(horiz, y + h, horiz, y + h);
            horiz += 2;
        }
        int vert = y;
        while (vert < y + h) {
            g.drawLine(x, vert, x, vert);
            g.drawLine(x + w, vert, x + w, vert);
            vert += 2;
        }
    }
}

