/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.GLPanel;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.DragNodeUI;
import com.touchgraph.graphlayout.interaction.LocalityScroll;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import com.touchgraph.graphlayout.interaction.TGUserInterface;
import dummy.name.utils.ReducedMemVTM;
import java.awt.Color;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class GLNavigateUI
extends TGUserInterface {
    public static boolean okOption = false;
    GLPanel glPanel;
    TGPanel tgPanel;
    boolean rightClick = false;
    GLNavigateMouseListener ml;
    int result;
    ReducedMemVTM vtm;
    TGAbstractDragUI hvDragUI;
    DragNodeUI dragNodeUI;
    LocalityScroll localityScroll;
    PopupMenu nodePopup;
    PopupMenu edgePopup;
    Node popupNode;
    Edge popupEdge;

    public GLNavigateUI(GLPanel glp) {
        this.glPanel = glp;
        this.tgPanel = this.glPanel.getTGPanel();
        this.localityScroll = this.glPanel.getLocalityScroll();
        this.hvDragUI = this.glPanel.getHVScroll().getHVDragUI();
        this.dragNodeUI = new DragNodeUI(this.tgPanel);
        this.ml = new GLNavigateMouseListener();
        this.setUpNodePopup(glp);
        this.setUpEdgePopup(glp);
    }

    @Override
    public void activate() {
        this.tgPanel.addMouseListener(this.ml);
    }

    @Override
    public void deactivate() {
        this.tgPanel.removeMouseListener(this.ml);
    }

    private void setUpNodePopup(GLPanel glp) {
        this.nodePopup = new PopupMenu();
        glp.add(this.nodePopup);
        MenuItem menuItem = new MenuItem("Expand Node");
        ActionListener expandAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.tgPanel.expandNode(GLNavigateUI.this.popupNode);
                    System.out.println("exp");
                }
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
                if (!GLPanel.searchResult.equals("search box") && GLPanel.searchResult.trim().length() > 0) {
                    try {
                        Thread.sleep(300L);
                        GLNavigateUI.this.glPanel.searchFilter();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        menuItem.addActionListener(expandAction);
        this.nodePopup.add(menuItem);
        menuItem = new MenuItem("Collapse Node");
        ActionListener collapseAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.tgPanel.collapseNode(GLNavigateUI.this.popupNode);
                }
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(collapseAction);
        this.nodePopup.add(menuItem);
        menuItem = new MenuItem("Hide Node");
        ActionListener hideAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.tgPanel.hideNode(GLNavigateUI.this.popupNode);
                }
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(hideAction);
        this.nodePopup.add(menuItem);
        menuItem = new MenuItem("Center Node");
        ActionListener centerAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.glPanel.getHVScroll().slowScrollToCenter(GLNavigateUI.this.popupNode);
                }
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(centerAction);
        this.nodePopup.add(menuItem);
        menuItem = new MenuItem("Show Edges");
        ActionListener edgesAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLNavigateUI.this.popupNode != null) {
                    int i = 0;
                    while (i < GLNavigateUI.this.popupNode.edgeCount()) {
                        Edge edges = GLNavigateUI.this.popupNode.edgeAt(i);
                        edges.setColor(Color.green);
                        Node nFrom = GLNavigateUI.this.tgPanel.findNode(edges.from.getID());
                        Node nTo = GLNavigateUI.this.tgPanel.findNode(edges.to.getID());
                        if (GLNavigateUI.this.popupNode == nFrom) {
                            System.err.println(String.valueOf(nTo.getID()) + "\t" + nTo.drawx + "\t" + nTo.drawy);
                        } else {
                            System.err.println(String.valueOf(nFrom.getID()) + "\t" + nFrom.drawx + "\t" + nFrom.drawy);
                        }
                        nTo.BORDER_INACTIVE_COLOR = Color.green;
                        nFrom.BORDER_INACTIVE_COLOR = Color.green;
                        nTo.setTextColor(Color.ORANGE);
                        nFrom.setTextColor(Color.ORANGE);
                        GLNavigateUI.this.popupNode.BORDER_INACTIVE_COLOR = Color.ORANGE;
                        GLNavigateUI.this.popupNode.setTextColor(Color.ORANGE);
                        if (GLNavigateUI.this.popupNode.getType() == 3) {
                            GLNavigateUI.this.popupNode.setType(2);
                        }
                        ++i;
                    }
                }
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(edgesAction);
        this.nodePopup.add(menuItem);
        menuItem = new MenuItem("Hide Edges");
        ActionListener edgesHAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLNavigateUI.this.popupNode != null) {
                    int i = 0;
                    while (i < GLNavigateUI.this.popupNode.edgeCount()) {
                        GLNavigateUI.this.popupNode.BORDER_INACTIVE_COLOR = new Color(30, 50, 160);
                        Edge edges = GLNavigateUI.this.popupNode.edgeAt(i);
                        edges.setColor(GLPanel.defaultBackColor);
                        Node nFrom = GLNavigateUI.this.tgPanel.findNode(edges.from.getID());
                        Node nTo = GLNavigateUI.this.tgPanel.findNode(edges.to.getID());
                        nTo.BORDER_INACTIVE_COLOR = new Color(30, 50, 160);
                        nFrom.BORDER_INACTIVE_COLOR = new Color(30, 50, 160);
                        nTo.setTextColor(GLPanel.defaultBackColor);
                        nFrom.setTextColor(GLPanel.defaultBackColor);
                        GLNavigateUI.this.popupNode.setTextColor(GLPanel.defaultBackColor);
                        if (GLPanel.edgesColorItem.isSelected()) {
                            edges.setColor(GLPanel.defaultBackColor);
                        }
                        if (GLNavigateUI.this.popupNode.getType() == 2) {
                            GLNavigateUI.this.popupNode.setType(3);
                        }
                        ++i;
                    }
                }
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(edgesHAction);
        this.nodePopup.add(menuItem);
    }

    private void setUpEdgePopup(GLPanel glp) {
        this.edgePopup = new PopupMenu();
        glp.add(this.edgePopup);
        MenuItem menuItem = new MenuItem("Hide Edge");
        ActionListener hideAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GLNavigateUI.this.popupEdge != null) {
                    GLNavigateUI.this.tgPanel.hideEdge(GLNavigateUI.this.popupEdge);
                }
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                GLNavigateUI.this.tgPanel.setMouseOverN(null);
                GLNavigateUI.this.tgPanel.repaint();
            }
        };
        menuItem.addActionListener(hideAction);
        this.edgePopup.add(menuItem);
    }

    class GLNavigateMouseListener
    extends MouseAdapter {
        GLNavigateMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Node mouseOverN = GLNavigateUI.this.tgPanel.getMouseOverN();
            if (e.isPopupTrigger()) {
                GLNavigateUI.this.popupNode = GLNavigateUI.this.tgPanel.getMouseOverN();
                GLNavigateUI.this.popupEdge = GLNavigateUI.this.tgPanel.getMouseOverE();
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.tgPanel.setMaintainMouseOver(true);
                    GLNavigateUI.this.nodePopup.show(GLNavigateUI.this.tgPanel, e.getX(), e.getY());
                } else if (GLNavigateUI.this.popupEdge != null) {
                    GLNavigateUI.this.tgPanel.setMaintainMouseOver(true);
                    GLNavigateUI.this.edgePopup.show(GLNavigateUI.this.tgPanel, e.getX(), e.getY());
                } else {
                    GLNavigateUI.this.glPanel.glPopup.show(GLNavigateUI.this.tgPanel, e.getX(), e.getY());
                }
            } else if (e.getModifiers() == 16) {
                if (mouseOverN == null) {
                    GLNavigateUI.this.hvDragUI.activate(e);
                } else {
                    GLNavigateUI.this.dragNodeUI.activate(e);
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Node mouseOverN;
            Node lastmouseOverN = mouseOverN = GLNavigateUI.this.tgPanel.getMouseOverN();
            if (mouseOverN != null && SwingUtilities.isLeftMouseButton(e) && GLNavigateUI.this.tgPanel.mouseOverN.getType() != 1) {
                JOptionPane.showMessageDialog(GLNavigateUI.this.tgPanel, mouseOverN.getLabel(), mouseOverN.getID(), -1);
            }
            if (GLNavigateUI.this.tgPanel.mouseOverN != null && SwingUtilities.isLeftMouseButton(e) && GLNavigateUI.this.tgPanel.mouseOverN.getType() == 1) {
                GLNavigateUI.this.result = JOptionPane.showConfirmDialog(GLNavigateUI.this.tgPanel, GLNavigateUI.this.tgPanel.mouseOverN.getLabel(), String.valueOf(GLNavigateUI.this.tgPanel.mouseOverN.getID()) + " - Expand this Community?", 0);
                okOption = GLNavigateUI.this.result == 0;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                GLNavigateUI.this.popupNode = GLNavigateUI.this.tgPanel.getMouseOverN();
                GLNavigateUI.this.popupEdge = GLNavigateUI.this.tgPanel.getMouseOverE();
                if (GLNavigateUI.this.popupNode != null) {
                    GLNavigateUI.this.tgPanel.setMaintainMouseOver(true);
                    GLNavigateUI.this.nodePopup.show(GLNavigateUI.this.tgPanel, e.getX(), e.getY());
                } else if (GLNavigateUI.this.popupEdge != null) {
                    GLNavigateUI.this.tgPanel.setMaintainMouseOver(true);
                    GLNavigateUI.this.edgePopup.show(GLNavigateUI.this.tgPanel, e.getX(), e.getY());
                } else {
                    GLNavigateUI.this.glPanel.glPopup.show(GLNavigateUI.this.tgPanel, e.getX(), e.getY());
                }
            } else {
                GLNavigateUI.this.tgPanel.setMaintainMouseOver(false);
            }
        }
    }
}

