/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPaintListener;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.TGPoint2D;
import com.touchgraph.graphlayout.interaction.HVScroll;
import com.touchgraph.graphlayout.interaction.RotateScroll;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

public class HVRotateDragUI
extends TGAbstractDragUI
implements TGPaintListener {
    HVScroll hvScroll;
    RotateScroll rotateScroll;
    Node mouseOverN;
    Node tempNode;
    TGPoint2D lastMousePos;
    double lastAngle;

    public HVRotateDragUI(TGPanel tgp, HVScroll hvs, RotateScroll rs) {
        super(tgp);
        this.hvScroll = hvs;
        this.rotateScroll = rs;
    }

    double graphDist(double x, double y) {
        double adjx = x - this.tgPanel.getDrawCenter().x;
        double adjy = y - this.tgPanel.getDrawCenter().y;
        return Math.sqrt(adjx * adjx + adjy * adjy);
    }

    double getMouseAngle(double x, double y) {
        double adjx = x - this.tgPanel.getDrawCenter().x;
        double adjy = y - this.tgPanel.getDrawCenter().y;
        double ang = Math.atan(adjy / adjx);
        if (adjx == 0.0) {
            ang = adjy > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        if (adjx < 0.0) {
            ang += Math.PI;
        }
        return ang;
    }

    @Override
    public void preActivate() {
        this.tgPanel.addPaintListener(this);
    }

    @Override
    public void preDeactivate() {
        this.tgPanel.removePaintListener(this);
        this.tgPanel.repaint();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouseOverN = this.tgPanel.getMouseOverN();
        if (this.mouseOverN != null) {
            this.lastMousePos = new TGPoint2D(this.mouseOverN.drawx, this.mouseOverN.drawy);
            this.lastAngle = this.getMouseAngle(this.mouseOverN.drawx, this.mouseOverN.drawy);
        } else {
            this.tempNode = new Node();
            this.tempNode.drawx = e.getX();
            this.tempNode.drawy = e.getY();
            this.tgPanel.updatePosFromDraw(this.tempNode);
            this.lastMousePos = new TGPoint2D(this.tempNode.drawx, this.tempNode.drawy);
            this.lastAngle = this.getMouseAngle(this.tempNode.drawx, this.tempNode.drawy);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double currX = e.getX();
        double currY = e.getY();
        double currDist = this.graphDist(currX, currY);
        this.lastAngle = this.mouseOverN != null ? this.getMouseAngle(this.mouseOverN.drawx, this.mouseOverN.drawy) : this.getMouseAngle(this.tempNode.drawx, this.tempNode.drawy);
        double currentAngle = this.getMouseAngle(currX, currY);
        if (this.lastAngle > currentAngle + Math.PI) {
            currentAngle += Math.PI * 2;
        } else if (currentAngle > this.lastAngle + Math.PI) {
            this.lastAngle += Math.PI * 2;
        }
        if (currDist > 60.0) {
            this.rotateScroll.incrementRotateAngle(currentAngle - this.lastAngle);
        }
        this.tgPanel.updateDrawPositions();
        this.tgPanel.updateGraphSize();
        if (this.tempNode != null) {
            this.tgPanel.updateDrawPos(this.tempNode);
        }
        TGPoint2D lastMousePos = this.mouseOverN != null ? new TGPoint2D(this.mouseOverN.drawx, this.mouseOverN.drawy) : new TGPoint2D(this.tempNode.drawx, this.tempNode.drawy);
        TGPoint2D newPos = new TGPoint2D(currX, currY);
        if (!this.hvScroll.scrolling) {
            this.hvScroll.scrollAtoB(lastMousePos, newPos);
        }
        this.tgPanel.repaintAfterMove();
        if (this.tempNode != null) {
            this.tgPanel.updateDrawPos(this.tempNode);
        }
    }

    @Override
    public void paintFirst(Graphics g) {
        TGPoint2D drawCenter = this.tgPanel.getDrawCenter();
        g.setColor(Color.lightGray);
        int i = 0;
        while (i < 16) {
            double ang = Math.PI * 2 * (double)i / 16.0;
            double rayX = 1000.0 * Math.cos(ang);
            double rayY = 1000.0 * Math.sin(ang);
            g.drawLine((int)drawCenter.x, (int)drawCenter.y, (int)(rayX + drawCenter.x), (int)(rayY + drawCenter.y));
            g.drawLine((int)drawCenter.x + 1, (int)drawCenter.y, (int)(rayX + drawCenter.x + 1.0), (int)(rayY + drawCenter.y));
            g.drawLine((int)drawCenter.x, (int)drawCenter.y + 1, (int)(rayX + drawCenter.x), (int)(rayY + drawCenter.y + 1.0));
            g.drawLine((int)drawCenter.x + 1, (int)drawCenter.y + 1, (int)(rayX + drawCenter.x + 1.0), (int)(rayY + drawCenter.y + 1.0));
            ++i;
        }
        g.fillOval((int)drawCenter.x - 60, (int)drawCenter.y - 60, 120, 120);
        g.setColor(TGPanel.BACK_COLOR);
        g.fillOval((int)drawCenter.x - 58, (int)drawCenter.y - 58, 116, 116);
    }

    @Override
    public void paintLast(Graphics g) {
    }

    @Override
    public void paintAfterEdges(Graphics g) {
    }
}

