/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.GraphListener;
import com.touchgraph.graphlayout.TGAbstractLens;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.TGPoint2D;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;

public class HyperScroll
implements GraphListener {
    private JScrollBar scroll;
    private TGPanel tgPanel;
    HyperLens hyperLens;
    double[] inverseArray = new double[200];
    double width;

    public HyperScroll(TGPanel tgp) {
        this.scroll = new JScrollBar(0, 100, 20, -20, 250);
        this.scroll.addAdjustmentListener(new hyperAdjustmentListener());
        this.tgPanel = tgp;
        this.hyperLens = new HyperLens();
        this.width = 2000.0;
        this.updateInverseArray();
        this.tgPanel.addGraphListener(this);
    }

    public HyperLens getLens() {
        return this.hyperLens;
    }

    public JScrollBar getHyperSB() {
        return this.scroll;
    }

    @Override
    public void graphMoved() {
    }

    @Override
    public void graphReset() {
        this.scroll.setValue(0);
    }

    double rawHyperDist(double dist) {
        if (this.scroll.getValue() == 0) {
            return dist;
        }
        double hyperV = this.scroll.getValue();
        return Math.log(dist / (Math.pow(1.5, (70.0 - hyperV) / 40.0) * 80.0) + 1.0);
    }

    double hyperDist(double dist) {
        double hyperV = this.scroll.getValue();
        double hyperD = this.rawHyperDist(dist) / this.rawHyperDist(250.0) * 250.0;
        double fade = hyperV;
        double fadeAdjust = 100.0;
        hyperD = hyperD * fade / fadeAdjust + dist * (fadeAdjust - fade) / fadeAdjust;
        return hyperD;
    }

    void updateInverseArray() {
        int i = 0;
        while (i < 200) {
            double x = this.width * (double)i / 200.0;
            this.inverseArray[i] = this.hyperDist(x);
            ++i;
        }
    }

    int findInd(int min, int max, double dist) {
        int mid = (min + max) / 2;
        if (this.inverseArray[mid] < dist) {
            if (max - mid == 1) {
                return max;
            }
            return this.findInd(mid, max, dist);
        }
        if (mid - min == 1) {
            return mid;
        }
        return this.findInd(min, mid, dist);
    }

    double invHyperDist(double dist) {
        if (dist == 0.0) {
            return 0.0;
        }
        int i = this.inverseArray[199] < dist ? 199 : this.findInd(0, 199, dist);
        double x2 = this.inverseArray[i];
        double x1 = this.inverseArray[i - 1];
        double j = (dist - x1) / (x2 - x1);
        return ((double)i + j - 1.0) / 200.0 * this.width;
    }

    class HyperLens
    extends TGAbstractLens {
        HyperLens() {
        }

        @Override
        protected void applyLens(TGPoint2D p) {
            double dist = Math.sqrt(p.x * p.x + p.y * p.y);
            if (dist > 0.0) {
                p.x = p.x / dist * HyperScroll.this.hyperDist(dist);
                p.y = p.y / dist * HyperScroll.this.hyperDist(dist);
            } else {
                p.x = 0.0;
                p.y = 0.0;
            }
        }

        @Override
        protected void undoLens(TGPoint2D p) {
            double dist = Math.sqrt(p.x * p.x + p.y * p.y);
            if (dist > 0.0) {
                p.x = p.x / dist * HyperScroll.this.invHyperDist(dist);
                p.y = p.y / dist * HyperScroll.this.invHyperDist(dist);
            } else {
                p.x = 0.0;
                p.y = 0.0;
            }
        }
    }

    private class hyperAdjustmentListener
    implements AdjustmentListener {
        private hyperAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            HyperScroll.this.updateInverseArray();
            HyperScroll.this.tgPanel.repaintAfterMove();
        }
    }
}

