/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.TGPanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class MouseDragSelect
extends JFrame
implements MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 1L;
    private final JLabel mousePosition;
    int x1;
    int x2;
    int y1;
    int y2;
    int x;
    int y;
    int w;
    int h;
    private final JLabel recStart;
    private final JLabel recStop;
    private final JLabel cords;
    boolean isNewRect = true;
    private TGPanel tgPanel;

    public MouseDragSelect(TGPanel tgp) {
        this.tgPanel = tgp;
        this.mousePosition = new JLabel();
        this.mousePosition.setHorizontalAlignment(0);
        this.tgPanel.add((Component)this.mousePosition, "Center");
        JLabel text1 = new JLabel();
        text1.setText("At the center the mouse pointer's coordinates will be displayed.");
        this.tgPanel.add((Component)text1, "South");
        this.recStart = new JLabel();
        this.tgPanel.add((Component)this.recStart, "West");
        this.recStop = new JLabel();
        this.tgPanel.add((Component)this.recStop, "East");
        this.cords = new JLabel();
        this.tgPanel.add((Component)this.cords, "North");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.mousePosition.setText("Clicked at [" + event.getX() + ", " + event.getY() + "]");
        this.repaint();
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.x1 = event.getX();
        this.y1 = event.getY();
        this.mousePosition.setText("Pressed at [" + this.x1 + ", " + this.y1 + "]");
        this.recStart.setText("Start:  [" + this.x1 + ", " + this.y1 + "]");
        this.isNewRect = true;
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.x2 = event.getX();
        this.y2 = event.getY();
        this.mousePosition.setText("Released at [" + this.x2 + ", " + this.y2 + "]");
        this.recStop.setText("End:  [" + this.x2 + ", " + this.y2 + "]");
        this.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent event) {
        this.mousePosition.setText("Mouse entered at [" + event.getX() + ", " + event.getY() + "]");
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent event) {
        this.mousePosition.setText("Mouse outside window");
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.x2 = event.getX();
        this.y2 = event.getY();
        this.mousePosition.setText("Dragged at [" + this.x2 + ", " + this.y2 + "]");
        this.isNewRect = false;
        this.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        this.mousePosition.setText("Moved at [" + event.getX() + ", " + event.getY() + "]");
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.drawString("Start Rec Here", this.x1, this.y1);
        g.drawString("End Rec Here", this.x2, this.y2);
        int width = this.x1 - this.x2;
        int height = this.y1 - this.y2;
        this.w = Math.abs(width);
        this.h = Math.abs(height);
        this.x = width < 0 ? this.x1 : this.x2;
        int n = this.y = height < 0 ? this.y1 : this.y2;
        if (!this.isNewRect) {
            g.drawRect(this.x, this.y, this.w, this.h);
        }
        this.cords.setText("w = " + this.w + ", h = " + this.h);
    }
}

