/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.Edge;
import com.touchgraph.graphlayout.GLPanel;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.graphelements.TGForEachEdge;
import dummy.name.utils.ReducedMemVTM;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.GeneralPath;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JOptionPane;

public class MouseDraw
implements MouseListener,
KeyListener,
MouseMotionListener {
    public static final long serialVersionUID = 3364927240430265634L;
    public static boolean drawing = false;
    public static GeneralPath path = null;
    public TGPanel tgPanel;
    public GLPanel glPanel;
    private boolean first = true;
    public int firstx = 0;
    public int firsty = 0;
    public boolean expanding = false;
    public int[] selectedCommIds = null;
    public boolean yesOption = false;
    private ReducedMemVTM vtm;
    protected String id = "empty";

    public MouseDraw(TGPanel tgp, ReducedMemVTM rvtm) {
        this.vtm = rvtm;
        this.tgPanel = tgp;
        this.tgPanel.addMouseListener(this);
        this.tgPanel.addKeyListener(this);
        this.tgPanel.addMouseMotionListener(this);
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (path != null) {
            TGForEachEdge fee = new TGForEachEdge(){

                @Override
                public void forEachEdge(Edge edge) {
                    if (GLPanel.edgeColoring && GLPanel.edgesColorItem.isSelected()) {
                        edge.col = Edge.DEFAULT_COLOR;
                    }
                }
            };
            this.tgPanel.visibleLocality.forAllEdges(fee);
        }
        Point p = me.getPoint();
        if (!drawing && me.isControlDown()) {
            path = new GeneralPath();
            path.moveTo(p.x, p.y);
            this.firstx = p.x;
            this.firsty = p.y;
            drawing = true;
        } else {
            if (this.first && me.isControlDown()) {
                path.lineTo(p.x, p.y);
                this.tgPanel.repaint();
                this.first = false;
            }
            if (me.isControlDown()) {
                path.lineTo(p.x, p.y);
                if (Math.abs(p.x - this.firstx) >= 0 && Math.abs(p.x - this.firstx) <= 10 && Math.abs(p.y - this.firsty) >= 0 && Math.abs(p.y - this.firsty) <= 10) {
                    drawing = false;
                    this.yesOption = false;
                    int[] selectedIds = this.determineSelectedIds();
                    System.err.println(String.valueOf(Arrays.toString(selectedIds)) + "\t" + selectedIds.length + " documents");
                    StringBuffer sb = new StringBuffer();
                    String[] vtmPhrases = new String[5];
                    if (selectedIds.length == 0) {
                        sb.append("No document was selected.");
                    } else {
                        this.vtm.getTopKeyphrases(vtmPhrases, selectedIds);
                        String[] stringArray = vtmPhrases;
                        int n = vtmPhrases.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String vtmPhrase = stringArray[n2];
                            sb.append(String.valueOf(vtmPhrase.split("\t")[0]) + "\n");
                            ++n2;
                        }
                    }
                    this.selectedCommIds = this.determineSelectedCommIds();
                    if (this.selectedCommIds.length > 0) {
                        int result = JOptionPane.showConfirmDialog(this.tgPanel, sb.toString().trim(), "Expand: " + Arrays.toString(this.selectedCommIds) + " communities ?", 0);
                        if (result == 0) {
                            this.yesOption = true;
                            this.expanding = true;
                        }
                    } else {
                        this.expanding = false;
                        this.yesOption = false;
                        JOptionPane.showMessageDialog(this.tgPanel, sb.toString().trim(), Arrays.toString(selectedIds), -1);
                    }
                    path.closePath();
                    drawing = false;
                    path = null;
                    int i = 0;
                    while (i < this.tgPanel.getNodeCount()) {
                        Node n = this.tgPanel.findNode(Integer.toString(i));
                        if (n.BORDER_INACTIVE_COLOR == Color.red) {
                            n.BORDER_INACTIVE_COLOR = new Color(30, 50, 160);
                        }
                        ++i;
                    }
                    this.first = false;
                }
            }
        }
        this.tgPanel.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
    }

    private int[] determineSelectedIds() {
        HashSet<Integer> selection = new HashSet<Integer>();
        int numOfDocs = this.tgPanel.getNodeCount();
        int i = 0;
        while (i < numOfDocs) {
            Node n = this.tgPanel.findNode(Integer.toString(i));
            if (n != null && n.isVisible() && path.contains(n.drawx, n.drawy)) {
                if (n.getType() == 1) {
                    for (Integer communityDocIds : this.vtm.getDocsToCommunities().get(i - this.vtm.getTotalDocumentSize())) {
                        selection.add(communityDocIds);
                    }
                } else {
                    selection.add(Integer.parseInt(n.getID()));
                }
            }
            ++i;
        }
        int index = 0;
        int[] selectedIds = new int[selection.size()];
        for (Integer i2 : selection) {
            selectedIds[index++] = i2;
        }
        return selectedIds;
    }

    public int[] determineSelectedCommIds() {
        HashSet<Integer> selection = new HashSet<Integer>();
        int numOfDocs = this.tgPanel.getNodeCount();
        int i = 0;
        while (i < numOfDocs) {
            Node n = this.tgPanel.findNode(Integer.toString(i));
            if (n != null && n.isVisible() && path.contains(n.drawx, n.drawy) && n.getType() == 1) {
                selection.add(Integer.parseInt(n.getID()) - this.vtm.getTotalDocumentSize());
            }
            ++i;
        }
        int index = 0;
        int[] selectedIds = new int[selection.size()];
        for (Integer i2 : selection) {
            selectedIds[index++] = i2;
        }
        return selectedIds;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (path == null && GLPanel.edgesColorItem.isSelected() && !this.first) {
            TGForEachEdge fee = new TGForEachEdge(){

                @Override
                public void forEachEdge(Edge edge) {
                    edge.col = Color.lightGray;
                }
            };
            this.tgPanel.visibleLocality.forAllEdges(fee);
        }
    }
}

