/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.GraphListener;
import com.touchgraph.graphlayout.TGAbstractLens;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.TGPoint2D;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;

public class RotateScroll
implements GraphListener {
    private Scrollbar scroll = new Scrollbar(0, 0, 80, -314, 318);
    RotateLens rotateLens;
    double rotateAngle;
    RotateDragUI rotateDragUI;
    boolean adjustmentIsInternal;
    private TGPanel tgPanel;

    public RotateScroll(TGPanel tgp) {
        this.scroll.addAdjustmentListener(new rotateAdjustmentListener());
        this.tgPanel = tgp;
        this.rotateAngle = 0.0;
        this.rotateLens = new RotateLens();
        this.rotateDragUI = new RotateDragUI();
        this.adjustmentIsInternal = false;
        this.tgPanel.addGraphListener(this);
    }

    public RotateLens getLens() {
        return this.rotateLens;
    }

    public RotateDragUI getRotateDragUI() {
        return this.rotateDragUI;
    }

    public int getRotationAngle() {
        double orientedValue = this.scroll.getValue() - this.scroll.getMinimum();
        double range = this.scroll.getMaximum() - this.scroll.getMinimum() - this.scroll.getVisibleAmount();
        return (int)(orientedValue / range * 359.0);
    }

    public void setRotationAngle(int angle) {
        double range = this.scroll.getMaximum() - this.scroll.getMinimum() - this.scroll.getVisibleAmount();
        this.scroll.setValue((int)((double)angle / 359.0 * range + 0.5) + this.scroll.getMinimum());
    }

    public Scrollbar getRotateSB() {
        return this.scroll;
    }

    @Override
    public void graphMoved() {
    }

    @Override
    public void graphReset() {
        this.rotateAngle = 0.0;
        this.scroll.setValue(0);
    }

    double computeAngle(double x, double y) {
        double angle = Math.atan(y / x);
        if (x == 0.0) {
            angle = y > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        if (x < 0.0) {
            angle += Math.PI;
        }
        return angle;
    }

    public void incrementRotateAngle(double inc) {
        this.rotateAngle += inc;
        if (this.rotateAngle > Math.PI) {
            this.rotateAngle -= Math.PI * 2;
        }
        if (this.rotateAngle < -Math.PI) {
            this.rotateAngle += Math.PI * 2;
        }
        this.adjustmentIsInternal = true;
        this.scroll.setValue((int)(this.rotateAngle * 100.0));
        this.adjustmentIsInternal = false;
    }

    class RotateDragUI
    extends TGAbstractDragUI {
        double lastAngle;

        RotateDragUI() {
            super(RotateScroll.this.tgPanel);
        }

        double getMouseAngle(double x, double y) {
            return RotateScroll.this.computeAngle(x - this.tgPanel.getDrawCenter().x, y - this.tgPanel.getDrawCenter().y);
        }

        @Override
        public void preActivate() {
        }

        @Override
        public void preDeactivate() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.lastAngle = this.getMouseAngle(e.getX(), e.getY());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            double currentAngle = this.getMouseAngle(e.getX(), e.getY());
            RotateScroll.this.incrementRotateAngle(currentAngle - this.lastAngle);
            this.lastAngle = currentAngle;
            this.tgPanel.repaintAfterMove();
        }
    }

    class RotateLens
    extends TGAbstractLens {
        RotateLens() {
        }

        @Override
        protected void applyLens(TGPoint2D p) {
            double currentAngle = RotateScroll.this.computeAngle(p.x, p.y);
            double dist = Math.sqrt(p.x * p.x + p.y * p.y);
            p.x = dist * Math.cos(currentAngle + RotateScroll.this.rotateAngle);
            p.y = dist * Math.sin(currentAngle + RotateScroll.this.rotateAngle);
        }

        @Override
        protected void undoLens(TGPoint2D p) {
            double currentAngle = RotateScroll.this.computeAngle(p.x, p.y);
            double dist = Math.sqrt(p.x * p.x + p.y * p.y);
            p.x = dist * Math.cos(currentAngle - RotateScroll.this.rotateAngle);
            p.y = dist * Math.sin(currentAngle - RotateScroll.this.rotateAngle);
        }
    }

    private class rotateAdjustmentListener
    implements AdjustmentListener {
        private rotateAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (!RotateScroll.this.adjustmentIsInternal) {
                RotateScroll.this.rotateAngle = (double)RotateScroll.this.scroll.getValue() / 100.0;
                RotateScroll.this.tgPanel.repaintAfterMove();
            }
        }
    }
}

