/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.graphlayout.interaction;

import com.touchgraph.graphlayout.GraphListener;
import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGAbstractLens;
import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.TGPoint2D;
import com.touchgraph.graphlayout.graphelements.TGForEachNode;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;

public class ZoomScroll
implements GraphListener {
    protected ZoomLens zoomLens;
    private JScrollBar zoomSB;
    private TGPanel tgPanel;
    public static boolean zoomWheel = false;
    public int actualZoom = -10;

    public ZoomScroll(TGPanel tgp) {
        TGForEachNode fen = new TGForEachNode(){

            @Override
            public void forEachNode(Node node) {
                double x = node.drawx;
                double y = node.drawy;
                if (x > node.drawx) {
                    double maxX = x;
                    System.out.println(maxX);
                }
            }
        };
        this.tgPanel = tgp;
        this.zoomSB = new JScrollBar(0, this.actualZoom, 7, -50, 30);
        this.zoomSB.addAdjustmentListener(new zoomAdjustmentListener());
        this.zoomLens = new ZoomLens();
        this.tgPanel.addGraphListener(this);
    }

    public JScrollBar getZoomSB() {
        return this.zoomSB;
    }

    public ZoomLens getLens() {
        return this.zoomLens;
    }

    @Override
    public void graphMoved() {
    }

    @Override
    public void graphReset() {
        this.zoomSB.setValue(-10);
    }

    public int getZoomValue() {
        double orientedValue = this.zoomSB.getValue() - this.zoomSB.getMinimum();
        double range = this.zoomSB.getMaximum() - this.zoomSB.getMinimum() - this.zoomSB.getVisibleAmount();
        return (int)(orientedValue / range * 200.0 - 100.0);
    }

    public void setZoomValue(int value) {
        double range = this.zoomSB.getMaximum() - this.zoomSB.getMinimum() - this.zoomSB.getVisibleAmount();
        this.zoomSB.setValue((int)((double)(value + 100) / 200.0 * range + 0.5) + this.zoomSB.getMinimum());
    }

    class ZoomLens
    extends TGAbstractLens {
        ZoomLens() {
        }

        @Override
        protected void applyLens(TGPoint2D p) {
            double maxx = 0.0;
            double maxy = 0.0;
            double i = 0.0;
            while (i <= p.x) {
                double j = 0.0;
                while (j <= p.y) {
                    if (i > maxx) {
                        maxx = i;
                    }
                    if (j > maxy) {
                        maxy = j;
                    }
                    j += 1.0;
                }
                i += 1.0;
            }
            p.x *= Math.pow(2.0, (double)ZoomScroll.this.zoomSB.getValue() / 10.0);
            p.y *= Math.pow(2.0, (double)ZoomScroll.this.zoomSB.getValue() / 10.0);
        }

        @Override
        protected void undoLens(TGPoint2D p) {
            p.x /= Math.pow(2.0, (double)ZoomScroll.this.zoomSB.getValue() / 10.0);
            p.y /= Math.pow(2.0, (double)ZoomScroll.this.zoomSB.getValue() / 10.0);
        }
    }

    private class zoomAdjustmentListener
    implements AdjustmentListener {
        private zoomAdjustmentListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent e) {
            if (ZoomScroll.this.getZoomValue() > 10) {
                zoomWheel = true;
            }
            ZoomScroll.this.tgPanel.repaintAfterMove();
        }
    }
}

