/*
 * Decompiled with CFR 0.152.
 */
package dummy.name.math;

import dummy.name.nlputils.Index;
import java.util.ArrayList;
import java.util.List;

public class PageRank {
    private static List<Integer>[] closestNodesToEdges(Index[] closestNodes, int maxClosestNeighbors) {
        ArrayList[] edges = new ArrayList[closestNodes.length / maxClosestNeighbors];
        int i = 0;
        while (i < closestNodes.length) {
            int favouredNodeIndex = closestNodes[i].getIndex();
            ArrayList e = edges[favouredNodeIndex];
            e = e == null ? new ArrayList() : e;
            e.add(i / maxClosestNeighbors);
            edges[favouredNodeIndex] = e;
            ++i;
        }
        return edges;
    }

    public static double[] calculatePageRank(Index[] closestNodes, int maxClosestNeighbors, double teleport) {
        List<Integer>[] edges = PageRank.closestNodesToEdges(closestNodes, maxClosestNeighbors);
        return PageRank.calculatePageRank(edges, teleport);
    }

    public static double[] calculatePageRank(List<Integer>[] edges, double teleport) {
        int numOfNodes = edges.length;
        double[] ranks = new double[numOfNodes + 1];
        double unitRank = 1.0 / (double)numOfNodes;
        double teleportRank = teleport * unitRank;
        int i = 0;
        while (i < numOfNodes) {
            ranks[i] = unitRank;
            ++i;
        }
        double minRank = Double.POSITIVE_INFINITY;
        int iterations = 0;
        while (++iterations < 50) {
            minRank = Double.POSITIVE_INFINITY;
            double[] oldRanks = new double[numOfNodes];
            int i2 = 0;
            while (i2 < numOfNodes) {
                oldRanks[i2] = ranks[i2];
                ranks[i2] = 0.0;
                ++i2;
            }
            i2 = 0;
            while (i2 < numOfNodes) {
                List<Integer> neighbors = edges[i2];
                if (neighbors != null) {
                    int numOfNeighbors = neighbors.size();
                    double transitionProb = 1.0 / (double)numOfNeighbors;
                    for (Integer neighborNode : neighbors) {
                        int n = neighborNode;
                        ranks[n] = ranks[n] + (1.0 - teleport) * transitionProb * oldRanks[i2];
                    }
                }
                ++i2;
            }
            double difference = 0.0;
            int i3 = 0;
            while (i3 < numOfNodes) {
                int n = i3;
                ranks[n] = ranks[n] + teleportRank;
                difference += Math.pow(ranks[i3] - oldRanks[i3], 2.0);
                if (ranks[i3] < minRank) {
                    minRank = ranks[i3];
                }
                ++i3;
            }
            if (difference < 1.0E-5) break;
        }
        ranks[numOfNodes] = minRank;
        System.err.println(String.valueOf(iterations) + " iterations performed");
        int i4 = 0;
        while (i4 < Math.min(20, ranks.length)) {
            System.err.print(String.valueOf(ranks[i4]) + " ");
            ++i4;
        }
        System.err.println();
        return ranks;
    }
}

