/*
 * Decompiled with CFR 0.152.
 */
package dummy.name.modularity;

import dummy.name.modularity.Graph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Community {
    private boolean debug = false;
    private Graph g;
    private int size;
    private int[] n2c;
    private double[] in;
    private double[] tot;
    private int maxPasses;
    private double minModularity;
    private List<int[]> communityIndices;

    public Community(Graph gc, int nbp, double minm, List<int[]> ci) {
        this.g = gc;
        this.communityIndices = ci;
        this.size = this.g.getNumNodes();
        this.n2c = new int[this.size];
        this.in = new double[this.size];
        this.tot = new double[this.size];
        int i = 0;
        while (i < this.size) {
            this.n2c[i] = i;
            double[] selfLoopsAndWeightedDegree = this.g.getSelfLoopsAndWeightedDegree(i);
            this.in[i] = selfLoopsAndWeightedDegree[0];
            this.tot[i] = selfLoopsAndWeightedDegree[1];
            ++i;
        }
        this.maxPasses = nbp;
        this.minModularity = minm;
    }

    public Community(Graph gc, int nbp, List<int[]> ci) {
        this(gc, nbp, Double.MIN_VALUE, ci);
    }

    public Community(Graph gc, List<int[]> ci) {
        this(gc, -1, Double.MIN_VALUE, ci);
    }

    public void setDebugging(boolean debugging) {
        this.debug = debugging;
    }

    public void display() {
        System.err.print("\n<");
        int i = 0;
        while (i < this.size) {
            System.err.print(" " + i + "/" + this.n2c[i] + "/" + this.in[i] + "/" + this.tot[i] + " ");
            ++i;
        }
        System.err.println(">");
    }

    public double modularity() {
        double q = 0.0;
        int i = 0;
        while (i < this.size) {
            if (this.tot[i] > 0.0) {
                q += this.in[i] / this.g.getTotalWeight() - this.tot[i] / this.g.getTotalWeight() * (this.tot[i] / this.g.getTotalWeight());
            }
            ++i;
        }
        return q;
    }

    public Map<Integer, Double> neighboringCommunities(int node) {
        LinkedHashMap<Integer, Double> res = new LinkedHashMap<Integer, Double>();
        res.put(this.n2c[node], 0.0);
        for (Map.Entry<Integer, Double> nodeNeigh : this.g.getLinkStructure().get(node)) {
            int neigh = nodeNeigh.getKey();
            int neighborComm = -1;
            neighborComm = this.n2c[neigh];
            if (neigh == node) continue;
            Double previousValue = (Double)res.get(neighborComm);
            res.put(neighborComm, (previousValue != null ? previousValue : 0.0) + nodeNeigh.getValue());
        }
        return res;
    }

    public void partition2graph() {
        int[] renumber = new int[this.size];
        int i = 0;
        while (i < renumber.length) {
            renumber[i] = -1;
            ++i;
        }
        int node = 0;
        while (node < this.size) {
            int n = this.n2c[node];
            renumber[n] = renumber[n] + 1;
            ++node;
        }
        int finalNum = 0;
        int i2 = 0;
        while (i2 < this.size) {
            if (renumber[i2] != -1) {
                renumber[i2] = finalNum++;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.size) {
            for (Map.Entry<Integer, Double> key : this.g.getLinkStructure().get(i2)) {
                System.err.println(String.valueOf(renumber[this.n2c[i2]]) + " " + renumber[this.n2c[key.getKey()]]);
            }
            ++i2;
        }
    }

    public void displayPartition() {
        int[] renumber = new int[this.size];
        int i = 0;
        while (i < renumber.length) {
            renumber[i] = -1;
            ++i;
        }
        int node = 0;
        while (node < this.size) {
            int n = this.n2c[node];
            renumber[n] = renumber[n] + 1;
            ++node;
        }
        int finalNum = 0;
        int i2 = 0;
        while (i2 < this.size) {
            if (renumber[i2] != -1) {
                renumber[i2] = finalNum++;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.size) {
            System.err.println(renumber[this.n2c[i2]]);
            ++i2;
        }
    }

    public Graph partition2graphBinary() {
        int[] renumber = new int[this.size];
        int i = 0;
        while (i < renumber.length) {
            renumber[i] = -1;
            ++i;
        }
        int node = 0;
        while (node < this.size) {
            int n = this.n2c[node];
            renumber[n] = renumber[n] + 1;
            ++node;
        }
        int finalNum = 0;
        int i2 = 0;
        while (i2 < this.size) {
            if (renumber[i2] != -1) {
                renumber[i2] = finalNum++;
            }
            ++i2;
        }
        this.communityIndices.add(new int[this.n2c.length]);
        HashMap comm_nodes = new HashMap();
        int node2 = 0;
        while (node2 < this.size) {
            if (!comm_nodes.containsKey(renumber[this.n2c[node2]])) {
                comm_nodes.put(renumber[this.n2c[node2]], new HashSet());
            }
            this.communityIndices.get((int)(this.communityIndices.size() - 1))[node2] = renumber[this.n2c[node2]];
            ((Set)comm_nodes.get(renumber[this.n2c[node2]])).add(node2);
            ++node2;
        }
        Graph g2 = new Graph(comm_nodes.size());
        for (Map.Entry comm : comm_nodes.entrySet()) {
            HashMap<Integer, Double> m = new HashMap<Integer, Double>();
            for (Integer n : (Set)comm.getValue()) {
                for (Map.Entry<Integer, Double> neighbor : this.g.getLinkStructure().get(n)) {
                    int neigh = neighbor.getKey();
                    int neighboringCommunity = renumber[this.n2c[neigh]];
                    double weightToNeighboringCommunity = neighbor.getValue();
                    Double previousVal = (Double)m.get(neighboringCommunity);
                    m.put(neighboringCommunity, (previousVal != null ? previousVal : 0.0) + weightToNeighboringCommunity);
                }
            }
            for (Map.Entry entry : m.entrySet()) {
                g2.addOneWayEdge((Integer)comm.getKey(), entry);
            }
        }
        return g2;
    }

    public double oneLevel() {
        double newMod;
        boolean improvement = false;
        int passes = 0;
        double currentMod = newMod = this.modularity();
        do {
            currentMod = newMod;
            improvement = false;
            ++passes;
            int nodeTmp = 0;
            while (nodeTmp < this.size) {
                int node = nodeTmp;
                double[] selfLoopsAndWeightedDegree = this.g.getSelfLoopsAndWeightedDegree(node);
                int nodeComm = this.n2c[node];
                Map<Integer, Double> neighborCommunities = this.neighboringCommunities(node);
                int n = nodeComm;
                this.tot[n] = this.tot[n] - selfLoopsAndWeightedDegree[1];
                int n2 = nodeComm;
                this.in[n2] = this.in[n2] - (2.0 * neighborCommunities.get(nodeComm) + selfLoopsAndWeightedDegree[0]);
                this.n2c[node] = -1;
                int bestCommunityToInsertNode = nodeComm;
                double best_nblinks = 0.0;
                double bestIncrease = 0.0;
                for (Map.Entry<Integer, Double> it : neighborCommunities.entrySet()) {
                    double increase = it.getValue() - this.tot[it.getKey()] * selfLoopsAndWeightedDegree[1] / this.g.getTotalWeight();
                    if (!(increase > bestIncrease)) continue;
                    bestCommunityToInsertNode = it.getKey();
                    best_nblinks = it.getValue();
                    bestIncrease = increase;
                }
                int n3 = bestCommunityToInsertNode;
                this.tot[n3] = this.tot[n3] + selfLoopsAndWeightedDegree[1];
                int n4 = bestCommunityToInsertNode;
                this.in[n4] = this.in[n4] + (2.0 * best_nblinks + selfLoopsAndWeightedDegree[0]);
                this.n2c[node] = bestCommunityToInsertNode;
                if (bestCommunityToInsertNode != nodeComm) {
                    improvement = true;
                }
                ++nodeTmp;
            }
            newMod = this.modularity();
            if (!this.debug) continue;
            System.err.println("pass number " + passes + " / " + this.maxPasses + " : " + currentMod + " " + newMod);
        } while (improvement && newMod - currentMod > this.minModularity && passes != this.maxPasses);
        return newMod;
    }

    public double findBestApproximation() {
        double mod = this.modularity();
        double newMod = this.oneLevel();
        Graph graph = this.partition2graphBinary();
        while (newMod - mod > this.minModularity) {
            if (this.debug) {
                System.err.println(String.valueOf(mod) + " to " + newMod);
            }
            mod = newMod;
            Community c = new Community(graph, this.maxPasses, this.minModularity, this.communityIndices);
            newMod = c.oneLevel();
            if (this.debug) {
                System.err.println("Network : " + c.g.getNumNodes() + " nodes, " + c.g.getNumLinks() + " links, " + c.g.getTotalWeight() + " weight and modularity increased from " + mod + " to " + newMod);
            }
            graph = c.partition2graphBinary();
        }
        return newMod;
    }

    public int[] getCommunity2NodeMapping() {
        return this.getCommunity2NodeMapping(Integer.MAX_VALUE);
    }

    public int[] getCommunity2NodeMapping(int targetLevel) {
        int[] node2comm = (int[])this.communityIndices.get(0).clone();
        int level = 1;
        while (level < Math.min(targetLevel, this.communityIndices.size() - 1)) {
            int[] node2commRewriting = this.communityIndices.get(level);
            int node = 0;
            while (node < node2comm.length) {
                node2comm[node] = node2commRewriting[node2comm[node]];
                ++node;
            }
            ++level;
        }
        this.communityIndices = new LinkedList<int[]>();
        return node2comm;
    }

    public Graph getGraph() {
        return this.g;
    }
}

