/*
 * Decompiled with CFR 0.152.
 */
package dummy.name.modularity;

import dummy.name.nlputils.Index;
import dummy.name.nlputils.NLPUtils;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Graph {
    private int nodesNumber;
    private int linksNumber;
    private double totalWeight;
    private List<List<Map.Entry<Integer, Double>>> links;

    public int getNumNodes() {
        return this.nodesNumber;
    }

    public int getNumLinks() {
        return this.linksNumber;
    }

    public double getTotalWeight() {
        return this.totalWeight;
    }

    public List<List<Map.Entry<Integer, Double>>> getLinkStructure() {
        return this.links;
    }

    public Graph clone() {
        Graph copy = new Graph();
        copy.linksNumber = this.linksNumber;
        copy.nodesNumber = this.nodesNumber;
        copy.totalWeight = this.totalWeight;
        copy.links = new ArrayList<List<Map.Entry<Integer, Double>>>(this.nodesNumber);
        for (List<Map.Entry<Integer, Double>> edgeList : this.links) {
            ArrayList<AbstractMap.SimpleEntry<Integer, Double>> copiedEdges = new ArrayList<AbstractMap.SimpleEntry<Integer, Double>>(edgeList.size());
            for (Map.Entry<Integer, Double> edge : edgeList) {
                copiedEdges.add(new AbstractMap.SimpleEntry<Integer, Double>(edge.getKey(), edge.getValue()));
            }
            copy.links.add(copiedEdges);
        }
        return copy;
    }

    public Graph() {
        this.nodesNumber = 0;
        this.linksNumber = 0;
        this.totalWeight = 0.0;
    }

    public Graph(int nodeNumber) {
        this.linksNumber = 0;
        this.totalWeight = 0.0;
        this.nodesNumber = nodeNumber;
        this.links = new ArrayList<List<Map.Entry<Integer, Double>>>(this.nodesNumber);
        int i = 0;
        while (i < nodeNumber) {
            this.links.add(new ArrayList(this.nodesNumber));
            ++i;
        }
    }

    public Graph(double[][] similarityMatrix, boolean weighted) {
        this(similarityMatrix, weighted, false, null);
    }

    public Graph(Index[] closestNodes, int maxNeighbors, boolean weighted, boolean addExtraEdges, Set<Integer> outliers) {
        this.nodesNumber = closestNodes.length / maxNeighbors;
        this.links = new ArrayList<List<Map.Entry<Integer, Double>>>(this.nodesNumber);
        int i = 0;
        while (i < this.nodesNumber) {
            this.links.add(new ArrayList(this.nodesNumber));
            ++i;
        }
        i = 0;
        while (i < closestNodes.length) {
            if (closestNodes[i] != null) {
                int from = i / maxNeighbors;
                int to = closestNodes[i].getIndex();
                double weight = closestNodes[i].getDistance();
                if (weight > 0.0) {
                    this.links.get(from).add(new AbstractMap.SimpleEntry<Integer, Double>(to, weighted ? weight : 1.0));
                    this.links.get(to).add(new AbstractMap.SimpleEntry<Integer, Double>(from, weighted ? weight : 1.0));
                }
            }
            ++i;
        }
        i = 0;
        while (i < this.nodesNumber) {
            boolean noEdges;
            boolean bl = noEdges = this.links.get(i).size() == 0;
            if (noEdges && addExtraEdges) {
                int randomNodeId = i + 1;
                while (randomNodeId < this.nodesNumber) {
                    this.links.get(randomNodeId).add(new AbstractMap.SimpleEntry<Integer, Double>(i, weighted ? Double.MIN_VALUE : 1.0));
                    this.links.get(randomNodeId).add(new AbstractMap.SimpleEntry<Integer, Double>(i, weighted ? Double.MIN_VALUE : 1.0));
                    ++randomNodeId;
                }
            } else if (noEdges && outliers != null) {
                outliers.add(i);
            }
            ++i;
        }
        this.renumber();
    }

    public Graph(int[] neighbors, double[] similarities, int maxNeighbors, boolean weighted, boolean addExtraEdges, Set<Integer> outliers) {
        this.nodesNumber = neighbors.length / maxNeighbors;
        this.links = new ArrayList<List<Map.Entry<Integer, Double>>>(this.nodesNumber);
        int i = 0;
        while (i < this.nodesNumber) {
            this.links.add(new ArrayList(this.nodesNumber));
            ++i;
        }
        i = 0;
        while (i < neighbors.length) {
            int from = i / maxNeighbors;
            int to = neighbors[i];
            double weight = similarities[i];
            if (weight > 0.0) {
                this.links.get(from).add(new AbstractMap.SimpleEntry<Integer, Double>(to, weighted ? weight : 1.0));
                this.links.get(to).add(new AbstractMap.SimpleEntry<Integer, Double>(from, weighted ? weight : 1.0));
            }
            ++i;
        }
        i = 0;
        while (i < this.nodesNumber) {
            boolean noEdges;
            boolean bl = noEdges = this.links.get(i).size() == 0;
            if (noEdges && addExtraEdges) {
                int randomNodeId = i + 1;
                while (randomNodeId < this.nodesNumber) {
                    this.links.get(randomNodeId).add(new AbstractMap.SimpleEntry<Integer, Double>(i, weighted ? Double.MIN_VALUE : 1.0));
                    this.links.get(randomNodeId).add(new AbstractMap.SimpleEntry<Integer, Double>(i, weighted ? Double.MIN_VALUE : 1.0));
                    ++randomNodeId;
                }
            } else if (noEdges && outliers != null) {
                outliers.add(i);
            }
            ++i;
        }
        this.renumber();
    }

    public Graph(double[][] similarityMatrix, boolean weighted, boolean addExtraEdges, Set<Integer> outliers) {
        this.nodesNumber = similarityMatrix.length;
        this.links = new ArrayList<List<Map.Entry<Integer, Double>>>(this.nodesNumber);
        int i = 0;
        while (i < this.nodesNumber) {
            this.links.add(new ArrayList(this.nodesNumber));
            ++i;
        }
        i = 0;
        while (i < this.nodesNumber) {
            int j = i + 1;
            while (j < this.nodesNumber) {
                if (similarityMatrix[i][j] > 0.0) {
                    this.links.get(j).add(new AbstractMap.SimpleEntry<Integer, Double>(i, weighted ? similarityMatrix[i][j] : 1.0));
                    this.links.get(i).add(new AbstractMap.SimpleEntry<Integer, Double>(j, weighted ? similarityMatrix[i][j] : 1.0));
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nodesNumber) {
            boolean noEdges;
            boolean bl = noEdges = this.links.get(i).size() == 0;
            if (noEdges && addExtraEdges) {
                int randomNodeId = i + 1;
                while (randomNodeId < this.nodesNumber) {
                    this.links.get(randomNodeId).add(new AbstractMap.SimpleEntry<Integer, Double>(i, weighted ? Double.MIN_VALUE : 1.0));
                    this.links.get(randomNodeId).add(new AbstractMap.SimpleEntry<Integer, Double>(i, weighted ? Double.MIN_VALUE : 1.0));
                    ++randomNodeId;
                }
            } else if (noEdges && outliers != null) {
                outliers.add(i);
            }
            ++i;
        }
        this.renumber();
    }

    public Graph(ArrayList<List<Map.Entry<Integer, Double>>> l) {
        this.links = l;
        this.renumber();
    }

    public void display() {
        System.out.println("Graph: ");
        int i = 0;
        while (i < this.links.size()) {
            for (Map.Entry<Integer, Double> node : this.links.get(i)) {
                System.out.println(String.valueOf(i) + " " + node.getKey() + " " + node.getValue());
            }
            ++i;
        }
    }

    public double[] getSelfLoopsAndWeightedDegree(int node) {
        assert (node >= 0 && node < this.nodesNumber);
        double selfLoopWeight = 0.0;
        double weightedDegree = 0.0;
        for (Map.Entry<Integer, Double> neighbor : this.links.get(node)) {
            weightedDegree += neighbor.getValue().doubleValue();
            if (neighbor.getKey() != node) continue;
            selfLoopWeight = neighbor.getValue();
        }
        return new double[]{selfLoopWeight, weightedDegree};
    }

    public void renumber() {
        int j;
        int[] linked = new int[this.links.size()];
        int[] renum = new int[this.links.size()];
        int i = 0;
        while (i < renum.length) {
            renum[i] = -1;
            ++i;
        }
        int nb = 0;
        int i2 = 0;
        while (i2 < this.links.size()) {
            j = 0;
            while (j < this.links.get(i2).size()) {
                linked[i2] = 1;
                linked[this.links.get((int)i2).get((int)j).getKey().intValue()] = 1;
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.links.size()) {
            if (linked[i2] == 1) {
                renum[i2] = nb++;
            }
            ++i2;
        }
        this.totalWeight = 0.0;
        this.linksNumber = 0;
        i2 = 0;
        while (i2 < this.links.size()) {
            if (linked[i2] == 1) {
                this.linksNumber += this.links.get(i2).size();
                j = 0;
                while (j < this.links.get(i2).size()) {
                    Map.Entry<Integer, Double> entry = this.links.get(i2).get(j);
                    this.totalWeight += entry.getValue().doubleValue();
                    this.links.get(i2).set(j, new AbstractMap.SimpleEntry<Integer, Double>(renum[entry.getKey()], entry.getValue()));
                    ++j;
                }
                this.links.set(renum[i2], this.links.get(i2));
            }
            ++i2;
        }
        this.linksNumber /= 2;
        this.links = this.links.subList(0, nb);
        this.nodesNumber = this.links.size();
    }

    public void orderEdges(boolean descending) {
        int node = 0;
        while (node < this.links.size()) {
            int i;
            List<Map.Entry<Integer, Double>> edges = this.links.get(node);
            ArrayList<Map.Entry<Integer, Double>> rankedEdges = new ArrayList<Map.Entry<Integer, Double>>(edges.size());
            double[] similarities = new double[edges.size()];
            int i2 = 0;
            while (i2 < edges.size()) {
                similarities[i2] = edges.get(i2).getValue();
                ++i2;
            }
            int[] ranking = NLPUtils.stableSort(similarities);
            if (descending) {
                i = ranking.length - 1;
                while (i >= 0) {
                    rankedEdges.add(edges.get(ranking[i]));
                    --i;
                }
            } else {
                i = 0;
                while (i < ranking.length) {
                    rankedEdges.add(edges.get(ranking[i]));
                    ++i;
                }
            }
            this.links.set(node, rankedEdges);
            ++node;
        }
    }

    public void orderEdges() {
        this.orderEdges(true);
    }

    public Graph getKNearest(int k, boolean orderEdges) {
        if (orderEdges) {
            this.orderEdges();
        }
        Graph g = new Graph(this.getNumNodes());
        int node = 0;
        while (node < this.getNumNodes()) {
            List<Map.Entry<Integer, Double>> edges = this.links.get(node);
            double prevEdgeVal = 0.0;
            int i = 0;
            while (i < edges.size()) {
                Map.Entry<Integer, Double> edge = edges.get(i);
                if (i >= k && prevEdgeVal != edge.getValue()) break;
                g.addEdge(node, edge);
                prevEdgeVal = edge.getValue();
                ++i;
            }
            ++node;
        }
        return g;
    }

    public Graph getKNearest(int k) {
        return this.getKNearest(k, true);
    }

    public void addEdge(int fromNode, int toNode, double weight) {
        if (weight != 0.0) {
            this.addEdge(fromNode, new AbstractMap.SimpleEntry<Integer, Double>(toNode, weight));
        }
    }

    public void addOneWayEdge(int fromNode, Map.Entry<Integer, Double> neighbor) {
        this.totalWeight += neighbor.getValue().doubleValue();
        if (fromNode < neighbor.getKey()) {
            ++this.linksNumber;
        }
        this.links.get(fromNode).add(new AbstractMap.SimpleEntry<Integer, Double>(neighbor.getKey(), neighbor.getValue()));
    }

    public void addEdge(int fromNode, Map.Entry<Integer, Double> neighbor) {
        if (neighbor.getValue() == 0.0) {
            return;
        }
        if (fromNode < neighbor.getKey()) {
            ++this.linksNumber;
            this.totalWeight += 2.0 * neighbor.getValue();
            this.links.get(fromNode).add(new AbstractMap.SimpleEntry<Integer, Double>(neighbor.getKey(), neighbor.getValue()));
            this.links.get(neighbor.getKey()).add(new AbstractMap.SimpleEntry<Integer, Double>(fromNode, neighbor.getValue()));
        } else {
            List<Map.Entry<Integer, Double>> fromNeighbors = this.links.get(fromNode);
            if (fromNeighbors.contains(neighbor)) {
                return;
            }
            ++this.linksNumber;
            this.totalWeight += 2.0 * neighbor.getValue();
            this.links.get(fromNode).add(new AbstractMap.SimpleEntry<Integer, Double>(neighbor.getKey(), neighbor.getValue()));
            this.links.get(neighbor.getKey()).add(new AbstractMap.SimpleEntry<Integer, Double>(fromNode, neighbor.getValue()));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Nodes: " + this.nodesNumber + "\tlinks: " + this.linksNumber + "\tweight: " + this.totalWeight + "\nFirst 10 nodes\n");
        int i = 0;
        while (i < Math.min(this.links.size(), 10)) {
            sb.append(String.valueOf(i) + "\t" + this.links.get(i) + "\n");
            ++i;
        }
        return sb.toString();
    }
}

