/*
 * Decompiled with CFR 0.152.
 */
package dummy.name.nlp.pos.rfst;

import dummy.name.nlp.pos.rfst.Pair;
import dummy.name.nlp.pos.rfst.StateIterator;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class RFSA {
    protected int stateCount;
    protected int edgeCount;
    protected int startingState;
    protected boolean[] ab;
    protected int[] indices;
    protected int[] targets;
    protected String[] symbols;
    protected char[] charsymbols;
    protected int a;
    protected int at;
    protected boolean sorted;
    protected String[] symbolhistory;

    public RFSA(int startingState, int stateCount, int edgeCount) {
        this.startingState = startingState;
        this.stateCount = stateCount;
        this.edgeCount = edgeCount;
        this.ab = new boolean[stateCount];
        this.targets = new int[edgeCount];
        this.symbols = new String[edgeCount];
        this.charsymbols = new char[edgeCount];
        this.indices = new int[stateCount + 1];
        Arrays.fill(this.indices, -1);
        this.indices[stateCount] = edgeCount;
    }

    public boolean adeterministic() {
        int undeterministic = 0;
        int undets = 0;
        for (int s : this.allStates()) {
            HashMap<String, Integer> labels = new HashMap<String, Integer>();
            boolean b = false;
            for (Pair<String, Integer> p : this.outgoing(s)) {
                if (labels.containsKey(p.getA())) {
                    b = true;
                    ++undeterministic;
                }
                labels.put(p.getA(), p.getB());
            }
            if (!b) continue;
            ++undets;
        }
        return undeterministic == 0;
    }

    public boolean legal(String s) {
        return true;
    }

    public void binarySearch(int q, char c, Processor p) {
        int i = this.indices[q];
        int j = this.indices[q + 1];
        int low = i;
        int high = j - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = this.charsymbols[mid] - c;
            if (cmp == 0) {
                int l = mid;
                while (++mid < j && this.charsymbols[mid] == c) {
                }
                while (--l >= i && this.charsymbols[l] == c) {
                }
                int next = l + 1;
                while (next < mid) {
                    p.process(next);
                    ++next;
                }
                break;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp <= 0) continue;
            high = mid - 1;
        }
    }

    public Collection<String> analyse(String s) {
        char[] ac = s.toLowerCase().toCharArray();
        return this.analyse(ac);
    }

    public Collection<String> analyse(char[] ac) {
        ArrayList<String> analyses = new ArrayList<String>();
        this.symbolhistory = new String[ac.length + 1];
        this.analyse(this.startingState, ac, 0, "", analyses);
        return analyses;
    }

    public void analyse(int q, char[] ac, int pos, String symbol, Collection<String> analyses) {
        this.symbolhistory[pos] = symbol;
        if (pos == ac.length) {
            if (this.ab[q]) {
                analyses.add(symbol);
            }
            return;
        }
        char c = ac[pos];
        int i = this.indices[q];
        int j = this.indices[q + 1];
        int low = i;
        int high = j - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            int cmp = this.charsymbols[mid] - c;
            if (cmp == 0) {
                int l = mid;
                while (++mid < j && this.charsymbols[mid] == c) {
                }
                while (--l >= i && this.charsymbols[l] == c) {
                }
                int next = l + 1;
                while (next < mid) {
                    this.analyse(this.targets[next], ac, pos + 1, String.valueOf(symbol) + this.symbols[next], analyses);
                    ++next;
                }
                break;
            }
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp <= 0) continue;
            high = mid - 1;
        }
    }

    public void analyse1(int q, char[] ac, int pos, String symbol, Collection<String> analyses) {
        if (pos == ac.length) {
            if (this.ab[q]) {
                analyses.add(symbol);
            }
            return;
        }
        char c = ac[pos];
        int i = this.indices[q];
        int j = this.indices[q + 1];
        int next = i;
        while (next < j) {
            if (c == this.charsymbols[next]) {
                this.analyse(this.targets[next], ac, pos + 1, String.valueOf(symbol) + this.symbols[next], analyses);
            }
            ++next;
        }
    }

    public void addState(int s, boolean accepting) {
        this.ab[s] = accepting;
    }

    public void addEdge(int source, String label, int target) {
        char input;
        if (source < this.a) {
            throw new IllegalArgumentException();
        }
        if (this.indices[source] == -1) {
            this.indices[source] = this.at;
        }
        this.charsymbols[this.at] = input = label.charAt(0);
        this.symbols[this.at] = label.substring(1);
        this.targets[this.at] = target;
        this.a = source;
        ++this.at;
    }

    public String getKRLemma(String symbol) {
        String KR_szoto = "";
        String[] stringArray = symbol.split("\\+");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String morph = stringArray[n2];
            int s = morph.startsWith("$") ? 1 : 0;
            int ppp = morph.indexOf(47);
            KR_szoto = ppp < 0 ? String.valueOf(KR_szoto) + morph.substring(s) : String.valueOf(KR_szoto) + morph.substring(s, ppp);
            ++n2;
        }
        KR_szoto = KR_szoto.replace("@", "");
        return KR_szoto;
    }

    protected String getLastPOS(String symbol, String pos) {
        if (symbol.contains(pos)) {
            return String.valueOf(symbol.substring(0, symbol.indexOf(pos))) + pos.substring(0, pos.indexOf("["));
        }
        return symbol;
    }

    protected String getMSDLemma(char[] ac) {
        String KR_szoto;
        int p;
        String symbol;
        String POS = symbol = this.symbolhistory[this.symbolhistory.length - 1];
        POS = this.getLastPOS(POS, "/ADJ[COMPAR]");
        POS = this.getLastPOS(POS, "/ADJ[SUPERLAT]");
        POS = this.getLastPOS(POS, "/ADJ[SUPERSUPERLAT]");
        POS = this.getLastPOS(POS, "/ADJ[MANNER]");
        int pp = (POS = this.getLastPOS(POS, "/NOUN[ESS_FOR]")).indexOf(60, p = POS.lastIndexOf(47));
        if (pp > 0) {
            POS = symbol.substring(0, pp);
        }
        int i = 0;
        while (!(this.symbolhistory[i].startsWith(POS) || !this.symbolhistory[i].contains("/") && this.symbolhistory[i].equals(POS.substring(0, p)))) {
            ++i;
        }
        String szoalak_szoto = new String(ac).substring(0, i);
        if (symbol.contains("/ADJ[SUPERLAT]")) {
            szoalak_szoto = new String(ac).substring(3, i);
        }
        if (symbol.contains("/ADJ[SUPERSUPERLAT]") && szoalak_szoto.startsWith("legesleg")) {
            szoalak_szoto = new String(ac).substring(8, i);
        }
        String MSDszoto = (KR_szoto = this.getKRLemma(this.symbolhistory[i])).length() >= szoalak_szoto.length() ? KR_szoto : szoalak_szoto;
        return MSDszoto;
    }

    public void noedge(int source) {
        if (source < this.a) {
            throw new IllegalArgumentException();
        }
        this.indices[source] = this.at;
        this.a = source;
    }

    public void setAccepting(int state, boolean b) {
        this.ab[state] = b;
    }

    public int startingState() {
        return this.startingState;
    }

    public Iterable<Integer> allStates() {
        return new StateIterator(this.stateCount);
    }

    public boolean isAccepting(int state) {
        return this.ab[state];
    }

    public Iterable<Pair<String, Integer>> outgoing(int state) {
        return new EdgeIterable(state);
    }

    public int size(int s) {
        if (s >= this.stateCount) {
            throw new IllegalArgumentException(String.valueOf(s) + " >= " + this.stateCount);
        }
        return this.indices[s + 1] - this.indices[s];
    }

    public int stateCount() {
        return this.stateCount;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.stateCount + ", " + this.edgeCount + "]";
    }

    public String toDetailedString() {
        StringBuffer sb = new StringBuffer("  " + this.stateCount + ", " + this.edgeCount + ", " + this.startingState + "\n");
        int i = 0;
        while (i < this.stateCount) {
            sb.append("    " + i + ", " + this.ab[i] + ", " + (this.indices[i + 1] - this.indices[i]) + "\n");
            int j = this.indices[i];
            while (j < this.indices[i + 1]) {
                sb.append("      " + this.targets[j] + ": >" + this.charsymbols[j] + "|" + this.symbols[j] + "<\n");
                ++j;
            }
            ++i;
        }
        return sb.toString();
    }

    protected Sorter createSorter(int state) {
        return new Sorter(state);
    }

    public void sort() {
        this.sorted = true;
        int state = 0;
        while (state < this.stateCount) {
            if (this.indices[state] != this.indices[state + 1]) {
                Sorter sorter = this.createSorter(state);
                sorter.sort();
            }
            ++state;
        }
    }

    public int valid() {
        int size;
        HashSet<Integer> valid = new HashSet<Integer>();
        int i = 0;
        while (i < this.stateCount) {
            if (this.ab[i]) {
                valid.add(i);
            }
            ++i;
        }
        System.out.println(String.valueOf(this.getClass().getSimpleName()) + ": valid starts with " + valid.size() + " accepting states");
        do {
            size = valid.size();
            int i2 = 0;
            while (i2 < this.stateCount) {
                if (!valid.contains(i2)) {
                    int j = this.indices[i2];
                    while (j < this.indices[i2 + 1]) {
                        if (valid.contains(this.targets[j])) {
                            valid.add(i2);
                            break;
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        } while (valid.size() != size);
        return valid.size();
    }

    public void print(String file) throws IOException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
        pw.println(String.valueOf(this.startingState) + "\t" + this.stateCount + "\t" + this.edgeCount);
        int i = 0;
        while (i < this.stateCount) {
            pw.println(String.valueOf(i) + "\t" + this.ab[i]);
            pw.println(this.indices[i + 1] - this.indices[i]);
            int j = this.indices[i];
            while (j < this.indices[i + 1]) {
                pw.println(String.valueOf(this.charsymbols[j]) + this.symbols[j] + "\t" + this.targets[j]);
                ++j;
            }
            ++i;
        }
        pw.close();
    }

    public int getA() {
        return this.a;
    }

    public boolean[] getAb() {
        return this.ab;
    }

    public int getAt() {
        return this.at;
    }

    public char[] getCharsymbols() {
        return this.charsymbols;
    }

    public int getEdgeCount() {
        return this.edgeCount;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public int getStartingState() {
        return this.startingState;
    }

    public int getStateCount() {
        return this.stateCount;
    }

    public String[] getSymbols() {
        return this.symbols;
    }

    public int[] getTargets() {
        return this.targets;
    }

    public static RFSA read(InputStream rfsaStream, String encoding) throws IOException {
        HashMap<String, String> labelMap = new HashMap<String, String>();
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(rfsaStream, encoding));
        String line = reader.readLine();
        StringTokenizer st = new StringTokenizer(line);
        int startIndex = Integer.parseInt(st.nextToken());
        int stateCount = Integer.parseInt(st.nextToken());
        int edgeCount = Integer.parseInt(st.nextToken());
        RFSA rfsa = new RFSA(startIndex, stateCount, edgeCount);
        int i = 0;
        while (i < stateCount) {
            line = reader.readLine();
            st = new StringTokenizer(line, "\t");
            int state = Integer.parseInt(st.nextToken());
            boolean accepting = new Boolean(st.nextToken());
            rfsa.addState(state, accepting);
            line = reader.readLine();
            st = new StringTokenizer(line);
            int edges = Integer.parseInt(st.nextToken());
            if (edges == 0) {
                rfsa.noedge(state);
            }
            int j = 0;
            while (j < edges) {
                int index;
                line = reader.readLine();
                String s = line.substring(0, index = line.indexOf(9));
                if (s.length() == 0) {
                    throw new IllegalStateException();
                }
                int target = Integer.parseInt(line.substring(index + 1));
                String label = (String)labelMap.get(s);
                if (label == null) {
                    label = s;
                    labelMap.put(s, label);
                }
                rfsa.addEdge(state, label, target);
                ++j;
            }
            ++i;
        }
        reader.close();
        rfsa.sort();
        return rfsa;
    }

    public static RFSA read(String defaultRfsa) {
        return null;
    }

    public class EdgeIter {
        protected int state;
        protected int size;
        protected int start;
        protected int next;

        public EdgeIter(int state) {
            this.state = state;
            this.size = RFSA.this.size(state);
            this.next = this.start = RFSA.this.indices[state];
        }

        public boolean hasNext() {
            return this.next < this.start + this.size;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public class EdgeIterable
    extends EdgeIter
    implements Iterable<Pair<String, Integer>>,
    Iterator<Pair<String, Integer>> {
        public EdgeIterable(int state) {
            super(state);
        }

        @Override
        public Iterator<Pair<String, Integer>> iterator() {
            return new EdgeIterable(this.state);
        }

        @Override
        public Pair<String, Integer> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int target = RFSA.this.targets[this.next];
            String label = String.valueOf(RFSA.this.charsymbols[this.next]) + RFSA.this.symbols[this.next];
            ++this.next;
            return new Pair<String, Integer>(label, target);
        }
    }

    public static interface Processor {
        public void process(int var1);
    }

    public class Sorter {
        protected int state;
        protected int length;

        public Sorter(int state) {
            this.state = state;
        }

        public void sort() {
            this.length = RFSA.this.indices[this.state + 1] - RFSA.this.indices[this.state];
            String[] as = new String[this.length];
            char[] ac = new char[this.length];
            int[] at = new int[this.length];
            System.arraycopy(RFSA.this.charsymbols, RFSA.this.indices[this.state], ac, 0, this.length);
            System.arraycopy(RFSA.this.symbols, RFSA.this.indices[this.state], as, 0, this.length);
            System.arraycopy(RFSA.this.targets, RFSA.this.indices[this.state], at, 0, this.length);
            Integer[] ai = new Integer[this.length];
            int i = 0;
            while (i < this.length) {
                ai[i] = i + RFSA.this.indices[this.state];
                ++i;
            }
            Arrays.sort(ai, new Comparator<Integer>(){

                @Override
                public int compare(Integer arg0, Integer arg1) {
                    return ((Sorter)Sorter.this).RFSA.this.charsymbols[arg0] - ((Sorter)Sorter.this).RFSA.this.charsymbols[arg1];
                }
            });
            i = 0;
            while (i < this.length) {
                int j = ai[i] - RFSA.this.indices[this.state];
                RFSA.this.charsymbols[i + RFSA.this.indices[this.state]] = ac[j];
                RFSA.this.symbols[i + RFSA.this.indices[this.state]] = as[j];
                RFSA.this.targets[i + RFSA.this.indices[this.state]] = at[j];
                ++i;
            }
        }
    }
}

