/*
 * Decompiled with CFR 0.152.
 */
package dummy.name.nlputils;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.zip.GZIPInputStream;

public class NLPUtils {
    private static double SMALL = 1.0E-6;

    public static double[] meanAndVariance(Collection<Number> vector) {
        return NLPUtils.meanAndVariance(vector.toArray(new Number[vector.size()]), true);
    }

    public static double[] meanAndVariance(Collection<Number> vector, boolean biased) {
        return NLPUtils.meanAndVariance(vector.toArray(new Number[vector.size()]), biased);
    }

    public static double[] meanAndVariance(Number[] vector, boolean biased) {
        double sum = 0.0;
        double ssum = 0.0;
        if (vector.length == 0) {
            return new double[]{0.0, 0.0};
        }
        int i = 0;
        while (i < vector.length) {
            sum += vector[i].doubleValue();
            ssum += vector[i].doubleValue() * vector[i].doubleValue();
            ++i;
        }
        double mean = sum / (double)vector.length;
        double variance = ssum / (double)vector.length - mean * mean;
        if (!biased) {
            variance *= (double)vector.length / (double)(vector.length - 1);
        }
        return new double[]{mean, variance};
    }

    /*
     * Unable to fully structure code
     */
    private static <T extends Comparable<? super T>> int partition(T[] array, int[] index, int l, int r) {
        pivot = array[index[(l + r) / 2]];
        ** GOTO lbl15
        {
            ++l;
            do {
                if (array[index[l]].compareTo(pivot) < 0 && l < r) continue block0;
                while (array[index[r]].compareTo(pivot) > 0 && l < r) {
                    --r;
                }
                if (l >= r) continue;
                help = index[l];
                index[l] = index[r];
                index[r] = help;
                ++l;
                --r;
lbl15:
                // 3 sources

            } while (l < r);
        }
        if (l == r && array[index[r]].compareTo(pivot) > 0) {
            --r;
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    private static int partition(double[] array, int[] index, int l, int r) {
        pivot = array[index[(l + r) / 2]];
        ** GOTO lbl15
        {
            ++l;
            do {
                if (array[index[l]] < pivot && l < r) continue block0;
                while (array[index[r]] > pivot && l < r) {
                    --r;
                }
                if (l >= r) continue;
                help = index[l];
                index[l] = index[r];
                index[r] = help;
                ++l;
                --r;
lbl15:
                // 3 sources

            } while (l < r);
        }
        if (l == r && array[index[r]] > pivot) {
            --r;
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    private static int partition(int[] array, int[] index, int l, int r) {
        pivot = array[index[(l + r) / 2]];
        ** GOTO lbl15
        {
            ++l;
            do {
                if ((double)array[index[l]] < pivot && l < r) continue block0;
                while ((double)array[index[r]] > pivot && l < r) {
                    --r;
                }
                if (l >= r) continue;
                help = index[l];
                index[l] = index[r];
                index[r] = help;
                ++l;
                --r;
lbl15:
                // 3 sources

            } while (l < r);
        }
        if (l == r && (double)array[index[r]] > pivot) {
            --r;
        }
        return r;
    }

    public static <T extends Comparable<? super T>> int[] stableSort(T[] array) {
        int[] index = new int[array.length];
        int[] newIndex = new int[array.length];
        array = (Comparable[])array.clone();
        int i = 0;
        while (i < index.length) {
            index[i] = i;
            ++i;
        }
        NLPUtils.quickSort(array, (int[])index, (int)0, (int)(array.length - 1));
        i = 0;
        while (i < index.length) {
            int numEqual = 1;
            int j = i + 1;
            while (j < index.length && array[index[i]].equals(array[index[j]])) {
                ++numEqual;
                ++j;
            }
            if (numEqual > 1) {
                int[] helpIndex = new int[numEqual];
                j = 0;
                while (j < numEqual) {
                    helpIndex[j] = i + j;
                    ++j;
                }
                NLPUtils.quickSort(index, helpIndex, 0, numEqual - 1);
                j = 0;
                while (j < numEqual) {
                    newIndex[i + j] = index[helpIndex[j]];
                    ++j;
                }
                i += numEqual;
                continue;
            }
            newIndex[i] = index[i];
            ++i;
        }
        return newIndex;
    }

    public static int[] stableSort(double[] array) {
        int[] index = new int[array.length];
        int[] newIndex = new int[array.length];
        array = (double[])array.clone();
        int i = 0;
        while (i < index.length) {
            index[i] = i;
            if (Double.isNaN(array[i])) {
                array[i] = Double.MAX_VALUE;
            }
            ++i;
        }
        NLPUtils.quickSort(array, index, 0, array.length - 1);
        i = 0;
        while (i < index.length) {
            int numEqual = 1;
            int j = i + 1;
            while (j < index.length && NLPUtils.eq(array[index[i]], array[index[j]])) {
                ++numEqual;
                ++j;
            }
            if (numEqual > 1) {
                int[] helpIndex = new int[numEqual];
                j = 0;
                while (j < numEqual) {
                    helpIndex[j] = i + j;
                    ++j;
                }
                NLPUtils.quickSort(index, helpIndex, 0, numEqual - 1);
                j = 0;
                while (j < numEqual) {
                    newIndex[i + j] = index[helpIndex[j]];
                    ++j;
                }
                i += numEqual;
                continue;
            }
            newIndex[i] = index[i];
            ++i;
        }
        return newIndex;
    }

    private static <T extends Comparable<? super T>> void quickSort(T[] array, int[] index, int left, int right) {
        if (left < right) {
            int middle = NLPUtils.partition(array, (int[])index, (int)left, (int)right);
            NLPUtils.quickSort(array, (int[])index, (int)left, (int)middle);
            NLPUtils.quickSort(array, (int[])index, (int)(middle + 1), (int)right);
        }
    }

    private static void quickSort(double[] array, int[] index, int left, int right) {
        if (left < right) {
            int middle = NLPUtils.partition(array, index, left, right);
            NLPUtils.quickSort(array, index, left, middle);
            NLPUtils.quickSort(array, index, middle + 1, right);
        }
    }

    private static void quickSort(int[] array, int[] index, int left, int right) {
        if (left < right) {
            int middle = NLPUtils.partition(array, index, left, right);
            NLPUtils.quickSort(array, index, left, middle);
            NLPUtils.quickSort(array, index, middle + 1, right);
        }
    }

    private static boolean eq(double a, double b) {
        return a - b < SMALL && b - a < SMALL;
    }

    public static InputStream getInputStreamFromURLOrClasspathOrFileSystem(String textFileOrUrl) throws IOException {
        InputStream in;
        if (textFileOrUrl.matches("https?://.*")) {
            URL u = new URL(textFileOrUrl);
            URLConnection uc = u.openConnection();
            in = uc.getInputStream();
        } else {
            try {
                in = NLPUtils.findStreamInClasspathOrFileSystem(textFileOrUrl);
            }
            catch (IOException e) {
                try {
                    URL u = new URL(textFileOrUrl);
                    URLConnection uc = u.openConnection();
                    in = uc.getInputStream();
                }
                catch (IOException e2) {
                    throw new IOException("Unable to resolve \"" + textFileOrUrl + "\" as either " + "class path, filename or URL");
                }
            }
        }
        in = new BufferedInputStream(in);
        if (textFileOrUrl.endsWith(".gz")) {
            in = new GZIPInputStream(in);
        }
        return in;
    }

    public static InputStream findStreamInClasspathOrFileSystem(String name) throws FileNotFoundException {
        InputStream is = NLPUtils.class.getClassLoader().getResourceAsStream(name);
        if (is == null) {
            is = NLPUtils.class.getClassLoader().getResourceAsStream(name.replaceAll("\\\\", "/"));
        }
        if (is == null) {
            is = new FileInputStream(name);
        }
        return is;
    }

    public static String join(String[] str) {
        return NLPUtils.join(str, ' ');
    }

    public static String join(String[] str, char joiner) {
        if (str.length == 0) {
            return "";
        }
        StringBuffer result = new StringBuffer(str[0]);
        int i = 1;
        while (i < str.length) {
            result.append(String.valueOf(joiner) + str[i]);
            ++i;
        }
        return result.toString();
    }

    public static void readDocToCollection(String file, Collection<String> collection) {
        NLPUtils.readDocToCollection(file, collection, "UTF-8");
    }

    public static void readDocToCollection(String file, Collection<String> collection, String chSet) {
        NLPUtils.readDocToCollection(file, collection, Charset.forName(chSet));
    }

    public static void readDocToCollection(String file, Collection<String> collection, Charset cs) {
        try {
            NLPUtils.readDocToCollection(new FileInputStream(new File(file)), collection, cs);
        }
        catch (FileNotFoundException e) {
            System.err.println("Error during reading input stream " + file);
        }
    }

    public static void readDocToCollection(InputStream is, Collection<String> collection, Charset cs) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(is, cs));
            while ((line = br.readLine()) != null) {
                collection.add(line);
            }
            br.close();
        }
        catch (NullPointerException ne) {
            System.err.println("Collection to add elements into not initialized...");
        }
        catch (IOException e) {
            System.err.println("Error during reading input stream " + is);
        }
    }
}

