/*
 * Decompiled with CFR 0.152.
 */
package dummy.name.nlputils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class SparseDocument
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 4726825935896926164L;
    private String title;
    private String wid;
    private int documentLength;
    private int[] indices;
    private int[] frequencies;
    private int[] ranking;
    private double[] tfIdfValues;
    private double[] firstPositions;
    private double[] probabilities;
    private boolean[] isNE;
    private int nonzeroElements;

    public SparseDocument() {
        this(10);
    }

    public SparseDocument(String title) {
        this(title, 10);
    }

    public SparseDocument(String title, String id) {
        this(title, 10);
        this.wid = id;
    }

    public SparseDocument(String id, int numAttributes) {
        this(numAttributes);
        this.title = id;
    }

    public SparseDocument(int numAttributes) {
        this.ranking = new int[numAttributes];
        this.tfIdfValues = new double[numAttributes];
        this.firstPositions = new double[numAttributes];
        this.probabilities = new double[numAttributes];
        this.indices = new int[numAttributes];
        this.frequencies = new int[numAttributes];
        this.isNE = new boolean[numAttributes];
    }

    public SparseDocument(Map<Integer, double[]> wordsToFeatures) {
        this();
        for (Map.Entry<Integer, double[]> wordFeature : wordsToFeatures.entrySet()) {
            double[] featureValues = wordFeature.getValue();
            this.setFeatureValAt(wordFeature.getKey(), 1, featureValues[1], featureValues[2], featureValues[3], (int)featureValues[5], featureValues[4] > 0.5);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getId() {
        return this.wid;
    }

    public void setId(String newId) {
        this.wid = newId;
    }

    public void setRankingAt(int position, int rank) {
        this.ranking[position] = rank;
    }

    public void setTfIdfAt(int position, double value) {
        this.tfIdfValues[position] = value;
    }

    public int[] getTopKeyphraseIds(int k) {
        int[] keyphraseIds = new int[k];
        int i = 0;
        while (i < this.nonzeroElements) {
            if (this.ranking[i] <= k && this.ranking[i] > 0) {
                keyphraseIds[this.ranking[i] - 1] = this.indices[i];
            }
            ++i;
        }
        return keyphraseIds;
    }

    public double[] getFeaturesAt(int featureId) {
        int search = Arrays.binarySearch(this.indices, 0, this.nonzeroElements, featureId);
        double[] featVals = new double[6];
        if (search >= 0) {
            featVals[0] = this.ranking[search];
            featVals[1] = this.tfIdfValues[search];
            featVals[2] = this.firstPositions[search];
            featVals[3] = this.probabilities[search];
            featVals[4] = this.isNE[search] ? 1.0 : 0.0;
            featVals[5] = this.frequencies[search];
        }
        return featVals;
    }

    public int searchRankingFor(int featureId) {
        int search = Arrays.binarySearch(this.indices, 0, this.nonzeroElements, featureId);
        return this.getValueAt(search, this.ranking);
    }

    public double searchTfIdfFor(int featureId) {
        int search = Arrays.binarySearch(this.indices, 0, this.nonzeroElements, featureId);
        return this.getValueAt(search, this.tfIdfValues);
    }

    public double searchFirstPositionFor(int featureId) {
        int search = Arrays.binarySearch(this.indices, 0, this.nonzeroElements, featureId);
        return search < 0 ? -1.0 : this.firstPositions[search];
    }

    public double searchProbabilityFor(int featureId) {
        int search = Arrays.binarySearch(this.indices, 0, this.nonzeroElements, featureId);
        return this.getValueAt(search, this.probabilities);
    }

    public boolean searchNEnessFor(int featureId) {
        int search = Arrays.binarySearch(this.indices, 0, this.nonzeroElements, featureId);
        return this.getValueAt(search, this.isNE);
    }

    public double searchRelativeFrequencyFor(int featureId) {
        int search = Arrays.binarySearch(this.indices, 0, this.nonzeroElements, featureId);
        return (double)this.getValueAt(search, this.frequencies) / (double)this.documentLength;
    }

    public int searchFrequencyFor(int featureId) {
        int search = Arrays.binarySearch(this.indices, 0, this.nonzeroElements, featureId);
        return this.getValueAt(search, this.frequencies);
    }

    public int getValueAt(int index, int[] values) {
        return index < 0 ? 0 : values[index];
    }

    private double getValueAt(int index, double[] values) {
        return index < 0 ? 0.0 : values[index];
    }

    private boolean getValueAt(int index, boolean[] values) {
        return index < 0 ? false : values[index];
    }

    public int getDocumentLength() {
        return this.documentLength;
    }

    public int setFeatureValAt(int featureId, int rank, double tfIdf, double firstOccurrence, double probability, int freq) {
        return this.setFeatureValAt(featureId, rank, tfIdf, firstOccurrence, probability, freq, false);
    }

    public int setFeatureValAt(int featureId, int rank, double tfIdf, double firstOccurrence, double probability, int freq, boolean ne) {
        int index = Arrays.binarySearch(this.indices, 0, this.nonzeroElements, featureId);
        if (index < 0) {
            index = Math.abs(index) - 1;
            ++this.nonzeroElements;
            if (this.nonzeroElements == this.indices.length) {
                this.indices = Arrays.copyOf(this.indices, 2 * this.nonzeroElements);
                this.ranking = Arrays.copyOf(this.ranking, 2 * this.nonzeroElements);
                this.tfIdfValues = Arrays.copyOf(this.tfIdfValues, 2 * this.nonzeroElements);
                this.firstPositions = Arrays.copyOf(this.firstPositions, 2 * this.nonzeroElements);
                this.probabilities = Arrays.copyOf(this.probabilities, 2 * this.nonzeroElements);
                this.isNE = Arrays.copyOf(this.isNE, 2 * this.nonzeroElements);
                this.frequencies = Arrays.copyOf(this.frequencies, 2 * this.frequencies.length);
            }
            if (this.indices[index] != 0) {
                System.arraycopy(this.indices, index, this.indices, index + 1, this.indices.length - index - 1);
                System.arraycopy(this.ranking, index, this.ranking, index + 1, this.ranking.length - index - 1);
                System.arraycopy(this.tfIdfValues, index, this.tfIdfValues, index + 1, this.tfIdfValues.length - index - 1);
                System.arraycopy(this.firstPositions, index, this.firstPositions, index + 1, this.firstPositions.length - index - 1);
                System.arraycopy(this.probabilities, index, this.probabilities, index + 1, this.probabilities.length - index - 1);
                System.arraycopy(this.isNE, index, this.isNE, index + 1, this.isNE.length - index - 1);
                System.arraycopy(this.frequencies, index, this.frequencies, index + 1, this.frequencies.length - index - 1);
            }
            this.indices[index] = featureId;
        }
        this.ranking[index] = rank;
        this.tfIdfValues[index] = tfIdf;
        this.firstPositions[index] = firstOccurrence;
        this.probabilities[index] = probability;
        this.isNE[index] = this.isNE[index] || ne;
        this.frequencies[index] = freq;
        return index;
    }

    public int[] getIndices() {
        return this.indices;
    }

    public int[] getRanking() {
        return this.ranking;
    }

    public double[] getTfIdfs() {
        return this.tfIdfValues;
    }

    public double[] getFirstPositions() {
        return this.firstPositions;
    }

    public double[] getProbabilities() {
        return this.probabilities;
    }

    public boolean[] getNEs() {
        return this.isNE;
    }

    public int[] getFrequencies() {
        return this.frequencies;
    }

    public void finalizeData() {
        this.finalizeData(new ArrayList<Integer>());
    }

    private void finalizeData(List<Integer> toRemove) {
        this.nonzeroElements -= toRemove.size();
        int[] newIndices = new int[this.nonzeroElements];
        int[] newRanking = new int[this.nonzeroElements];
        double[] newTfIdfValues = new double[this.nonzeroElements];
        double[] newFirtsPositions = new double[this.nonzeroElements];
        double[] newProbabilities = new double[this.nonzeroElements];
        boolean[] newIsNE = new boolean[this.nonzeroElements];
        int removals = 0;
        int i = 0;
        while (i < this.nonzeroElements + toRemove.size()) {
            if (removals < toRemove.size() && toRemove.get(removals) == this.indices[i]) {
                ++removals;
            } else {
                newIndices[i - removals] = this.indices[i];
                newRanking[i - removals] = this.ranking[i];
                newTfIdfValues[i - removals] = this.tfIdfValues[i];
                newFirtsPositions[i - removals] = this.firstPositions[i];
                newProbabilities[i - removals] = this.probabilities[i];
                newIsNE[i - removals] = this.isNE[i];
            }
            ++i;
        }
        this.indices = newIndices;
        this.ranking = newRanking;
        this.tfIdfValues = newTfIdfValues;
        this.firstPositions = newFirtsPositions;
        this.probabilities = newProbabilities;
        this.isNE = newIsNE;
    }

    public List<Integer> finalizeData(int tokensProcessed, int lastTabooWordPosition) {
        ArrayList<Integer> elementsToRemove = new ArrayList<Integer>();
        if (lastTabooWordPosition < Integer.MAX_VALUE) {
            int f = 0;
            while (f < this.nonzeroElements) {
                if (this.firstPositions[f] >= (double)lastTabooWordPosition) {
                    elementsToRemove.add(this.indices[f]);
                }
                ++f;
            }
        }
        this.finalizeData(elementsToRemove);
        this.documentLength = tokensProcessed;
        int i = 0;
        while (i < this.nonzeroElements) {
            if (this.firstPositions[i] > 1.0 || this.probabilities[i] > 1.0) {
                this.firstPositions[i] = 1.0 - this.firstPositions[i] / (double)tokensProcessed;
                int n = i;
                this.probabilities[n] = this.probabilities[n] / (double)tokensProcessed;
            }
            ++i;
        }
        return elementsToRemove;
    }

    public int getNonzeroElements() {
        return this.nonzeroElements;
    }

    public void setDocumentLength(int dl) {
        this.documentLength = dl;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("indices:");
        int i = 0;
        while (i < this.nonzeroElements) {
            sb.append(String.valueOf(this.indices[i]) + ",");
            ++i;
        }
        sb.append("\nvalues:");
        i = 0;
        while (i < this.nonzeroElements) {
            sb.append(String.valueOf(this.ranking[i]) + ",");
            ++i;
        }
        return String.valueOf(this.title) + "\n" + sb.toString() + "\n";
    }

    /*
     * Unable to fully structure code
     */
    public double getCosineSimilarity(SparseDocument other, int weightingType) {
        lengthA = 0.0;
        lengthB = 0.0;
        overlap = 0.0;
        ii = 0;
        oi = 0;
        while (ii < this.indices.length && oi < other.indices.length) {
            if (weightingType > 2) {
                scoreI = this.tfIdfValues[ii] / this.probabilities[ii];
                scoreO = other.tfIdfValues[oi] / other.probabilities[oi];
            } else {
                v0 = weightingType == 0 ? this.probabilities[ii] : (scoreI = weightingType == 1 ? 1.0 : this.tfIdfValues[ii]);
                v1 = weightingType == 0 ? other.probabilities[oi] : (scoreO = weightingType == 1 ? 1.0 : other.tfIdfValues[oi]);
            }
            if (this.indices[ii] == other.indices[oi]) {
                overlap += scoreI * scoreO;
                lengthA += scoreI * scoreI;
                lengthB += scoreO * scoreO;
            } else if (this.indices[ii] > other.indices[oi]) {
                --ii;
                lengthB += scoreO * scoreO;
            } else {
                --oi;
                lengthA += scoreI * scoreI;
            }
            ++ii;
            ++oi;
        }
        if (overlap != 0.0) ** GOTO lbl32
        return overlap;
lbl-1000:
        // 1 sources

        {
            score = weightingType > 2 ? this.tfIdfValues[ii] / this.probabilities[ii] : (weightingType == 0 ? this.probabilities[ii] : (weightingType == 1 ? 1.0 : this.tfIdfValues[ii]));
            lengthA += score * score;
            ++ii;
lbl32:
            // 2 sources

            ** while (ii < this.nonzeroElements)
        }
lbl33:
        // 2 sources

        while (oi < other.nonzeroElements) {
            score = weightingType > 2 ? other.tfIdfValues[oi] / other.probabilities[oi] : (weightingType == 0 ? other.probabilities[oi] : (weightingType == 1 ? 1.0 : other.tfIdfValues[oi]));
            lengthB += score * score;
            ++oi;
        }
        return overlap / (Math.sqrt(lengthA) * Math.sqrt(lengthB));
    }
}

