/*
 * Decompiled with CFR 0.152.
 */
package dummy.name.nlputils;

import java.util.Arrays;

public class SparseKeyphrase {
    private String name;
    private int[] docIds;
    private int[] rankings;
    private int nonzeroElements;

    public SparseKeyphrase() {
        this(10);
    }

    public SparseKeyphrase(int numAttributes) {
        this.rankings = new int[numAttributes];
        this.docIds = new int[numAttributes];
    }

    public SparseKeyphrase(String id) {
        this(id, 10);
    }

    public SparseKeyphrase(String id, int numAttributes) {
        this(numAttributes);
        this.name = id;
    }

    public String getName() {
        return this.name;
    }

    public double getRankingAt(int featureId) {
        int search = Arrays.binarySearch(this.docIds, 0, this.nonzeroElements, featureId);
        return search < 0 ? 0.0 : (double)this.rankings[search];
    }

    public void setFeatureValAt(int docId, int ranking) {
        int index = Arrays.binarySearch(this.docIds, 0, this.nonzeroElements, docId);
        if (index < 0) {
            index = Math.abs(index) - 1;
            ++this.nonzeroElements;
            if (this.nonzeroElements == this.docIds.length) {
                this.docIds = Arrays.copyOf(this.docIds, 2 * this.nonzeroElements);
                this.rankings = Arrays.copyOf(this.rankings, 2 * this.nonzeroElements);
            }
            if (this.docIds[index] != 0) {
                System.arraycopy(this.docIds, index, this.docIds, index + 1, this.docIds.length - index - 1);
                System.arraycopy(this.rankings, index, this.rankings, index + 1, this.rankings.length - index - 1);
            }
            this.docIds[index] = docId;
            this.rankings[index] = ranking;
        }
    }

    public int[] getDocIndices() {
        return this.docIds;
    }

    public int[] getRankings() {
        return this.rankings;
    }

    public int getNonzeroElements() {
        return this.nonzeroElements;
    }

    public void removeLastlyAdded() {
        this.docIds[--this.nonzeroElements] = 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("indices:");
        int i = 0;
        while (i < this.nonzeroElements) {
            sb.append(String.valueOf(this.docIds[i]) + ",");
            ++i;
        }
        sb.append("\nvalues:");
        i = 0;
        while (i < this.nonzeroElements) {
            sb.append(String.valueOf(this.rankings[i]) + ",");
            ++i;
        }
        return String.valueOf(this.name) + "\n" + sb.toString() + "\n";
    }

    public void reset() {
        this.rankings = new int[10];
        this.docIds = new int[10];
        this.nonzeroElements = 0;
    }

    public Object clone() {
        return new SparseKeyphrase(this.name);
    }
}

