/*
 * Decompiled with CFR 0.152.
 */
package dummy.name.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.LinkedList;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularValueDecomposition;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public class PCA {
    private int dimensionsToShrink;
    private RealMatrix reducerMtx;
    private SingularValueDecomposition svd;
    private static final boolean DEBUG = false;

    public PCA(double[][] mtx) {
        this(mtx, 3);
    }

    public PCA(double[][] mtx, int dts) {
        this.featureScaling(mtx);
        this.dimensionsToShrink = Math.min(mtx[0].length, dts);
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(mtx.length, mtx[0].length);
        int r = 0;
        while (r < mtx.length) {
            int c = 0;
            while (c < mtx[r].length) {
                matrix.setEntry(r, c, mtx[r][c]);
                ++c;
            }
            ++r;
        }
        RealMatrix covMatrix = matrix.transpose().multiply(matrix);
        this.svd = new SingularValueDecomposition(covMatrix);
        this.reducerMtx = this.svd.getU().getSubMatrix(0, covMatrix.getRowDimension() - 1, 0, this.dimensionsToShrink - 1);
    }

    private void featureScaling(double[][] m) {
        int c = 0;
        while (c < m[0].length) {
            double[] col = new double[m.length];
            int r = 0;
            while (r < m.length) {
                col[r] = m[r][c];
                ++r;
            }
            DescriptiveStatistics stat = new DescriptiveStatistics(col);
            double mean = stat.getMean();
            double stDev = stat.getStandardDeviation();
            int i = 0;
            while (i < col.length) {
                m[i][c] = (col[i] - mean) / stDev;
                ++i;
            }
            ++c;
        }
    }

    public double[] reduce(double[] vector) {
        return this.reducerMtx.preMultiply(vector);
    }

    public double[][] matrixToCosines(double[][] mtx, boolean toCosine) {
        double[][] reducedRepresentation = new double[mtx[0].length][this.dimensionsToShrink];
        int r = 0;
        while (r < mtx[0].length) {
            double[] dataPoint = mtx[r];
            ArrayRealVector projectedForm = new ArrayRealVector(this.reduce(dataPoint));
            double length = ((RealVector)projectedForm).getNorm();
            int i = 0;
            while (i < this.dimensionsToShrink) {
                double reducedValue = ((RealVector)projectedForm).getEntry(i);
                reducedRepresentation[r][i] = reducedValue / (toCosine ? length : 1.0);
                ++i;
            }
            ++r;
        }
        return reducedRepresentation;
    }

    public void printMatrix(RealMatrix rm) {
        int r = 0;
        while (r < rm.getRowDimension()) {
            System.err.println(rm.getRowVector(r));
            ++r;
        }
        System.err.println("-----------------");
    }

    public static void main(String[] args) {
        Object mtx = new double[][]{{3.0, 2.0, 10.0, 1.0}, {2.0, 2.0, 3.0, 2.0}, {10.0, 3.0, 2.0, 3.0}, {5.0, 9.0, 0.0, 3.0}, {6.0, 1.0, 1.0, 0.0}};
        mtx = new double[50][200];
        int dimensionToReduce = 1;
        LinkedList<String> lines = new LinkedList<String>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream("/home/berend/tudomany/egyetem/gyakorlatok/stanford/ml/2dPCA.txt")));){
                String line;
                while ((line = br.readLine()) != null) {
                    lines.add(line);
                }
                int numOfInstances = lines.size();
                dimensionToReduce = 1;
                mtx = new double[numOfInstances][2];
                int k = 0;
                for (String l : lines) {
                    String[] parts = l.trim().split("\\s+");
                    int p = 0;
                    while (p < parts.length) {
                        mtx[k][p] = Double.parseDouble(parts[p]);
                        ++p;
                    }
                    ++k;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        PCA pca = new PCA((double[][])mtx, dimensionToReduce);
        double[][] mtxTranspose = new double[mtx[0].length][((double[][])mtx).length];
        int i = 0;
        while (i < ((double[][])mtx).length) {
            int j = 0;
            while (j < mtx[i].length) {
                mtxTranspose[j][i] = mtx[i][j];
                ++j;
            }
            ++i;
        }
        double[][] reducedRepresentation = pca.matrixToCosines((double[][])mtx, false);
        int i2 = 0;
        while (i2 < reducedRepresentation.length) {
            int j = 0;
            while (j < reducedRepresentation[0].length) {
                System.err.print(String.valueOf(reducedRepresentation[i2][j]) + "\t");
                ++j;
            }
            System.err.println();
            ++i2;
        }
    }
}

