/*
 * Decompiled with CFR 0.152.
 */
package dummy.name.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class SparseVectors
implements Serializable {
    private static final long serialVersionUID = -4864787481207998642L;
    protected int[][] neighbors;
    protected double[][] weights;
    protected int numEdges;

    public SparseVectors(int[] n, double[] w, int maxNeighbors) {
        int numOfNodes = n.length / maxNeighbors;
        HashMap[] nodeNeighbors = new HashMap[numOfNodes];
        int i = 0;
        while (i < n.length) {
            int fromNode = i / maxNeighbors;
            double weight = w[i];
            if (weight > 0.0) {
                int toNode;
                if (nodeNeighbors[fromNode] == null) {
                    nodeNeighbors[fromNode] = new HashMap();
                }
                if (nodeNeighbors[toNode = n[i]] == null) {
                    nodeNeighbors[toNode] = new HashMap();
                }
                ++this.numEdges;
                nodeNeighbors[fromNode].put(toNode, weight);
                nodeNeighbors[toNode].put(fromNode, weight);
            }
            ++i;
        }
        this.neighbors = new int[numOfNodes][];
        this.weights = new double[numOfNodes][];
        i = 0;
        while (i < numOfNodes) {
            HashMap edgesFromNode = nodeNeighbors[i];
            if (edgesFromNode != null) {
                this.neighbors[i] = new int[edgesFromNode.size()];
                this.weights[i] = new double[edgesFromNode.size()];
                int j = 0;
                for (Map.Entry edge : edgesFromNode.entrySet()) {
                    this.neighbors[i][j] = (Integer)edge.getKey();
                    this.weights[i][j] = (Double)edge.getValue();
                    ++j;
                }
            }
            ++i;
        }
    }

    public SparseVectors(double[][] fullMatrix) {
        this.neighbors = new int[fullMatrix.length][];
        this.weights = new double[fullMatrix.length][];
        int r = 0;
        while (r < fullMatrix.length) {
            LinkedList<Integer> neighborsList = new LinkedList<Integer>();
            LinkedList<Double> values = new LinkedList<Double>();
            int c = 0;
            while (c < fullMatrix.length) {
                if (fullMatrix[r][c] != 0.0) {
                    neighborsList.add(c);
                    values.add(fullMatrix[r][c]);
                    ++this.numEdges;
                }
                ++c;
            }
            int[] neighborArray = new int[neighborsList.size()];
            int ni = 0;
            for (Integer n : neighborsList) {
                neighborArray[ni++] = n;
            }
            double[] valueArray = new double[values.size()];
            int vi = 0;
            for (Double v : values) {
                valueArray[vi++] = v;
            }
            this.neighbors[r] = neighborArray;
            this.weights[r] = valueArray;
            ++r;
        }
    }

    public Map<Integer, Integer> degreeDistribution() {
        TreeMap<Integer, Integer> degrees = new TreeMap<Integer, Integer>();
        int[][] nArray = this.neighbors;
        int n = this.neighbors.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int[] neighborIndices = nArray[n2];
            Integer prevValue = (Integer)degrees.get(neighborIndices.length);
            Integer n4 = neighborIndices.length;
            if (prevValue == null) {
                n3 = 1;
            } else {
                prevValue = prevValue + 1;
                n3 = prevValue;
            }
            degrees.put(n4, n3);
            ++n2;
        }
        return degrees;
    }

    public int getEdges() {
        return this.numEdges;
    }

    public void serialize(String fileName) {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
            out.writeObject(this);
            out.flush();
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static double[][] deserializeIntoFullMatrix(String fileName) {
        double[][] fullMatrix = null;
        try {
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(fileName)));
            SparseVectors obj = (SparseVectors)in.readObject();
            in.close();
            int[][] neighs = obj.neighbors;
            double[][] ws = obj.weights;
            fullMatrix = new double[neighs.length][neighs.length];
            int n = 0;
            while (n < neighs.length) {
                int[] nn = neighs[n];
                double[] w = ws[n];
                int i = 0;
                while (nn != null && i < nn.length) {
                    fullMatrix[n][nn[i]] = w[i];
                    ++i;
                }
                ++n;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fullMatrix;
    }

    public void printToFile(String fileName) {
        try {
            PrintWriter out = new PrintWriter(fileName);
            int i = 0;
            while (i < this.neighbors.length) {
                int[] neigh = this.neighbors[i];
                double[] w = this.weights[i];
                int j = 0;
                while (neigh != null && j < neigh.length) {
                    out.print(String.valueOf(neigh[j]) + " " + w[j] + " ");
                    ++j;
                }
                out.println();
                ++i;
            }
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        File[] fileArray = new File("C://data/keyphrase_corpora/stackoverflow/forVisualization/").listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getName().contains("neighbors-1_threshold-10_metric-PROBABILITY_calculation-MIN_stackoverflow.ser") && f.getName().endsWith(".ser")) {
                SparseVectors sv = new SparseVectors(SparseVectors.deserializeIntoFullMatrix(f.getAbsolutePath()));
                System.err.println(f + "\t" + sv.getEdges());
            }
            ++n2;
        }
    }
}

