/*
 * Copyright (C) 1984-2000  Mark Nudelman
 *
 * You may distribute under the terms of either the GNU General Public
 * License or the Less License, as specified in the README file.
 *
 * For more information about less, or for information on how to 
 * contact the author, see the README file.
 */


/*
 * Routines dealing with signals.
 *
 * A signal usually merely causes a bit to be set in the "signals" word.
 * At some convenient time, the mainline code checks to see if any
 * signals need processing by calling psignal().
 * If we happen to be reading from a file [in iread()] at the time
 * the signal is received, we call intread to interrupt the iread.
 */

#include "less.h"
#include <signal.h>

/*
 * "sigs" contains bits indicating signals which need to be processed.
 */
public int sigs;

extern int sc_width, sc_height;
extern int screen_trashed;
extern int lnloop;
extern int linenums;
extern int wscroll;
extern int reading;

/*
 * Interrupt signal handler.
 */
        /* ARGSUSED*/
        static RETSIGTYPE
u_interrupt(
        int type)
{
        LSIGNAL(SIGINT, u_interrupt);
        sigs |= S_INTERRUPT;
        if (reading)
                intread();
}

#if MSDOS_COMPILER==WIN32C
/*
 * Handle CTRL-C and CTRL-BREAK keys.
 */
/*include "windows.h"*/

typedef unsigned short wchar_t;
typedef unsigned long       DWORD;
typedef unsigned short      WORD;
typedef short SHORT;
typedef void *HANDLE;
typedef int                 BOOL;
typedef DWORD            *LPDWORD;
typedef void             *LPVOID;
typedef wchar_t WCHAR;    
typedef unsigned int        UINT;
typedef char CHAR;
typedef long LONG;
typedef WORD *LPWORD;


typedef
BOOL
(__stdcall *PHANDLER_ROUTINE)(
    DWORD CtrlType
    );


__declspec(dllimport)
BOOL
__stdcall
SetConsoleCtrlHandler(
    PHANDLER_ROUTINE HandlerRoutine,
    BOOL Add
    );









        static BOOL __stdcall 
wbreak_handler(
        DWORD dwCtrlType)
{
        switch (dwCtrlType)
        {
        case 0:
        case 1:
                sigs |= 01;
                return (1);
        default:
                break;
        }
        return (0);
}
#endif

/*
 * Set up the signal handlers.
 */
        public void
init_signals(
        int on)
{
        if (on)
        {
                /*
                 * Set signal handlers.
                 */
                (void) signal(2,u_interrupt);
                SetConsoleCtrlHandler(wbreak_handler, 1);
        } else {
                /*
                 * Restore signals to defaults.
                 */
                (void) signal(2,(void (__cdecl *)(int))0);
                SetConsoleCtrlHandler(wbreak_handler, 0);
        }
}

/*
 * Process any signals we have received.
 * A received signal cause a bit to be set in "sigs".
 */
        public void
psignals()
{
        register int tsignals;

        if ((tsignals = sigs) == 0)
                return;
        sigs = 0;

        if (tsignals & S_WINCH)
        {
                int old_width, old_height;
                /*
                 * Re-execute scrsize() to read the new window size.
                 */
                old_width = sc_width;
                old_height = sc_height;
                get_term();
                if (sc_width != old_width || sc_height != old_height)
                {
                        wscroll = (sc_height + 1) / 2;
                        screen_trashed = 1;
                }
        }
        if (tsignals & S_INTERRUPT)
        {
                bell();
                /*
                 * {{ You may wish to replace the bell() with 
                 *    error("Interrupt", NULL_PARG); }}
                 */

                /*
                 * If we were interrupted while in the "calculating 
                 * line numbers" loop, turn off line numbers.
                 */
                if (lnloop)
                {
                        lnloop = 0;
                        if (linenums == 2)
                                screen_trashed = 1;
                        linenums = 0;
                        error("Line numbers turned off", NULL_PARG);
                }

        }
}
