/*
 * Copyright (C) 1984-2000  Mark Nudelman
 *
 * You may distribute under the terms of either the GNU General Public
 * License or the Less License, as specified in the README file.
 *
 * For more information about less, or for information on how to 
 * contact the author, see the README file.
 */


/*
 * Routines dealing with getting input from the keyboard (i.e. from the user).
 */

#include "less.h"

/* windows.h begin */
typedef int                 BOOL;
typedef unsigned long       DWORD;
typedef DWORD            *LPDWORD;
typedef void             *LPVOID;
typedef char CHAR;
typedef const CHAR *LPCSTR, *PCSTR;
typedef void *HANDLE;
typedef struct _SECURITY_ATTRIBUTES {
    DWORD nLength;
    LPVOID lpSecurityDescriptor;
    BOOL bInheritHandle;
} SECURITY_ATTRIBUTES, *PSECURITY_ATTRIBUTES, *LPSECURITY_ATTRIBUTES;

__declspec(dllimport)
HANDLE
__stdcall CreateFileA(
    LPCSTR lpFileName,
    DWORD dwDesiredAccess,
    DWORD dwShareMode,
    LPSECURITY_ATTRIBUTES lpSecurityAttributes,
    DWORD dwCreationDisposition,
    DWORD dwFlagsAndAttributes,
    HANDLE hTemplateFile
);

__declspec(dllimport)
BOOL
__stdcall
GetConsoleMode(
    HANDLE hConsoleHandle,
    LPDWORD lpMode
    );

__declspec(dllimport)
BOOL
__stdcall
SetConsoleMode(
    HANDLE hConsoleHandle,
    DWORD dwMode
    );

__declspec(dllimport)
BOOL
__stdcall
CloseHandle(
    HANDLE hObject
    );

/* windows.h end */


extern char WIN32getch(int);
static DWORD console_mode;
static int tty;
extern int sigs;

/*
 * Open keyboard for input.
 */
        public void
open_getchr()
{
        /* Need this to let child processes inherit our console handle */
        SECURITY_ATTRIBUTES sa;
        memset(&sa, 0, sizeof(SECURITY_ATTRIBUTES));
        sa.nLength = sizeof(SECURITY_ATTRIBUTES);
        sa.bInheritHandle = TRUE;
	tty = (int) CreateFileA("CONIN$", (0x80000000L),
			0x00000001, &sa, 
			3, 0L, ((void *)0));
        GetConsoleMode((HANDLE)tty, &console_mode);
        /* Make sure we get Ctrl+C events. */
	SetConsoleMode((HANDLE)tty, 0x0001);
}

/*
 * Close the keyboard.
 */
        public void
close_getchr()
{
        SetConsoleMode((HANDLE)tty, console_mode);
        CloseHandle((HANDLE)tty);
}

/*
 * Get a character from the keyboard.
 */
public int getchr() {
        char c;
        int result;

        do
        {
                /*
                 * In raw read, we don't see ^C so look here for it.
                 */

                flush();
                if (ABORT_SIGS())
                        return (READ_INTR);
                c = WIN32getch(tty);
                result = 1;
                if (c == '\003')
                        return (READ_INTR);

                /*
                 * Various parts of the program cannot handle
                 * an input character of '\0'.
                 * If a '\0' was actually typed, convert it to '\340' here.
                 */
                if (c == '\0')
                        c = '\340';
        } while (result != 1);

        return (c & 0377);
}

