/* Graph-N-Go SAS/Graph Code Generation for
**
**    Viewer:      Bar Chart 2 12NOV2010 10:08:52
**    Description: Bar Chart 2
**    Modified:    12NOV2010:10:13:38
**
** SAS products required: Base, SAS/Graph (Version 9 or later)
** Code generated on: 12NOV2010  12:57:06
**
** There may be differences in appearance of the graph
** generated by the code below and the Graph-N-Go viewer.
**
** To make code modifications consult the documentation
** for these statements: ODS, GCHART, GPLOT,
** GOPTIONS, AXIS, LEGEND, SYMBOL, TITLE, FOOTNOTE.
**
** To route output to a graphics device other than your monitor,
** modify the source code below to change the device driver by
**   1) removing the asterisk preceding GOPTIONS DEVICE=JAVA;
**   2) changing JAVA to some other valid device.
**
** To create an HTML file, modify the source code below
** to enable ODS output by
**   1) removing the asterisks from the ODS statments and
**      the asterisk preceding GOPTIONS DEVICE=JAVA;
**   2) setting the value of DEVICE= to GIF, JAVAIMG, ACTXIMG,
**      JAVA, or ACTIVEX (JAVA and ACTIVEX create interactive graphs)
**   3) verifying or changing the ODS FILE= option so it names the
**      HTML file for output.
**   4) verifying or changing the ODS GPATH= option so it names the
**      path for the GIF or JPG file displayed by the HTML page. This
**      option is not necessary if the DEVICE is ACTIVEX or JAVA.
*/


/* Begin ODS output */
* ods listing close;
* ods html file="output-HTML-file-specification" (title="Graph-N-Go Output")
           gpath="output-image-path-specification" gtitle gfootnote style=minimal;


/* Set the SAS/Graph options */
goptions reset=all
         ctext=CX800080 ftext="MS Sans Serif" htext=8 pt
         colors=(CX13967A CX4175B0 CXFFE4AB CXFF7370
                 CX204776 CXDD9B2B CXE64E4B CXA5A5A5
                 CX754B25 CXD63A3C CX688CD6 CXFFFFFF
                 CX444444 CXB92C2C CX008080 CXFDDD53);


/* Set the Titles/Footnotes */
title1 justify=center color=CX000000 font="MS Sans Serif" height=8 pt "Type grouped by Origin";
footnote1 justify=center color=CX000000 font="MS Sans Serif" height=8 pt "SAS GNG gyakorlat";


/* Set the SAS/Graph device driver */
* goptions device=JAVA xpixels=497 ypixels=360;

/* AXIS1 describes axis for Category variable TYPE */
/* AXIS2 describes axis for Response statistic FREQ */
axis1 minor=none noplane label=("Type") ;
axis2 minor=none noplane label=("(Frequency)")
      order=(0 to 100 by 20) ;

proc gchart data=SASHELP.CARS;
   vbar3d TYPE /
        type=FREQ   shape=BLOCK
        maxis=axis1 noframe
        woutline=1 coutline=CX000000 caxis=CX000000
        raxis=axis2  group=ORIGIN G100  ;
run;
quit;


/* Reset all graphics options */
goptions reset=all;


/* End ODS output */
* ods html close;
* ods listing;
