/* Graph-N-Go SAS/Graph Code Generation for
**
**    Viewer:      Pie Chart 1 12NOV2010 12:34:25
**    Description: Pie Chart 1
**    Modified:    12NOV2010:12:35:30
**
** SAS products required: Base, SAS/Graph (Version 9 or later)
** Code generated on: 12NOV2010  12:57:21
**
** There may be differences in appearance of the graph
** generated by the code below and the Graph-N-Go viewer.
**
** To make code modifications consult the documentation
** for these statements: ODS, GCHART, GPLOT,
** GOPTIONS, AXIS, LEGEND, SYMBOL, TITLE, FOOTNOTE.
**
** To route output to a graphics device other than your monitor,
** modify the source code below to change the device driver by
**   1) removing the asterisk preceding GOPTIONS DEVICE=JAVA;
**   2) changing JAVA to some other valid device.
**
** To create an HTML file, modify the source code below
** to enable ODS output by
**   1) removing the asterisks from the ODS statments and
**      the asterisk preceding GOPTIONS DEVICE=JAVA;
**   2) setting the value of DEVICE= to GIF, JAVAIMG, ACTXIMG,
**      JAVA, or ACTIVEX (JAVA and ACTIVEX create interactive graphs)
**   3) verifying or changing the ODS FILE= option so it names the
**      HTML file for output.
**   4) verifying or changing the ODS GPATH= option so it names the
**      path for the GIF or JPG file displayed by the HTML page. This
**      option is not necessary if the DEVICE is ACTIVEX or JAVA.
*/


/* Begin ODS output */
* ods listing close;
* ods html file="output-HTML-file-specification" (title="Graph-N-Go Output")
           gpath="output-image-path-specification" gtitle gfootnote style=minimal;


/* Set the SAS/Graph options */
goptions reset=all border
         ctext=CX000000 ftext="MS Sans Serif" htext=8 pt
         colors=(CXFF8283 CX00BDAF CXAD8961 CXCD0369
                 CX009393 CXFFFFFF CX5B768D CX00FFFF
                 CXEC739B CX335580 CXFFB445 CX969696
                 CX008080 CXFFB4B4 CX2E734F CXFFA300);


/* Set the Titles/Footnotes */
title4 justify=left color=CX000000 font="MS Sans Serif" height=8 pt "(Frequency)";


/* Set the SAS/Graph device driver */
* goptions device=JAVA xpixels=441 ypixels=306;


/* LEGEND1 specifies the pie legend */
legend1 across=1 cborder=CX000000
        label=(justify=center position=(top center) "Type")
        position=(middle right) value=(justify=left);

proc gchart data=SASHELP.CARS;
   pie3d TYPE /
        type=FREQ   angle=0 value=outside slice=none
        fill=solid   otherlabel="Other"
        woutline=1 coutline=CX000000 ctext=CX000000
        noheading legend=legend1 ;
run;
quit;


/* Reset all graphics options */
goptions reset=all;


/* End ODS output */
* ods html close;
* ods listing;
