/* Graph-N-Go SAS/Graph Code Generation for
**
**    Viewer:      Plot 1 12NOV2010 12:35:45
**    Description: Plot 1
**    Modified:    12NOV2010:12:36:57
**
** SAS products required: Base, SAS/Graph (Version 9 or later)
** Code generated on: 12NOV2010  12:57:37
**
** There may be differences in appearance of the graph
** generated by the code below and the Graph-N-Go viewer.
**
** To make code modifications consult the documentation
** for these statements: ODS, GCHART, GPLOT,
** GOPTIONS, AXIS, LEGEND, SYMBOL, TITLE, FOOTNOTE.
**
** To route output to a graphics device other than your monitor,
** modify the source code below to change the device driver by
**   1) removing the asterisk preceding GOPTIONS DEVICE=JAVA;
**   2) changing JAVA to some other valid device.
**
** To create an HTML file, modify the source code below
** to enable ODS output by
**   1) removing the asterisks from the ODS statments and
**      the asterisk preceding GOPTIONS DEVICE=JAVA;
**   2) setting the value of DEVICE= to GIF, JAVAIMG, ACTXIMG,
**      JAVA, or ACTIVEX (JAVA and ACTIVEX create interactive graphs)
**   3) verifying or changing the ODS FILE= option so it names the
**      HTML file for output.
**   4) verifying or changing the ODS GPATH= option so it names the
**      path for the GIF or JPG file displayed by the HTML page. This
**      option is not necessary if the DEVICE is ACTIVEX or JAVA.
*/


/* Begin ODS output */
* ods listing close;
* ods html file="output-HTML-file-specification" (title="Graph-N-Go Output")
           gpath="output-image-path-specification" gtitle gfootnote style=minimal;


/* Set the SAS/Graph options */
goptions reset=all border
         ctext=CX000000 ftext="MS Sans Serif" htext=8 pt
         colors=(CX0000FF CXFF0000 CX008080 CX00FF00
                 CXFF00FF CXFFFF00 CX00FFFF CX800000
                 CX008000 CX800080 CX000080 CX808000
                 CXFFFFFF CX808080 CXC0C0C0 CX000000);


/* Set the SAS/Graph device driver */
* goptions device=JAVA xpixels=485 ypixels=340;

/* AXIS1 describes the X-axis (horizontal) */
axis1 minor=none label=("MPG (City)")  ;

/* AXIS2 describes the Y-axis (vertical)   */
axis2 minor=none label=("Engine Size (L)")
      order=(0 to 10 by 2) ;


/* SYMBOL1 specifies SCATTER and primary marker style, size and color */
symbol1 line=1 ci=CX0000FF cv=CX0000FF value=Dot  width=1 height=6 pt;

proc gplot data=SASHELP.CARS;
   plot ENGINESIZE*MPG_CITY /
      haxis=axis1 vaxis=axis2
      cframe=CXFFFFFF caxis=CX000000;
run;
quit;


/* Reset all graphics options */
goptions reset=all;


/* End ODS output */
* ods html close;
* ods listing;
