/* Graph-N-Go SAS/Graph Code Generation for
**
**    Viewer:      Overlay Plot 1 12NOV2010 12:39:40
**    Description: Overlay Plot 1
**    Modified:    12NOV2010:12:42:58
**
** SAS products required: Base, SAS/Graph (Version 9 or later)
** Code generated on: 12NOV2010  12:57:53
**
** There may be differences in appearance of the graph
** generated by the code below and the Graph-N-Go viewer.
**
** To make code modifications consult the documentation
** for these statements: ODS, GCHART, GPLOT,
** GOPTIONS, AXIS, LEGEND, SYMBOL, TITLE, FOOTNOTE.
**
** To route output to a graphics device other than your monitor,
** modify the source code below to change the device driver by
**   1) removing the asterisk preceding GOPTIONS DEVICE=JAVA;
**   2) changing JAVA to some other valid device.
**
** To create an HTML file, modify the source code below
** to enable ODS output by
**   1) removing the asterisks from the ODS statments and
**      the asterisk preceding GOPTIONS DEVICE=JAVA;
**   2) setting the value of DEVICE= to GIF, JAVAIMG, ACTXIMG,
**      JAVA, or ACTIVEX (JAVA and ACTIVEX create interactive graphs)
**   3) verifying or changing the ODS FILE= option so it names the
**      HTML file for output.
**   4) verifying or changing the ODS GPATH= option so it names the
**      path for the GIF or JPG file displayed by the HTML page. This
**      option is not necessary if the DEVICE is ACTIVEX or JAVA.
*/


/* Begin ODS output */
* ods listing close;
* ods html file="output-HTML-file-specification" (title="Graph-N-Go Output")
           gpath="output-image-path-specification" gtitle gfootnote style=minimal;


/* Set the SAS/Graph options */
goptions reset=all border nodash
         ctext=CX000000 ftext="MS Sans Serif" htext=8 pt
         colors=(CX0000FF CXFF0000 CX008080 CX00FF00
                 CXFF00FF CXFFFF00 CX00FFFF CX800000
                 CX008000 CX800080 CX000080 CX808000
                 CXFFFFFF CX808080 CXC0C0C0 CX000000);


/* Set the SAS/Graph device driver */
* goptions device=JAVA xpixels=540 ypixels=372;

/* AXIS1 describes the X-axis (horizontal)      */
axis1 minor=none label=("Type") color=CX000000 offset=(5pct,5pct) order=("SUV" "Sedan" "Sports" "Wagon" "Truck" "Hybrid");

/* AXIS2 describes the left Y-axis (vertical)   */
axis2 minor=none label=("MPG (City)") color=CX000000 offset=(5pct,5pct);

/* AXIS3 describes the right Y-axis (vertical)   */
axis3 minor=none label=("MPG (Highway)") color=CX000000 offset=(5pct,5pct);

/* Each SYMBOL statement specifies style, size and */
/* color for markers and join lines for an overlay */
symbol1 line=1 width=1 cv=CX0000FF ci=CX0000FF value=Dot interpol=Join height=6 pt;
symbol2 line=20 width=1 cv=CXFF0000 ci=CXFF0000 value=Square interpol=Join height=6 pt;

/* This step removes duplicated values of the X variable */
/* so the output is similar to Graph-N-Go.               */
proc sort data=SASHELP.CARS out=gngtemp nodupkey;
   by TYPE;
run;

proc gplot data=gngtemp;
   plot MPG_CITY*TYPE=1 / nolegend
      haxis=axis1 vaxis=axis2
      cframe=CXFFFFFF caxis=CX000000;
   plot2 MPG_HIGHWAY*TYPE=2 / nolegend vaxis=axis3;
run;
quit;


/* Reset all graphics options */
goptions reset=all;


/* End ODS output */
* ods html close;
* ods listing;
