package annotations;

import java.lang.reflect.Field;

public class AnnotatedEntityBuilder {

	public static Object buildAnnotatedEntity(String className) {
		Object ret = null;
		try {
			Class<?> clazz = Class.forName(className);
			ret = clazz.newInstance();
			for (Field f : clazz.getDeclaredFields()) {
				if (f.isAnnotationPresent(MyAnnotation.class)) {
					MyAnnotation annotation = f.getAnnotation(MyAnnotation.class);
					f.setAccessible(true);
					f.set(ret, annotation.setInitialValue());
				}
			}
		} catch (InstantiationException | IllegalAccessException | ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return ret;
	}
}
