package couchdb.java;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.lightcouch.Changes;
import org.lightcouch.CouchDbClient;
import org.lightcouch.DesignDocument;
import org.lightcouch.DesignDocument.MapReduce;
import org.lightcouch.Response;

/**
 * CouchDB tutorial with lightcouch API
 *
 */
public class App 
{
    public static void main( String[] args ) throws IOException
    {
    	CouchDbClient dbClient = new CouchDbClient(); 

    	Foo foo = new Foo(); // Plain Java Object
    	foo.setIntField(33);
    	foo.setStringField("SSS");

    	Response response = dbClient.save(foo);
    	String docid = response.getId();

		System.out.println(docid);

    	foo = dbClient.find(Foo.class, docid);

    	foo.setStringField("KKK");
    	dbClient.update(foo);


		boolean b = dbClient.contains(foo.get_id());
		System.out.println(b);

		foo = dbClient.find(Foo.class, docid);
		dbClient.remove(foo);

		// views
    	List<Foo> list = dbClient.view("ddoc/by_field")
    	 	.includeDocs(true)
    	 	.query(Foo.class);
    	list.forEach(System.out::println);

    	DesignDocument designDocument = new DesignDocument();
    	designDocument.setId("_design/mydesign");
    	designDocument.setLanguage("javascript");

    	MapReduce getSumOfKKKsMR = new MapReduce();
    	getSumOfKKKsMR.setMap(
    	  "function(doc) { "
    	   + "  emit(doc.stringField, doc.intField)"
    	   + "}");
    	getSumOfKKKsMR.setReduce(
    	  "function (key, values, rereduce) {"
    	    + "return sum(values)"
    	    + "}");

    	Map<String, MapReduce> view = new HashMap<>();
    	view.put("getSumOfKKKs", getSumOfKKKsMR);

    	designDocument.setViews(view);

    	dbClient.design().synchronizeWithDb(designDocument);

    	int count = dbClient.view("mydesign/getSumOfKKKs").key("KKK").queryForInt();
    	System.out.println(count);

    	// shutdown the client
    	dbClient.shutdown();


    }
}
