package couchdb.java;

import org.lightcouch.CouchDbClient;
import org.lightcouch.Response;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Unit test for simple App.
 */
public class AppTest 
    extends TestCase
{
	CouchDbClient dbClient; 
	
	@Override
	public void setUp() {
		dbClient = new CouchDbClient();
	}
	
    /**
     * Create the test case
     *
     * @param testName name of the test case
     */
    public AppTest( String testName )
    {
        super( testName );
    }

    /**
     * @return the suite of tests being tested
     */
    public static Test suite()
    {
        return new TestSuite( AppTest.class );
    }

    /**
     * Test
     */
    public void testApp()
    {
    	Foo foo = new Foo(); // Plain Java Object
    	foo.setIntField(42);
    	foo.setStringField("SSS");

    	Response response = dbClient.save(foo);
    	String docid = response.getId();

    	foo = dbClient.find(Foo.class, docid);
    	
        assertEquals(foo.get_id(), docid);
        
        foo.setStringField("MMM");
    	dbClient.update(foo);
    	
    	Foo foo2 = dbClient.find(Foo.class, docid);
    	
    	assertEquals("MMM", foo2.getStringField());
        
        dbClient.remove(foo2);
    }
}
