/*
 * libidicon.h -- declarations for DICOM handling functions
 * Copyright (c) 1996-98, Laszlo Nyul
 */

/* $Id:$ */

#ifndef __LIBIDICON_H
#define __LIBIDICON_H

#include "idicon.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
  FILE *f;
  char linebuf[257];
  unsigned long linebufpos;
} S_pd_buffer;

typedef struct {
  unsigned short number;
  unsigned short *ewindow;
  unsigned short *detector;
  unsigned short *phase;
  unsigned short *rotation;
  unsigned short *rr;
  unsigned short *tslot;
  unsigned short *slice;
  unsigned short *aview;
  unsigned short *tslice;
} S_vectors;

/* dstrbuf.c */

#define DSTRINGBUFFERSIZE 4096

extern DStringBuffer *InitDStringBuffer PROTO((long allocstep));
extern void DoneDStringBuffer PROTO((DStringBuffer **dsb));
extern char *AddToDStringBuffer PROTO((DStringBuffer *dsb, char *s));

/* dicomdef.c */

#define DEF_PRIVATE 0x0001

/* dicomrd.c */

#define DICM_MAGIC "DICM"

typedef enum {
  ELi_byteString,
  ELi_fixed,
  ELi_maximum,
  ELi_NULL,
  ELi_variable,
  ELi_wordString
} ELi;

typedef struct {
  char name[3];
  T_VR_UL VL;
  ELi Li;
} S_VRTYPES;

extern S_VRTYPES VRTypes[];
extern short DIM_OF_VRTypes;

short fill_pds PROTO((S_AppData *App, DicomObject *O,
        S_PixelData *pds));

short is_in_0028_0009 PROTO((S_AppData *App, DicomObject *O,
        T_VR_US Tag1, T_VR_US Tag2));
void get_Vectors PROTO((S_AppData *App, DicomObject *O, S_vectors *V));
void put_Vectors PROTO((S_AppData *App, DicomObject *O, S_vectors *V));

/* codec.c */

short skip_pixeldata PROTO((FILE *f, S_PixelData **pds, E_TransferSyntax ts,
        T_VR_UL l));
short write_pixeldata PROTO((void *app_private, DicomIOObject *Object,
        S_PixelData *pds));

/* parsedef.c */

S_pd_buffer *pd_init_buffer PROTO((FILE *f));
void pd_done_buffer PROTO((S_pd_buffer **buf));
short pd_skip_expr PROTO((S_pd_buffer *buf, char *expr));
short pd_peek_one_char PROTO((S_pd_buffer *buf));
short pd_match_one_char PROTO((S_pd_buffer *buf, short c));
short pd_skip_comment PROTO((S_pd_buffer *buf));
short pd_skip_spaces PROTO((S_pd_buffer *buf));
short pd_get_char_value PROTO((S_pd_buffer *buf));
short pd_get_string_value PROTO((S_pd_buffer *buf, char *value,
        unsigned long len));
short pd_get_string_value_spcs PROTO((S_pd_buffer *buf, char *value,
        unsigned long len));
short pd_get_short_value PROTO((S_pd_buffer *buf, short *value));
short pd_get_short_value_spcs PROTO((S_pd_buffer *buf, short *value));
short pd_get_hex_value PROTO((S_pd_buffer *buf, unsigned long *value));
short pd_get_hex_value_spcs PROTO((S_pd_buffer *buf,
        unsigned long *value));
short pd_skip_char PROTO((S_pd_buffer *buf, char c));
short pd_skip_char_spcs PROTO((S_pd_buffer *buf, char c));

/* dtconv.c */

void DateFormat_to_DA PROTO((char *from, char *to));
void TimeFormat_to_TM PROTO((char *from, char *to));

/* Image handle*/

typedef struct {
  char *filename;
  unsigned short NumberOfFrames;
  S_CodedFrame **frames;
} S_CodedFrameSet;

typedef struct {
  DicomIOObject *Object;
  S_PixelData *pds;
  S_Codec *coder;
  S_Codec *decoder;
  S_CodecLibrary *coderlib;
  S_CodecLibrary *decoderlib;
  void *coder_private;
  void *decoder_private;
  S_Frame *frame; /* current decoded frame, filled by decoder, passed to coder */
  S_Frame *codedframe; /* input frame, give it to the decoder */
  S_CodedFragment *fragment; /* input frame, give it to the decoder */
  S_CodedFrameSet *frameset; /* output frames, put them in order at the end */
  short totalnumberoffragments;
  S_CodedFragment **sortedfragments;
} S_KernelPrivate;

short native_LibraryInit(void *app_private, char *cmdline) ;
short png_LibraryInit(void *app_private, char *cmdline) ;
void done_kernelprivate(S_KernelPrivate **kp) ;
short init_kernelprivate(S_KernelPrivate **kp, S_AppData *App,
			 DicomIOObject *Object, S_PixelData *pds) ;


/* interfil.c */

#define Interfile_Little_Endian_Transfer_Syntax_ID "Interfile.Little.Endian"
#define Interfile_Big_Endian_Transfer_Syntax_ID "Interfile.Big.Endian"
 
#define YYPARSE_PARAM parm
#define YYLEX_PARAM parm

typedef struct {
  char *key;
  short index;
  char *value;
} keyvalue_value;

typedef struct {
  char *key;
  char *index;
} indexedkey_value;

typedef struct {
  EKT typeofkey;
  char *key;
  char *index;
} keypart_value;

typedef struct {
  int numofvalues;
  char *values[MAXASCIIlist];
} valuelist_value;

typedef struct {
  char *defaultvalue;
  valuelist_value *valuelist;
} valuepart_value;

typedef struct {
  char *key;
  char *valueptr;
} block_value;

typedef struct {
  ECT blockcode;
  char *key;
  char *valueptr;
} blockdef;

typedef struct {
  char *d_Actual_Frame_Duration;
  char *d_Angular_Step;
  char *d_Center_of_Rotation_Offset;
  char *d_Code_Meaning;
  char *d_Code_Value;
  char *d_Coding_Scheme_Designator;
  char *d_Collimator_Type;
  char *d_Collimator_grid_name;
  char *d_Distance_Source_to_Detector;
  char *d_Energy_Window_Lower_Limit;
  char *d_Energy_Window_Name;
  char *d_Energy_Window_Upper_Limit;
  char *d_Field_of_View_Dimension_s_;
  char *d_Field_of_View_Shape;
  char *d_Focal_Distance;
  char *d_Frame_Time;
  char *d_Framing_Type;
  char *d_Gantry_Detector_Tilt;
  char *d_High_R_R_Value;
  char *d_Image_Orientation__Patient;
  char *d_Image_Position__Patient;
  char *d_Intervals_Acquired;
  char *d_Intervals_Rejected;
  char *d_Intervention_Drug_Name;
  char *d_Interventional_Drug_Dose;
  char *d_Interventional_Drug_Start_Time;
  char *d_Interventional_Drug_Stop_Time;
  char *d_LUT_Explanation;
  char *d_Low_R_R_Value;
  char *d_Modality_LUT_Type;
  char *d_Nominal_Interval;
  char *d_Pause_Between_Frames;
  char *d_Phase_Delay;
  char *d_Radial_Position;
  char *d_Radionuclide_Total_Dose;
  char *d_Radiopharmaceutical;
  char *d_Radiopharmaceutical_Route;
  char *d_Radiopharmaceutical_Start_Time;
  char *d_Radiopharmaceutical_Stop_Time;
  char *d_Radiopharmaceutical_Volume;
  char *d_Referenced_SOP_Class_UID;
  char *d_Referenced_SOP_Instance_UID;
  char *d_Residual_Syringe_Counts;
  char *d_Rotation_Direction;
  char *d_Scan_Arc;
  char *d_Start_Angle;
  char *d_Syringe_Counts;
  char *d_Table_Height_TOMO;
  char *d_Table_Traverse_TOMO;
  char *d_Time_Slot_Time;
  char *d_Trigger_Time;
  char *d_Trigger_Vector;
  char *d_X_Focus_Center;
  char *d_Y_Focus_Center;
  char *d_Zoom_Center;
  char *d_Zoom_Factor;
  short *d_LUT_Data;
  short d_LUT_Descriptor[3];
  unsigned long l_LUT_Data;
  unsigned short d_Energy_Window_Number;
  unsigned short d_Number_of_Frames_in_Phase;
  unsigned short d_Number_of_Frames_in_Rotation;
  unsigned short d_Number_of_Triggers_in_Phase;
  unsigned short d_Referenced_Overlay_Group;
 
  short i_Data_Information;
  short i_Detector_Information;
  short i_Energy_Window_Information;
  short i_Gated_Information;
  short i_Intervention_Drug_Information;
  short i_Radiopharmaceutical_Information;

  unsigned short number_of_frames;

  char type1[SHORTSTRINGLEN];
  char type2[SHORTSTRINGLEN];
  char type3[SHORTSTRINGLEN];
  char type4[SHORTSTRINGLEN];

  char stamp[16];
} S_i2dvars;

typedef struct {
  S_pd_buffer *buffer;
  short line;
  short pos;
  short asciilist;
  blockdef blockcodes[10];
  short blocknumber;
  INTERFILEdef *Idef;
  S_IAppData *IApp;
} INTERFILEdefIO;

typedef struct {
  S_pd_buffer *buffer;
  short line;
  short pos;
  INTERFILE *I;
  S_IAppData *IApp;
} INTERFILEIO;

char *normalizeinterkey PROTO((char *key, char *normkey));

short putinterdefkey PROTO((INTERFILEdefIO *Idefio, char *key, BOOL obligatory,
        EKT typeofkey, EVT typeofvalue, char *defaultvalue, char **values));
short putIFSTARTdef PROTO((INTERFILEdefIO *Idefio));
short putIFBODYdef PROTO((INTERFILEdefIO *Idefio, char *key, char *value));
short putIFENDdef PROTO((INTERFILEdefIO *Idefio, char *key));
short putFORSTARTdef PROTO((INTERFILEdefIO *Idefio));
short putFORBODYdef PROTO((INTERFILEdefIO *Idefio, char *key, char *localkey));
short putFORENDdef PROTO((INTERFILEdefIO *Idefio, char *key));

short IF2DCM_compile PROTO((S_AppData *App, DicomObject *O, INTERFILE *I));
short interfile_LibraryInit(void *app_private, char *cmdline) ;

#ifdef __cplusplus
}
#endif

#endif /* !__LIBIDICON_H */
